/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.api;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.api.ComponentType;
import org.apache.felix.ipojo.api.Dependency;
import org.apache.felix.ipojo.api.HandlerConfiguration;
import org.apache.felix.ipojo.api.Property;
import org.apache.felix.ipojo.api.Service;
import org.apache.felix.ipojo.api.TemporalDependency;
import org.apache.felix.ipojo.manipulation.Manipulator;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.BundleContext;

public class PrimitiveComponentType
extends ComponentType {
    private BundleContext m_context;
    private String m_classname;
    private String m_name;
    private String m_version;
    private boolean m_immediate;
    private Element m_manipulation;
    private ComponentFactory m_factory;
    private Element m_metadata;
    private List m_services = new ArrayList(1);
    private List m_dependencies = new ArrayList();
    private List m_properties = new ArrayList();
    private String m_validate;
    private String m_invalidate;
    private String m_updated;
    private boolean m_propagation;
    private String m_factoryMethod;
    private boolean m_public = true;
    private String m_msPID;
    private ArrayList m_temporals = new ArrayList();
    private List m_handlers = new ArrayList();

    private void ensureNotInitialized() {
        if (this.m_factory != null) {
            throw new IllegalStateException("The component type was already initialized, cannot modify metadata");
        }
    }

    private void ensureValidity() {
        if (this.m_classname == null) {
            throw new IllegalStateException("The primitive component type has no implementation class");
        }
        if (this.m_context == null) {
            throw new IllegalStateException("The primitive component type has no bundle context");
        }
    }

    public Factory getFactory() {
        this.initializeFactory();
        return this.m_factory;
    }

    public void start() {
        this.initializeFactory();
        this.m_factory.start();
    }

    public void stop() {
        this.initializeFactory();
        this.m_factory.stop();
    }

    private void initializeFactory() {
        if (this.m_factory == null) {
            this.createFactory();
        }
    }

    public PrimitiveComponentType setBundleContext(BundleContext bc) {
        this.ensureNotInitialized();
        this.m_context = bc;
        return this;
    }

    public PrimitiveComponentType setClassName(String classname) {
        this.ensureNotInitialized();
        this.m_classname = classname;
        return this;
    }

    public PrimitiveComponentType setComponentTypeName(String name) {
        this.ensureNotInitialized();
        this.m_name = name;
        return this;
    }

    public PrimitiveComponentType setComponentTypeVersion(String version) {
        this.ensureNotInitialized();
        this.m_version = version;
        return this;
    }

    public PrimitiveComponentType setImmediate(boolean immediate) {
        this.ensureNotInitialized();
        this.m_immediate = immediate;
        return this;
    }

    public PrimitiveComponentType setFactoryMethod(String method) {
        this.ensureNotInitialized();
        this.m_factoryMethod = method;
        return this;
    }

    public PrimitiveComponentType setPropagation(boolean propagation) {
        this.ensureNotInitialized();
        this.m_propagation = propagation;
        return this;
    }

    public PrimitiveComponentType setPublic(boolean visible) {
        this.ensureNotInitialized();
        this.m_public = visible;
        return this;
    }

    public PrimitiveComponentType setManagedServicePID(String pid) {
        this.ensureNotInitialized();
        this.m_msPID = pid;
        return this;
    }

    public PrimitiveComponentType setValidateMethod(String method) {
        this.ensureNotInitialized();
        this.m_validate = method;
        return this;
    }

    public PrimitiveComponentType setInvalidateMethod(String method) {
        this.ensureNotInitialized();
        this.m_invalidate = method;
        return this;
    }

    public PrimitiveComponentType setUpdatedMethod(String method) {
        this.ensureNotInitialized();
        this.m_updated = method;
        return this;
    }

    private Element generateComponentMetadata() {
        HandlerConfiguration dep;
        int i;
        Element element = new Element("component", "");
        element.addAttribute(new Attribute("classname", this.m_classname));
        if (this.m_name != null) {
            element.addAttribute(new Attribute("name", this.m_name));
        }
        if (this.m_version != null) {
            element.addAttribute(new Attribute("version", this.m_version));
        }
        if (this.m_factoryMethod != null) {
            element.addAttribute(new Attribute("factory-method", this.m_factoryMethod));
        }
        if (!this.m_public) {
            element.addAttribute(new Attribute("public", "false"));
        }
        if (this.m_immediate) {
            element.addAttribute(new Attribute("immediate", "true"));
        }
        for (i = 0; i < this.m_services.size(); ++i) {
            Service svc = (Service)this.m_services.get(i);
            element.addElement(svc.getElement());
        }
        for (i = 0; i < this.m_dependencies.size(); ++i) {
            dep = (Dependency)this.m_dependencies.get(i);
            element.addElement(((Dependency)dep).getElement());
        }
        for (i = 0; i < this.m_temporals.size(); ++i) {
            dep = (TemporalDependency)this.m_temporals.get(i);
            element.addElement(((TemporalDependency)dep).getElement());
        }
        if (this.m_validate != null) {
            Element callback = new Element("callback", "");
            callback.addAttribute(new Attribute("transition", "validate"));
            callback.addAttribute(new Attribute("method", this.m_validate));
            element.addElement(callback);
        }
        if (this.m_invalidate != null) {
            Element callback = new Element("callback", "");
            callback.addAttribute(new Attribute("transition", "invalidate"));
            callback.addAttribute(new Attribute("method", this.m_invalidate));
            element.addElement(callback);
        }
        if (this.m_propagation || this.m_msPID != null || !this.m_properties.isEmpty()) {
            Element properties = new Element("properties", "");
            if (this.m_propagation) {
                properties.addAttribute(new Attribute("propagation", "true"));
            }
            if (this.m_msPID != null) {
                properties.addAttribute(new Attribute("pid", this.m_msPID));
            }
            if (this.m_updated != null) {
                properties.addAttribute(new Attribute("updated", this.m_updated));
            }
            for (int i2 = 0; i2 < this.m_properties.size(); ++i2) {
                Property prop = (Property)this.m_properties.get(i2);
                properties.addElement(prop.getElement());
            }
            element.addElement(properties);
        }
        for (int i3 = 0; i3 < this.m_handlers.size(); ++i3) {
            HandlerConfiguration hc = (HandlerConfiguration)this.m_handlers.get(i3);
            element.addElement(hc.getElement());
        }
        return element;
    }

    public PrimitiveComponentType addHandler(HandlerConfiguration handler) {
        this.m_handlers.add(handler);
        return this;
    }

    private void createFactory() {
        this.ensureValidity();
        byte[] clazz = this.manipulate();
        Element meta = this.m_metadata = this.generateComponentMetadata();
        meta.addElement(this.m_manipulation);
        try {
            this.m_factory = clazz.length == 0 ? new ComponentFactory(this.m_context, meta) : new ComponentFactory(this.m_context, clazz, meta);
            this.m_factory.start();
        }
        catch (ConfigurationException e) {
            throw new IllegalStateException("An exception occurs during factory initialization : " + e.getMessage());
        }
    }

    private byte[] manipulate() {
        Manipulator manipulator = new Manipulator();
        try {
            byte[] array = this.getClassByteArray();
            byte[] newclazz = manipulator.manipulate(array);
            this.m_manipulation = manipulator.getManipulationMetadata();
            return newclazz;
        }
        catch (IOException e) {
            throw new IllegalStateException("An exception occurs during implementation class manipulation : " + e.getMessage());
        }
    }

    private byte[] getClassByteArray() throws IOException {
        String filename = this.m_classname.replace('.', '/') + ".class";
        URL url = this.m_context.getBundle().getResource(filename);
        if (url == null) {
            throw new IllegalStateException("An exception occurs during implementation class manipulation : cannot found the class file " + filename);
        }
        InputStream is = url.openStream();
        if (is == null) {
            throw new IllegalStateException("An exception occurs during implementation class manipulation : cannot read the class file " + url);
        }
        byte[] b = new byte[is.available()];
        is.read(b);
        return b;
    }

    public PrimitiveComponentType addService(Service svc) {
        this.ensureNotInitialized();
        this.m_services.add(svc);
        return this;
    }

    public PrimitiveComponentType addDependency(Dependency dep) {
        this.ensureNotInitialized();
        this.m_dependencies.add(dep);
        return this;
    }

    public PrimitiveComponentType addDependency(TemporalDependency dep) {
        this.ensureNotInitialized();
        this.m_temporals.add(dep);
        return this;
    }

    public PrimitiveComponentType addProperty(Property prop) {
        this.ensureNotInitialized();
        this.m_properties.add(prop);
        return this;
    }

    public PrimitiveComponentType addProperty(String key, Object obj) {
        String value = null;
        if (obj != null) {
            value = obj.toString();
        }
        this.addProperty(new Property().setName(key).setValue(value));
        return this;
    }
}

