/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.rest.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbeException;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.jasmine.probe.api.generated.ErrorType;
import org.ow2.jasmine.probe.api.generated.OutputBaseType;
import org.ow2.jasmine.probe.api.generated.OutputResource;
import org.ow2.jasmine.probe.api.generated.PropType;
import org.ow2.jasmine.probe.rest.Outputs;
import org.ow2.jasmine.probe.rest.impl.RestUtil;

public class JOutputs
implements Outputs {
    private JasmineProbeManager jpManager = null;

    public JOutputs(JasmineProbeManager jpManager) {
        this.jpManager = jpManager;
    }

    @Override
    public Response getOutput(String name, UriInfo ui) {
        JasmineOutput jout;
        UriBuilder ub = ui.getAbsolutePathBuilder();
        String outUri = ub.build(new Object[]{""}).toString();
        String baseUri = outUri.substring(0, outUri.lastIndexOf(name));
        try {
            jout = this.jpManager.getOutput(name);
        }
        catch (JasmineProbeException e) {
            ErrorType err = new ErrorType();
            err.setMessage(e.getMessage());
            QName qname = new QName("org.ow2.jasmine.probe:probe-config", "error");
            JAXBElement errElem = new JAXBElement(qname, ErrorType.class, (Object)err);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errElem).type("application/xml").build();
        }
        OutputResource output = new OutputResource();
        output.setName(name);
        output.setType(jout.getType());
        output.setHref(outUri);
        ArrayList<PropType> property = new ArrayList<PropType>();
        for (String propKey : jout.getProperties().keySet()) {
            String propValue = (String)jout.getProperties().get(propKey);
            PropType prop = new PropType();
            prop.setValue(propValue);
            prop.setKey(propKey);
            property.add(prop);
        }
        output.setProperty(property);
        QName qname = new QName("org.ow2.jasmine.probe:probe-config", "output");
        JAXBElement outResource = new JAXBElement(qname, OutputResource.class, (Object)output);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)outResource).type(MediaType.APPLICATION_XML_TYPE).build();
    }

    @Override
    public Response getOutputs(String type, boolean verbose, UriInfo ui) {
        ArrayList<JAXBElement> elementsList = new ArrayList<JAXBElement>();
        List outList = this.jpManager.getOutputs();
        for (JasmineOutput out : outList) {
            String outType = out.getType();
            if (type != null && !type.equals(outType)) continue;
            String outName = out.getName();
            OutputResource outElement = new OutputResource();
            outElement.setName(out.getName());
            URI outUri = ui.getAbsolutePathBuilder().path(outName).build(new Object[0]);
            outElement.setHref(outUri.toString());
            if (verbose) {
                outElement.setType(outType);
            }
            QName name = new QName("org.ow2.jasmine.probe:probe-config", "output");
            JAXBElement xmlElement = new JAXBElement(name, OutputResource.class, (Object)outElement);
            elementsList.add(xmlElement);
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new GenericEntity<List<JAXBElement<OutputResource>>>(elementsList){}).type(MediaType.APPLICATION_XML_TYPE).build();
    }

    @Override
    public Response createOutput(OutputBaseType outputDef) {
        JasmineOutput output = new JasmineOutput();
        output.setName(outputDef.getName());
        output.setType(outputDef.getType());
        HashMap<String, String> properties = new HashMap<String, String>();
        for (PropType prop : outputDef.getProperty()) {
            properties.put(prop.getKey(), prop.getValue());
        }
        output.setProperties(properties);
        try {
            this.jpManager.createOutput(output);
            if (outputDef.getDefault()) {
                this.jpManager.addDefaultOutput(outputDef.getName());
            }
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.BAD_REQUEST);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Override
    public Response changeOutput(OutputBaseType outputDef, String name) {
        try {
            this.jpManager.getOutput(name);
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.NOT_FOUND);
        }
        JasmineOutput output = new JasmineOutput();
        output.setName(name);
        output.setType(outputDef.getType());
        HashMap<String, String> properties = new HashMap<String, String>();
        for (PropType prop : outputDef.getProperty()) {
            properties.put(prop.getKey(), prop.getValue());
        }
        output.setProperties(properties);
        try {
            this.jpManager.changeOutput(output);
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.BAD_REQUEST);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Override
    public Response deleteOutput(String name) {
        try {
            this.jpManager.removeOutput(name);
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.NOT_FOUND);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

