/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.security;

import java.util.StringTokenizer;
import org.mule.MuleManager;
import org.mule.config.i18n.CoreMessages;
import org.mule.umo.UMOEncryptionStrategy;
import org.mule.umo.security.CryptoFailureException;
import org.mule.umo.security.EncryptionStrategyNotFoundException;
import org.mule.umo.security.UMOCredentials;
import org.mule.umo.security.UMOSecurityManager;
import org.mule.util.ArrayUtils;

public class MuleCredentials
implements UMOCredentials {
    public static final String TOKEN_DELIM = "::";
    private final String username;
    private final char[] password;
    private Object roles;

    public MuleCredentials(String username, char[] password) {
        this.username = username;
        this.password = ArrayUtils.clone(password);
    }

    public MuleCredentials(String username, char[] password, Object roles) {
        this.username = username;
        this.password = ArrayUtils.clone(password);
        this.roles = roles;
    }

    public MuleCredentials(String header) throws EncryptionStrategyNotFoundException, CryptoFailureException {
        String scheme = null;
        int i = header.indexOf(32);
        if (i == -1) {
            throw new IllegalArgumentException(CoreMessages.headerMalformedValueIs("MULE_USER", header).toString());
        }
        scheme = header.substring(0, i);
        String creds = header.substring(i + 1);
        if (!scheme.equalsIgnoreCase("plain")) {
            UMOSecurityManager sm = MuleManager.getInstance().getSecurityManager();
            UMOEncryptionStrategy es = sm.getEncryptionStrategy(scheme);
            if (es == null) {
                throw new EncryptionStrategyNotFoundException(scheme);
            }
            creds = new String(es.decrypt(creds.getBytes(), null));
        }
        StringTokenizer st = new StringTokenizer(creds, TOKEN_DELIM);
        this.username = st.nextToken();
        this.password = st.nextToken().toCharArray();
        if (st.hasMoreTokens()) {
            this.roles = st.nextToken();
        }
    }

    public String getToken() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.username).append(TOKEN_DELIM);
        buf.append(this.password).append(TOKEN_DELIM);
        if (this.roles != null) {
            buf.append(this.roles);
        }
        return buf.toString();
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return ArrayUtils.clone(this.password);
    }

    public Object getRoles() {
        return this.roles;
    }

    public static String createHeader(String username, char[] password) {
        StringBuffer buf = new StringBuffer(32);
        buf.append("Plain ");
        buf.append(username).append(TOKEN_DELIM);
        buf.append(password).append(TOKEN_DELIM);
        return buf.toString();
    }

    public static String createHeader(String username, String password, String encryptionName, UMOEncryptionStrategy es) throws CryptoFailureException {
        StringBuffer buf = new StringBuffer();
        buf.append(encryptionName).append(" ");
        String creds = username + TOKEN_DELIM + password;
        byte[] encrypted = es.encrypt(creds.getBytes(), null);
        buf.append(new String(encrypted));
        return buf.toString();
    }
}

