/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.providers.tcp.PooledSocketFactory;
import org.mule.providers.tcp.TcpConnector;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.util.MapUtils;

public class TcpSocketFactory
implements PooledSocketFactory {
    private static final Log logger = LogFactory.getLog((Class)TcpSocketFactory.class);

    public Object makeObject(Object key) throws Exception {
        UMOImmutableEndpoint ep = (UMOImmutableEndpoint)key;
        int port = ep.getEndpointURI().getPort();
        InetAddress inetAddress = InetAddress.getByName(ep.getEndpointURI().getHost());
        Socket socket = this.createSocket(port, inetAddress);
        socket.setReuseAddress(true);
        TcpConnector connector = (TcpConnector)ep.getConnector();
        if (connector.getReceiveBufferSize() != -1 && socket.getReceiveBufferSize() != connector.getReceiveBufferSize()) {
            socket.setReceiveBufferSize(connector.getReceiveBufferSize());
        }
        if (connector.getSendBufferSize() != -1 && socket.getSendBufferSize() != connector.getSendBufferSize()) {
            socket.setSendBufferSize(connector.getSendBufferSize());
        }
        if (connector.getReceiveTimeout() != -1 && socket.getSoTimeout() != connector.getReceiveTimeout()) {
            socket.setSoTimeout(connector.getSendTimeout());
        }
        socket.setTcpNoDelay(connector.isSendTcpNoDelay());
        socket.setKeepAlive(connector.isKeepAlive());
        return socket;
    }

    protected Socket createSocket(int port, InetAddress inetAddress) throws IOException {
        return new Socket(inetAddress, port);
    }

    public void destroyObject(Object key, Object object) throws Exception {
        Socket socket = (Socket)object;
        if (!socket.isClosed()) {
            socket.close();
        }
    }

    public boolean validateObject(Object key, Object object) {
        Socket socket = (Socket)object;
        return !socket.isClosed();
    }

    public void activateObject(Object key, Object object) throws Exception {
    }

    public void passivateObject(Object key, Object object) throws Exception {
        UMOImmutableEndpoint ep = (UMOImmutableEndpoint)key;
        boolean keepSocketOpen = MapUtils.getBooleanValue((Map)ep.getProperties(), (Object)"keepSendSocketOpen", (boolean)((TcpConnector)ep.getConnector()).isKeepSendSocketOpen());
        Socket socket = (Socket)object;
        if (!keepSocketOpen) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException e) {
                logger.debug((Object)("Failed to close socket after dispatch: " + e.getMessage()));
            }
        }
    }
}

