/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.udp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import org.mule.impl.ThreadSafeAccess;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.umo.provider.MessageTypeNotSupportedException;

public class UdpMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = -7767141617682012504L;
    public static final String ADDRESS_PROPERTY = "packet.address";
    public static final String PORT_PROPERTY = "packet.port";
    private byte[] message;

    public UdpMessageAdapter(Object message) throws MessageTypeNotSupportedException {
        DatagramPacket dp;
        if (message instanceof DatagramPacket) {
            dp = (DatagramPacket)message;
            this.message = new byte[dp.getLength()];
            System.arraycopy(dp.getData(), 0, this.message, 0, dp.getLength());
            InetAddress address = dp.getAddress();
            if (address != null) {
                this.setProperty(ADDRESS_PROPERTY, address);
            }
        } else {
            throw new MessageTypeNotSupportedException(message, this.getClass());
        }
        this.setProperty(PORT_PROPERTY, new Integer(dp.getPort()));
    }

    protected UdpMessageAdapter(UdpMessageAdapter template) {
        super(template);
        this.message = template.message;
    }

    public String getPayloadAsString(String encoding) throws Exception {
        return new String(this.message, encoding);
    }

    public byte[] getPayloadAsBytes() throws Exception {
        return this.message;
    }

    public Object getPayload() {
        return this.message;
    }

    public ThreadSafeAccess newThreadCopy() {
        return new UdpMessageAdapter(this);
    }
}

