/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleMessage;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.routing.RoutingException;

public class MessageChunkingRouter
extends FilteringOutboundRouter {
    private int chunkSize = 0;
    private int numberOfMessages = 1;

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getNumberOfMessages() {
        return this.numberOfMessages;
    }

    public void setNumberOfMessages(int numberOfMessages) {
        this.numberOfMessages = numberOfMessages;
    }

    public UMOMessage route(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        if (this.chunkSize == 0 && this.numberOfMessages < 2) {
            return super.route(message, session, synchronous);
        }
        if (this.chunkSize > 0) {
            byte[] data = new byte[]{};
            try {
                data = message.getPayloadAsBytes();
            }
            catch (Exception e) {
                throw new RoutingException(CoreMessages.failedToReadPayload(), message, this.getEndpoint(0, message), e);
            }
            int parts = data.length / this.chunkSize;
            if (parts * this.chunkSize < data.length) {
                ++parts;
            }
            int len = this.chunkSize;
            MuleMessage part = null;
            int pos = 0;
            byte[] buffer = null;
            try {
                for (int count = 0; count < parts; ++count) {
                    if (pos + len > data.length) {
                        len = data.length - pos;
                    }
                    buffer = new byte[len];
                    System.arraycopy(data, pos, buffer, 0, buffer.length);
                    pos += len;
                    part = new MuleMessage((Object)buffer, message);
                    part.setCorrelationId(message.getUniqueId());
                    part.setCorrelationGroupSize(parts);
                    part.setCorrelationSequence(count);
                    super.route(part, session, synchronous);
                }
            }
            catch (RoutingException e) {
                e = new RoutingException(e.getI18nMessage(), e.getUmoMessage(), e.getEndpoint(), e.getCause());
                throw e;
            }
        }
        return message;
    }
}

