/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.df.internal;

import java.util.ArrayList;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.annotations.Validate;
import org.ow2.jasmine.probe.JasmineCollectorInfo;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollectorService;
import org.ow2.jasmine.probe.collectors.df.internal.DfCollector;
import org.ow2.jasmine.probe.collectors.df.internal.DiskFree;
import org.ow2.jasmine.probe.probemanager.ProbeManager;

@Component(name="DfCollectorService")
@Provides
public class DfCollectorService
extends JCollectorService
implements Pojo {
    private InstanceManager __IM;
    public static final String SHORT_DESC = "Make a df command (linux only)";
    public static final String LONG_DESC = "Get the used space on a disk, in percent. If no disk is specified, all disks are checked.";
    public static final String SOURCE_DESC = "No source indicator used.";
    public static final int SOURCE_MIN = 0;
    public static final int SOURCE_MAX = 0;
    public static final String PROP_DISK = "disk";
    public static final String PROP_DISK_DESC = "device to check (pathname relative to /dev). Example: sda1. If not specified: all the devices are checked.";
    private boolean __Fdf;
    protected DiskFree df;
    private boolean __FindicatorType;
    @ServiceProperty(name="indicator.type", value="df")
    private String indicatorType;
    private boolean __FprobeManager;
    @Requires
    ProbeManager probeManager;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MgetCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe;

    DiskFree __getdf() {
        if (!this.__Fdf) {
            return this.df;
        }
        return (DiskFree)this.__IM.onGet((Object)this, "df");
    }

    void __setdf(DiskFree diskFree) {
        if (!this.__Fdf) {
            this.df = diskFree;
            return;
        }
        this.__IM.onSet((Object)this, "df", (Object)diskFree);
    }

    String __getindicatorType() {
        if (!this.__FindicatorType) {
            return this.indicatorType;
        }
        return (String)this.__IM.onGet((Object)this, "indicatorType");
    }

    void __setindicatorType(String string) {
        if (!this.__FindicatorType) {
            this.indicatorType = string;
            return;
        }
        this.__IM.onSet((Object)this, "indicatorType", (Object)string);
    }

    ProbeManager __getprobeManager() {
        if (!this.__FprobeManager) {
            return this.probeManager;
        }
        return (ProbeManager)this.__IM.onGet((Object)this, "probeManager");
    }

    void __setprobeManager(ProbeManager probeManager) {
        if (!this.__FprobeManager) {
            this.probeManager = probeManager;
            return;
        }
        this.__IM.onSet((Object)this, "probeManager", (Object)probeManager);
    }

    public DfCollectorService() {
        this(null);
    }

    private DfCollectorService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setdf(null);
        this.__setprobeManager(null);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __start() {
        this.collectorInfo = new JasmineCollectorInfo();
        this.collectorInfo.setType(this.__getindicatorType());
        this.collectorInfo.setShortDesc(SHORT_DESC);
        this.collectorInfo.setLongDesc(LONG_DESC);
        this.collectorInfo.setSourceDesc(SOURCE_DESC);
        this.collectorInfo.setSourceMin(0);
        this.collectorInfo.setSourceMax(0);
        this.properties = new ArrayList();
        this.properties.add(new JasminePropertyInfo(PROP_DISK, PROP_DISK_DESC, false));
        this.collectorInfo.setPropertyInfos(this.properties);
        this.__setdf(new DiskFree());
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __stop() {
        this.removeCollectors(null, null);
        this.__getdf().remove();
        this.__setdf(null);
    }

    public synchronized JasmineCollector getCollector(JasmineIndicator jasmineIndicator, JasmineProbe jasmineProbe) throws JasmineCollectorException {
        JasmineCollector jasmineCollector;
        if (!this.__MgetCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe) {
            return this.__getCollector(jasmineIndicator, jasmineProbe);
        }
        try {
            this.__IM.onEntry((Object)this, "getCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe", new Object[]{jasmineIndicator, jasmineProbe});
            jasmineCollector = this.__getCollector(jasmineIndicator, jasmineProbe);
            this.__IM.onExit((Object)this, "getCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe", (Object)jasmineCollector);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe", throwable);
            throw throwable;
        }
        return jasmineCollector;
    }

    private JasmineCollector __getCollector(JasmineIndicator indicator, JasmineProbe probe) throws JasmineCollectorException {
        DfCollector collector = new DfCollector(probe.getId(), indicator, probe.getPeriod());
        collector.setProbeManager(this.__getprobeManager());
        this.addCollector(indicator.getName(), collector);
        this.__getdf().addCollector(collector);
        return collector;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("probeManager")) {
                this.__FprobeManager = true;
            }
            if (set.contains("indicatorType")) {
                this.__FindicatorType = true;
            }
            if (set.contains("df")) {
                this.__Fdf = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("getCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe")) {
                this.__MgetCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

