/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.dependency;

import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.IPojoContext;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.PolicyServiceContext;
import org.apache.felix.ipojo.PrimitiveHandler;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.handlers.dependency.Dependency;
import org.apache.felix.ipojo.handlers.dependency.DependencyCallback;
import org.apache.felix.ipojo.handlers.dependency.DependencyHandlerDescription;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.FieldMetadata;
import org.apache.felix.ipojo.parser.MethodMetadata;
import org.apache.felix.ipojo.parser.PojoMetadata;
import org.apache.felix.ipojo.util.DependencyModel;
import org.apache.felix.ipojo.util.DependencyStateListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public class DependencyHandler
extends PrimitiveHandler
implements DependencyStateListener,
Pojo {
    private InstanceManager __IM;
    public static final String PROXY_SETTINGS_PROPERTY = "ipojo.proxy";
    public static final String PROXY_TYPE_PROPERTY = "ipojo.proxy.type";
    public static final String SMART_PROXY = "smart";
    public static final String DYNAMIC_PROXY = "dynamic-proxy";
    public static final String PROXY_ENABLED = "enabled";
    public static final String PROXY_DISABLED = "disabled";
    protected static final int VECTOR = 2;
    protected static final int LIST = 1;
    protected static final int SET = 3;
    private boolean __Fm_dependencies;
    private Dependency[] m_dependencies;
    private boolean __Fm_started;
    private boolean m_started;
    private boolean __Fm_description;
    private DependencyHandlerDescription m_description;
    static /* synthetic */ Class class$org$osgi$framework$ServiceReference;
    static /* synthetic */ Class class$java$util$Dictionary;
    static /* synthetic */ Class class$java$util$Map;
    private boolean __MaddDependency$org_apache_felix_ipojo_handlers_dependency_Dependency;
    private boolean __MgetDependencies;
    private boolean __Mvalidate$org_apache_felix_ipojo_util_DependencyModel;
    private boolean __Minvalidate$org_apache_felix_ipojo_util_DependencyModel;
    private boolean __McheckContext;
    private boolean __McheckDependency$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_parser_PojoMetadata;
    private boolean __MsetSpecification$org_apache_felix_ipojo_handlers_dependency_Dependency$java_lang_String$boolean;
    private boolean __Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary;
    private boolean __MgetRequiresFilters$java_lang_Object;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MonCreation$java_lang_Object;
    private boolean __MgetDescription;

    Dependency[] __getm_dependencies() {
        if (!this.__Fm_dependencies) {
            return this.m_dependencies;
        }
        return (Dependency[])this.__IM.onGet(this, "m_dependencies");
    }

    void __setm_dependencies(Dependency[] dependencyArray) {
        if (!this.__Fm_dependencies) {
            this.m_dependencies = dependencyArray;
            return;
        }
        this.__IM.onSet(this, "m_dependencies", dependencyArray);
    }

    boolean __getm_started() {
        if (!this.__Fm_started) {
            return this.m_started;
        }
        Object object = this.__IM.onGet(this, "m_started");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setm_started(boolean bl) {
        if (!this.__Fm_started) {
            this.m_started = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet(this, "m_started", bl2);
    }

    DependencyHandlerDescription __getm_description() {
        if (!this.__Fm_description) {
            return this.m_description;
        }
        return (DependencyHandlerDescription)this.__IM.onGet(this, "m_description");
    }

    void __setm_description(DependencyHandlerDescription dependencyHandlerDescription) {
        if (!this.__Fm_description) {
            this.m_description = dependencyHandlerDescription;
            return;
        }
        this.__IM.onSet(this, "m_description", dependencyHandlerDescription);
    }

    public DependencyHandler() {
        this(null);
    }

    private DependencyHandler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setm_dependencies(new Dependency[0]);
    }

    private void addDependency(Dependency dependency) {
        if (!this.__MaddDependency$org_apache_felix_ipojo_handlers_dependency_Dependency) {
            this.__M_addDependency(dependency);
            return;
        }
        try {
            this.__IM.onEntry(this, "addDependency$org_apache_felix_ipojo_handlers_dependency_Dependency", new Object[]{dependency});
            this.__M_addDependency(dependency);
            this.__IM.onExit(this, "addDependency$org_apache_felix_ipojo_handlers_dependency_Dependency", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "addDependency$org_apache_felix_ipojo_handlers_dependency_Dependency", throwable);
            throw throwable;
        }
    }

    private void __M_addDependency(Dependency dep) {
        for (int i = 0; this.__getm_dependencies() != null && i < this.__getm_dependencies().length; ++i) {
            if (this.__getm_dependencies()[i] != dep) continue;
            return;
        }
        if (this.__getm_dependencies() == null) {
            this.__setm_dependencies(new Dependency[]{dep});
        } else {
            Dependency[] newDep = new Dependency[this.__getm_dependencies().length + 1];
            System.arraycopy(this.__getm_dependencies(), 0, newDep, 0, this.__getm_dependencies().length);
            newDep[this.__getm_dependencies().length] = dep;
            this.__setm_dependencies(newDep);
        }
    }

    public Dependency[] getDependencies() {
        Dependency[] dependencyArray;
        if (!this.__MgetDependencies) {
            return this.__M_getDependencies();
        }
        try {
            this.__IM.onEntry(this, "getDependencies", new Object[0]);
            dependencyArray = this.__M_getDependencies();
            this.__IM.onExit(this, "getDependencies", dependencyArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "getDependencies", throwable);
            throw throwable;
        }
        return dependencyArray;
    }

    private Dependency[] __M_getDependencies() {
        return this.__getm_dependencies();
    }

    public void validate(DependencyModel dependencyModel) {
        if (!this.__Mvalidate$org_apache_felix_ipojo_util_DependencyModel) {
            this.__M_validate(dependencyModel);
            return;
        }
        try {
            this.__IM.onEntry(this, "validate$org_apache_felix_ipojo_util_DependencyModel", new Object[]{dependencyModel});
            this.__M_validate(dependencyModel);
            this.__IM.onExit(this, "validate$org_apache_felix_ipojo_util_DependencyModel", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "validate$org_apache_felix_ipojo_util_DependencyModel", throwable);
            throw throwable;
        }
    }

    private void __M_validate(DependencyModel dep) {
        this.checkContext();
    }

    public void invalidate(DependencyModel dependencyModel) {
        if (!this.__Minvalidate$org_apache_felix_ipojo_util_DependencyModel) {
            this.__M_invalidate(dependencyModel);
            return;
        }
        try {
            this.__IM.onEntry(this, "invalidate$org_apache_felix_ipojo_util_DependencyModel", new Object[]{dependencyModel});
            this.__M_invalidate(dependencyModel);
            this.__IM.onExit(this, "invalidate$org_apache_felix_ipojo_util_DependencyModel", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "invalidate$org_apache_felix_ipojo_util_DependencyModel", throwable);
            throw throwable;
        }
    }

    private void __M_invalidate(DependencyModel dep) {
        this.setValidity(false);
    }

    protected void checkContext() {
        if (!this.__McheckContext) {
            this.__M_checkContext();
            return;
        }
        try {
            this.__IM.onEntry(this, "checkContext", new Object[0]);
            this.__M_checkContext();
            this.__IM.onExit(this, "checkContext", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "checkContext", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_checkContext() {
        if (!this.__getm_started()) {
            return;
        }
        Dependency[] dependencyArray = this.__getm_dependencies();
        synchronized (dependencyArray) {
            boolean initialState = this.getValidity();
            boolean valid = true;
            for (int i = 0; i < this.__getm_dependencies().length; ++i) {
                Dependency dep = this.__getm_dependencies()[i];
                if (dep.getState() == 1) continue;
                valid = false;
                break;
            }
            if (valid) {
                if (!initialState) {
                    this.setValidity(true);
                }
            } else if (initialState) {
                this.setValidity(false);
            }
        }
    }

    private boolean checkDependency(Dependency dependency, PojoMetadata pojoMetadata) throws ConfigurationException {
        boolean bl;
        if (!this.__McheckDependency$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_parser_PojoMetadata) {
            return this.__M_checkDependency(dependency, pojoMetadata);
        }
        try {
            this.__IM.onEntry(this, "checkDependency$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_parser_PojoMetadata", new Object[]{dependency, pojoMetadata});
            bl = this.__M_checkDependency(dependency, pojoMetadata);
            this.__IM.onExit(this, "checkDependency$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_parser_PojoMetadata", new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "checkDependency$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_parser_PojoMetadata", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_checkDependency(Dependency dep, PojoMetadata manipulation) throws ConfigurationException {
        String type;
        String field = dep.getField();
        DependencyCallback[] callbacks = dep.getCallbacks();
        int index = dep.getConstructorParameterIndex();
        if (callbacks == null && field == null && index == -1) {
            throw new ConfigurationException("A service requirement requires at least binding methods, a field or a constructor parameter");
        }
        for (int i = 0; callbacks != null && i < callbacks.length; ++i) {
            MethodMetadata[] mets = manipulation.getMethods(callbacks[i].getMethodName());
            if (mets.length == 0) {
                this.debug("A requirement callback " + callbacks[i].getMethodName() + " does not exist in the implementation class, will try the super classes");
                continue;
            }
            if (mets[0].getMethodArguments().length > 2) {
                throw new ConfigurationException("Requirement Callback : A requirement callback " + callbacks[i].getMethodName() + " must have 0, 1 or 2 arguments");
            }
            callbacks[i].setArgument(mets[0].getMethodArguments());
            if (mets[0].getMethodArguments().length == 1) {
                if (mets[0].getMethodArguments()[0].equals((class$org$osgi$framework$ServiceReference == null ? DependencyHandler.class$("org.osgi.framework.ServiceReference") : class$org$osgi$framework$ServiceReference).getName())) continue;
                this.setSpecification(dep, mets[0].getMethodArguments()[0], false);
                continue;
            }
            if (mets[0].getMethodArguments().length != 2) continue;
            if (!(mets[0].getMethodArguments()[1].equals((class$org$osgi$framework$ServiceReference == null ? DependencyHandler.class$("org.osgi.framework.ServiceReference") : class$org$osgi$framework$ServiceReference).getName()) || mets[0].getMethodArguments()[1].equals((class$java$util$Dictionary == null ? DependencyHandler.class$("java.util.Dictionary") : class$java$util$Dictionary).getName()) || mets[0].getMethodArguments()[1].equals((class$java$util$Map == null ? DependencyHandler.class$("java.util.Map") : class$java$util$Map).getName()))) {
                String message = "The requirement callback " + callbacks[i].getMethodName() + " must have a ServiceReference, a Dictionary or a Map as the second argument";
                throw new ConfigurationException(message);
            }
            this.setSpecification(dep, mets[0].getMethodArguments()[0], false);
        }
        if (field != null) {
            FieldMetadata meta = manipulation.getField(field);
            if (meta == null) {
                throw new ConfigurationException("Requirement Callback : A requirement field " + field + " does not exist in the implementation class");
            }
            type = meta.getFieldType();
            if (type.endsWith("[]")) {
                if (dep.isProxy()) {
                    this.info("Arrays cannot be used for proxied dependencies - Disabling the proxy mode");
                    dep.setProxy(false);
                }
                dep.setAggregate(true);
                type = type.substring(0, type.length() - 2);
            } else if (type.equals(List.class.getName()) || type.equals(Collection.class.getName())) {
                dep.setType(1);
                type = null;
            } else if (type.equals(Vector.class.getName())) {
                dep.setType(2);
                if (dep.isProxy()) {
                    this.warn("Vectors cannot be used for proxied dependencies - Disabling the proxy mode");
                    dep.setProxy(false);
                }
                type = null;
            } else if (type.equals(Set.class.getName())) {
                dep.setType(3);
                type = null;
            } else if (dep.isAggregate()) {
                throw new ConfigurationException("A required service is not correct : the field " + meta.getFieldName() + " must be an array to support aggregate injections");
            }
            this.setSpecification(dep, type, true);
        }
        if (index != -1) {
            if (!dep.isProxy()) {
                throw new ConfigurationException("Services injected into constructor must be proxied");
            }
            MethodMetadata[] cts = manipulation.getConstructors();
            if (cts.length > 0 && cts[0].getMethodArguments().length > index) {
                type = cts[0].getMethodArguments()[index];
                if (type.endsWith("[]")) {
                    throw new ConfigurationException("Services injected into constructor cannot be arrays");
                }
                if (type.equals(List.class.getName()) || type.equals(Collection.class.getName())) {
                    dep.setType(1);
                    type = null;
                } else {
                    if (type.equals(Vector.class.getName())) {
                        throw new ConfigurationException("Services injected into constructor cannot be Vectors");
                    }
                    if (type.equals(Set.class.getName())) {
                        dep.setType(3);
                        type = null;
                    } else if (dep.isAggregate()) {
                        throw new ConfigurationException("A required service is not correct : the constructor parameter " + index + " must be an aggregate type to support aggregate injections");
                    }
                }
                this.setSpecification(dep, type, true);
            } else {
                throw new ConfigurationException("Cannot determine the specification of the dependency " + index + ", please use the specification attribute");
            }
        }
        if (!dep.isAggregate() && dep.isProxy() && !dep.getSpecification().isInterface()) {
            this.warn("Proxies cannot be used on service dependency targetting non interface service specification " + dep.getSpecification().getName());
            dep.setProxy(false);
        }
        return dep.getSpecification() != null;
    }

    private void setSpecification(Dependency dependency, String string, boolean bl) throws ConfigurationException {
        if (!this.__MsetSpecification$org_apache_felix_ipojo_handlers_dependency_Dependency$java_lang_String$boolean) {
            this.__M_setSpecification(dependency, string, bl);
            return;
        }
        try {
            this.__IM.onEntry(this, "setSpecification$org_apache_felix_ipojo_handlers_dependency_Dependency$java_lang_String$boolean", new Object[]{dependency, string, new Boolean(bl)});
            this.__M_setSpecification(dependency, string, bl);
            this.__IM.onExit(this, "setSpecification$org_apache_felix_ipojo_handlers_dependency_Dependency$java_lang_String$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "setSpecification$org_apache_felix_ipojo_handlers_dependency_Dependency$java_lang_String$boolean", throwable);
            throw throwable;
        }
    }

    private void __M_setSpecification(Dependency dep, String className, boolean error) throws ConfigurationException {
        if (className == null) {
            if (dep.getSpecification() == null) {
                if (error) {
                    String id = dep.getId();
                    if (id == null && (id = dep.getField()) == null) {
                        id = Integer.toString(dep.getConstructorParameterIndex());
                    }
                    throw new ConfigurationException("Cannot discover the required specification for " + id);
                }
                this.info("Cannot discover the required specification for " + dep.getField());
            }
        } else if (dep.getSpecification() == null || !dep.getSpecification().getName().equals(className)) {
            if (dep.getSpecification() != null) {
                if (error) {
                    throw new ConfigurationException("A required service is not correct : the discovered type [" + className + "] and the specified (or already discovered)  service interface [" + dep.getSpecification().getName() + "] are not the same");
                }
                this.warn("[" + this.getInstanceManager().getInstanceName() + "] The field type [" + className + "] and the required service interface [" + dep.getSpecification() + "] are not the same");
            }
            try {
                dep.setSpecification(this.getInstanceManager().getContext().getBundle().loadClass(className));
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("The required service interface cannot be loaded : " + e.getMessage());
            }
        }
    }

    public void configure(Element element, Dictionary dictionary) throws ConfigurationException {
        if (!this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary) {
            this.__M_configure(element, dictionary);
            return;
        }
        try {
            this.__IM.onEntry(this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", new Object[]{element, dictionary});
            this.__M_configure(element, dictionary);
            this.__IM.onExit(this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __M_configure(Element componentMetadata, Dictionary configuration) throws ConfigurationException {
        PojoMetadata manipulation = this.getFactory().getPojoMetadata();
        boolean atLeastOneField = false;
        Element[] deps = componentMetadata.getElements("Requires");
        Dictionary filtersConfiguration = this.getRequiresFilters(configuration.get("requires.filters"));
        Dictionary fromConfiguration = (Dictionary)configuration.get("requires.from");
        for (int i = 0; deps != null && i < deps.length; ++i) {
            String field = deps[i].getAttribute("field");
            String serviceSpecification = deps[i].getAttribute("interface");
            if (serviceSpecification != null) {
                this.warn("The 'interface' attribute is deprecated, use the 'specification' attribute instead");
            } else {
                serviceSpecification = deps[i].getAttribute("specification");
            }
            String filter = deps[i].getAttribute("filter");
            String opt = deps[i].getAttribute("optional");
            boolean optional = opt != null && opt.equalsIgnoreCase("true");
            String defaultImplem = deps[i].getAttribute("default-implementation");
            String agg = deps[i].getAttribute("aggregate");
            boolean aggregate = agg != null && agg.equalsIgnoreCase("true");
            String identitity = deps[i].getAttribute("id");
            String nul = deps[i].getAttribute("nullable");
            boolean nullable = nul == null || nul.equalsIgnoreCase("true");
            boolean isProxy = true;
            String setting = this.getInstanceManager().getContext().getProperty(PROXY_SETTINGS_PROPERTY);
            if (setting == null || PROXY_ENABLED.equals(setting)) {
                isProxy = true;
            } else if (setting != null && PROXY_DISABLED.equals(setting)) {
                isProxy = false;
            }
            String proxy = deps[i].getAttribute("proxy");
            if (proxy != null) {
                if (proxy.equals("false")) {
                    isProxy = false;
                } else if (proxy.equals("true")) {
                    if (!isProxy) {
                        this.warn("The configuration of a service dependency overrides the proxy mode");
                    }
                    isProxy = true;
                }
            }
            String scope = deps[i].getAttribute("scope");
            BundleContext context = this.getInstanceManager().getContext();
            if (scope != null) {
                if (scope.equalsIgnoreCase("global") || ((IPojoContext)this.getInstanceManager().getContext()).getServiceContext() == null) {
                    context = new PolicyServiceContext(this.getInstanceManager().getGlobalContext(), this.getInstanceManager().getLocalServiceContext(), 2);
                } else if (scope.equalsIgnoreCase("composite")) {
                    context = new PolicyServiceContext(this.getInstanceManager().getGlobalContext(), this.getInstanceManager().getLocalServiceContext(), 0);
                } else if (scope.equalsIgnoreCase("composite+global")) {
                    context = new PolicyServiceContext(this.getInstanceManager().getGlobalContext(), this.getInstanceManager().getLocalServiceContext(), 1);
                }
            }
            if (filtersConfiguration != null && identitity != null && filtersConfiguration.get(identitity) != null) {
                filter = (String)filtersConfiguration.get(identitity);
            }
            String from = deps[i].getAttribute("from");
            if (fromConfiguration != null && identitity != null && fromConfiguration.get(identitity) != null) {
                from = (String)fromConfiguration.get(identitity);
            }
            if (from != null) {
                String fromFilter = "(|(instance.name=" + from + ")(service.pid=" + from + "))";
                if (aggregate) {
                    this.warn("The 'from' attribute is incompatible with aggregate requirements: only one provider will match : " + fromFilter);
                }
                filter = filter != null ? "(&" + fromFilter + filter + ")" : fromFilter;
            }
            Filter fil = null;
            if (filter != null) {
                try {
                    fil = this.getInstanceManager().getContext().createFilter(filter);
                }
                catch (InvalidSyntaxException e) {
                    throw new ConfigurationException("A requirement filter is invalid : " + filter + " - " + e.getMessage());
                }
            }
            Class spec = null;
            if (serviceSpecification != null) {
                spec = DependencyModel.loadSpecification(serviceSpecification, this.getInstanceManager().getContext());
            }
            int policy = DependencyModel.getPolicy(deps[i]);
            Comparator cmp = DependencyModel.getComparator(deps[i], this.getInstanceManager().getGlobalContext());
            Dependency dep = new Dependency(this, field, spec, fil, optional, aggregate, nullable, isProxy, identitity, context, policy, cmp, defaultImplem);
            Element[] cbs = deps[i].getElements("Callback");
            for (int j = 0; cbs != null && j < cbs.length; ++j) {
                if (!cbs[j].containsAttribute("method") && cbs[j].containsAttribute("type")) {
                    throw new ConfigurationException("Requirement Callback : a dependency callback must contain a method and a type (bind or unbind) attribute");
                }
                String method = cbs[j].getAttribute("method");
                String type = cbs[j].getAttribute("type");
                int methodType = 0;
                methodType = "bind".equalsIgnoreCase(type) ? 0 : ("modified".equalsIgnoreCase(type) ? 2 : 1);
                DependencyCallback callback = new DependencyCallback(dep, method, methodType);
                dep.addDependencyCallback(callback);
            }
            String paramIndex = deps[i].getAttribute("constructor-parameter");
            if (paramIndex != null) {
                int index = Integer.parseInt(paramIndex);
                dep.addConstructorInjection(index);
            }
            if (!this.checkDependency(dep, manipulation)) continue;
            this.addDependency(dep);
            if (dep.getField() == null) continue;
            this.getInstanceManager().register(manipulation.getField(dep.getField()), dep);
            atLeastOneField = true;
        }
        if (atLeastOneField) {
            MethodMetadata[] methods = manipulation.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                for (int j = 0; j < this.__getm_dependencies().length; ++j) {
                    this.getInstanceManager().register(methods[i], this.__getm_dependencies()[j]);
                }
            }
        }
        this.__setm_description(new DependencyHandlerDescription(this, this.__getm_dependencies()));
    }

    private Dictionary getRequiresFilters(Object object) throws ConfigurationException {
        Dictionary dictionary;
        if (!this.__MgetRequiresFilters$java_lang_Object) {
            return this.__M_getRequiresFilters(object);
        }
        try {
            this.__IM.onEntry(this, "getRequiresFilters$java_lang_Object", new Object[]{object});
            dictionary = this.__M_getRequiresFilters(object);
            this.__IM.onExit(this, "getRequiresFilters$java_lang_Object", dictionary);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "getRequiresFilters$java_lang_Object", throwable);
            throw throwable;
        }
        return dictionary;
    }

    private Dictionary __M_getRequiresFilters(Object requiresFiltersValue) throws ConfigurationException {
        if (requiresFiltersValue != null && requiresFiltersValue.getClass().isArray()) {
            String[] filtersArray = (String[])requiresFiltersValue;
            if (filtersArray.length % 2 != 0) {
                throw new ConfigurationException("A requirement filter is invalid : " + requiresFiltersValue);
            }
            Hashtable<String, String> requiresFilters = new Hashtable<String, String>();
            for (int i = 0; i < filtersArray.length; i += 2) {
                ((Dictionary)requiresFilters).put(filtersArray[i], filtersArray[i + 1]);
            }
            return requiresFilters;
        }
        return (Dictionary)requiresFiltersValue;
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry(this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit(this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "start", throwable);
            throw throwable;
        }
    }

    private void __M_start() {
        for (int i = 0; i < this.__getm_dependencies().length; ++i) {
            Dependency dep = this.__getm_dependencies()[i];
            dep.start();
        }
        this.__setm_started(true);
        this.setValidity(false);
        this.checkContext();
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry(this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit(this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "stop", throwable);
            throw throwable;
        }
    }

    private void __M_stop() {
        this.__setm_started(false);
        for (int i = 0; i < this.__getm_dependencies().length; ++i) {
            this.__getm_dependencies()[i].stop();
        }
    }

    public void onCreation(Object object) {
        if (!this.__MonCreation$java_lang_Object) {
            this.__M_onCreation(object);
            return;
        }
        try {
            this.__IM.onEntry(this, "onCreation$java_lang_Object", new Object[]{object});
            this.__M_onCreation(object);
            this.__IM.onExit(this, "onCreation$java_lang_Object", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "onCreation$java_lang_Object", throwable);
            throw throwable;
        }
    }

    private void __M_onCreation(Object instance) {
        for (int i = 0; i < this.__getm_dependencies().length; ++i) {
            this.__getm_dependencies()[i].onObjectCreation(instance);
        }
    }

    public HandlerDescription getDescription() {
        HandlerDescription handlerDescription;
        if (!this.__MgetDescription) {
            return this.__M_getDescription();
        }
        try {
            this.__IM.onEntry(this, "getDescription", new Object[0]);
            handlerDescription = this.__M_getDescription();
            this.__IM.onExit(this, "getDescription", handlerDescription);
        }
        catch (Throwable throwable) {
            this.__IM.onError(this, "getDescription", throwable);
            throw throwable;
        }
        return handlerDescription;
    }

    private HandlerDescription __M_getDescription() {
        return this.__getm_description();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_dependencies")) {
                this.__Fm_dependencies = true;
            }
            if (set.contains("m_description")) {
                this.__Fm_description = true;
            }
            if (set.contains("m_started")) {
                this.__Fm_started = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("addDependency$org_apache_felix_ipojo_handlers_dependency_Dependency")) {
                this.__MaddDependency$org_apache_felix_ipojo_handlers_dependency_Dependency = true;
            }
            if (set.contains("getDependencies")) {
                this.__MgetDependencies = true;
            }
            if (set.contains("validate$org_apache_felix_ipojo_util_DependencyModel")) {
                this.__Mvalidate$org_apache_felix_ipojo_util_DependencyModel = true;
            }
            if (set.contains("invalidate$org_apache_felix_ipojo_util_DependencyModel")) {
                this.__Minvalidate$org_apache_felix_ipojo_util_DependencyModel = true;
            }
            if (set.contains("checkContext")) {
                this.__McheckContext = true;
            }
            if (set.contains("checkDependency$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_parser_PojoMetadata")) {
                this.__McheckDependency$org_apache_felix_ipojo_handlers_dependency_Dependency$org_apache_felix_ipojo_parser_PojoMetadata = true;
            }
            if (set.contains("setSpecification$org_apache_felix_ipojo_handlers_dependency_Dependency$java_lang_String$boolean")) {
                this.__MsetSpecification$org_apache_felix_ipojo_handlers_dependency_Dependency$java_lang_String$boolean = true;
            }
            if (set.contains("configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary")) {
                this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary = true;
            }
            if (set.contains("getRequiresFilters$java_lang_Object")) {
                this.__MgetRequiresFilters$java_lang_Object = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("onCreation$java_lang_Object")) {
                this.__MonCreation$java_lang_Object = true;
            }
            if (set.contains("getDescription")) {
                this.__MgetDescription = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

