/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.jmx.internal;

import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.ObjectName;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;
import org.ow2.jasmine.probe.collectors.jmx.Metric;
import org.ow2.jasmine.probe.collectors.jmx.internal.ComplexValuesException;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxCollector;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxUtil;
import org.ow2.jasmine.probe.util.CsvConverter;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public abstract class JmxCollectorBase
extends JCollector {
    protected Log logger = LogFactory.getLog(JmxCollector.class);
    private String pattern;
    private List<String> attrlist;

    public String getPattern() {
        return this.pattern;
    }

    public JmxCollectorBase(String probeId, JasmineIndicator indicator, int period, String mbean, String csv) {
        super(probeId, indicator, period);
        this.pattern = mbean;
        this.attrlist = CsvConverter.csv2list((String)csv);
    }

    public List<String> getAttrlist() {
        return this.attrlist;
    }

    public ObjectName getObjectName() throws JasmineCollectorException {
        return JmxUtil.getObjectName(this.pattern);
    }

    protected boolean hasAttributes() {
        if (this.attrlist == null || this.attrlist.isEmpty()) {
            return false;
        }
        if (this.attrlist.size() == 1) {
            for (String elem : this.attrlist) {
                if (!"all".equals(elem)) continue;
                return false;
            }
        }
        return true;
    }

    protected JasmineIndicatorValue getJiv(String name, String probeId, int scale, List<Metric> metrics) throws JasmineCollectorException {
        this.logger.debug((Object)"Get indicator value for indicator {0} in probe {1}", new Object[]{name, probeId});
        JasmineIndicatorValue jiv = new JasmineIndicatorValue();
        jiv.setName(name);
        for (Metric metric : metrics) {
            if (metric.getAttributeList().size() == 0) {
                this.logger.warn((Object)("Result with no value: " + metric.toString()), new Object[0]);
                continue;
            }
            jiv.setMultiValue(metric.isMultiValue());
            Map<String, String> props = metric.getProperties();
            if (!props.isEmpty()) {
                for (String propKey : props.keySet()) {
                    String propVal = props.get(propKey);
                    jiv.addMetadata(propKey, propVal);
                }
            }
            for (Attribute att : metric.getAttributeList()) {
                if (att.getValue() == null) {
                    this.logger.warn((Object)("No value for " + att.getName() + " in indicator: " + this.getIndicatorName() + " and probe: " + probeId), new Object[0]);
                    continue;
                }
                try {
                    List<Attribute> decomposedList = JmxUtil.getAttributeFragments(att);
                    for (Attribute dAtt : decomposedList) {
                        Object dAttValue;
                        String dAttName = dAtt.getName();
                        JasmineSingleResult jsr = this.getJsr(dAttName, dAttValue = dAtt.getValue(), metric.getTimestamp(), this.indicator.getScale());
                        if (jsr == null) continue;
                        jsr.addProperty("mbean", metric.getMBean().toString());
                        jiv.addValue(jsr);
                    }
                }
                catch (ComplexValuesException e) {
                    e.printStackTrace();
                }
            }
        }
        Metric m = metrics.get(0);
        jiv.setTarget(m.getTarget());
        String key = "server";
        jiv.addMetadata(key, m.getProperties().get(key));
        key = "domain";
        jiv.addMetadata(key, m.getProperties().get(key));
        key = "url";
        jiv.addMetadata(key, m.getProperties().get(key));
        return jiv;
    }
}

