/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.converter;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.service.command.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Provides
public class InputStreamConverter
implements Converter,
Pojo {
    private InstanceManager __IM;
    private boolean __FsupportedClasses;
    @ServiceProperty(name="osgi.converter.classes", value="java.io.InputStream")
    private String supportedClasses;
    private boolean __Mconvert$java_lang_Class$java_lang_Object;
    private boolean __Mformat$java_lang_Object$int$org_apache_felix_service_command_Converter;
    private boolean __Mread$java_io_InputStream;

    String __getsupportedClasses() {
        if (!this.__FsupportedClasses) {
            return this.supportedClasses;
        }
        return (String)this.__IM.onGet((Object)this, "supportedClasses");
    }

    void __setsupportedClasses(String string) {
        if (!this.__FsupportedClasses) {
            this.supportedClasses = string;
            return;
        }
        this.__IM.onSet((Object)this, "supportedClasses", (Object)string);
    }

    public InputStreamConverter() {
        this(null);
    }

    private InputStreamConverter(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public Object convert(Class<?> clazz, Object object) throws Exception {
        Object object2;
        if (!this.__Mconvert$java_lang_Class$java_lang_Object) {
            return this.__M_convert(clazz, object);
        }
        try {
            this.__IM.onEntry((Object)this, "convert$java_lang_Class$java_lang_Object", new Object[]{clazz, object});
            object2 = this.__M_convert(clazz, object);
            this.__IM.onExit((Object)this, "convert$java_lang_Class$java_lang_Object", object2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "convert$java_lang_Class$java_lang_Object", throwable);
            throw throwable;
        }
        return object2;
    }

    private Object __M_convert(Class<?> desiredType, Object in) throws Exception {
        if (InputStream.class.equals(desiredType)) {
            URL url = new URL(in.toString());
            return url.openStream();
        }
        return null;
    }

    public CharSequence format(Object object, int n, Converter converter) throws Exception {
        CharSequence charSequence;
        if (!this.__Mformat$java_lang_Object$int$org_apache_felix_service_command_Converter) {
            return this.__M_format(object, n, converter);
        }
        try {
            this.__IM.onEntry((Object)this, "format$java_lang_Object$int$org_apache_felix_service_command_Converter", new Object[]{object, new Integer(n), converter});
            charSequence = this.__M_format(object, n, converter);
            this.__IM.onExit((Object)this, "format$java_lang_Object$int$org_apache_felix_service_command_Converter", (Object)charSequence);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "format$java_lang_Object$int$org_apache_felix_service_command_Converter", throwable);
            throw throwable;
        }
        return charSequence;
    }

    private CharSequence __M_format(Object target, int level, Converter converter) throws Exception {
        if (level == 0 && target instanceof InputStream) {
            return this.read((InputStream)target);
        }
        return null;
    }

    private CharSequence read(InputStream inputStream) throws IOException {
        CharSequence charSequence;
        if (!this.__Mread$java_io_InputStream) {
            return this.__M_read(inputStream);
        }
        try {
            this.__IM.onEntry((Object)this, "read$java_io_InputStream", new Object[]{inputStream});
            charSequence = this.__M_read(inputStream);
            this.__IM.onExit((Object)this, "read$java_io_InputStream", (Object)charSequence);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "read$java_io_InputStream", throwable);
            throw throwable;
        }
        return charSequence;
    }

    private CharSequence __M_read(InputStream in) throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = in.read()) > 0) {
            if (c >= 32 && c <= 127 || c == 10 || c == 13) {
                sb.append((char)c);
                continue;
            }
            String s = Integer.toHexString(c).toUpperCase();
            sb.append("\\");
            if (s.length() < 1) {
                sb.append(0);
            }
            sb.append(s);
        }
        return sb;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("supportedClasses")) {
            this.__FsupportedClasses = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("convert$java_lang_Class$java_lang_Object")) {
                this.__Mconvert$java_lang_Class$java_lang_Object = true;
            }
            if (set.contains("format$java_lang_Object$int$org_apache_felix_service_command_Converter")) {
                this.__Mformat$java_lang_Object$int$org_apache_felix_service_command_Converter = true;
            }
            if (set.contains("read$java_io_InputStream")) {
                this.__Mread$java_io_InputStream = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

