/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.launcher.jonas;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.jonas.launcher.jonas.IConfigurationProvider;
import org.ow2.jonas.launcher.jonas.JOnAS;
import org.ow2.jonas.launcher.jonas.VersionNumber;
import org.ow2.jonas.launcher.jonas.util.FileNamesComparator;
import org.ow2.jonas.launcher.jonas.util.IOUtils;
import org.ow2.jonas.launcher.jonas.util.JOnASUtils;
import org.ow2.jonas.launcher.jonas.util.Maven2Utils;
import org.ow2.util.substitution.ISubstitutionEngine;
import org.ow2.util.substitution.engine.DefaultSubstitutionEngine;
import org.ow2.util.substitution.resolver.ChainedResolver;
import org.ow2.util.substitution.resolver.PropertiesResolver;
import org.ow2.util.substitution.resolver.RecursiveResolver;

public class DefaultConfigurationProvider
implements IConfigurationProvider {
    private static final String JONAS_BUNDLES_CONFIG_FILE_PROP = "jonas.bundles.configuration.file";
    private static final Logger LOGGER = Logger.getLogger(DefaultConfigurationProvider.class.getName());
    private ISubstitutionEngine substitutionEngine;
    private ChainedResolver resolver = new ChainedResolver();
    private SortedMap<Integer, List<String>> autoInstallLevelBundlesLocationMap = null;
    private SortedMap<Integer, List<String>> autoStartLevelBundlesLocationMap = null;

    public DefaultConfigurationProvider() {
        this.substitutionEngine = this.createSubstitutionEngine();
        this.autoInstallLevelBundlesLocationMap = new TreeMap<Integer, List<String>>();
        this.autoStartLevelBundlesLocationMap = new TreeMap<Integer, List<String>>();
    }

    protected ISubstitutionEngine createSubstitutionEngine() {
        DefaultSubstitutionEngine engine = new DefaultSubstitutionEngine();
        engine.setMarkerChar('$');
        engine.setOpeningChar('{');
        engine.setEndingChar('}');
        engine.setResolver(new RecursiveResolver(engine, this.resolver));
        return engine;
    }

    @Override
    public Map<String, String> getConfiguration() throws IOException {
        Properties javaProfiles = IOUtils.getPropertiesFromClass("javase-profiles.properties", JOnAS.class);
        this.resolver.getResolvers().add(new PropertiesResolver(System.getProperties()));
        this.resolver.getResolvers().add(new PropertiesResolver(javaProfiles));
        this.resolveProperties(javaProfiles);
        File defaultsFile = IOUtils.getSystemFile(JOnASUtils.getJOnASBase(), "conf/osgi/defaults.properties");
        Properties defaultsProperties = defaultsFile.exists() ? IOUtils.getPropertiesFromFile(defaultsFile) : IOUtils.getPropertiesFromClass("defaults.properties", JOnAS.class);
        defaultsProperties.setProperty("javase.version", DefaultConfigurationProvider.javaSeSpecificationVersion());
        this.resolver.getResolvers().add(new PropertiesResolver(defaultsProperties));
        this.resolveProperties(defaultsProperties);
        File gatewayFile = IOUtils.getSystemFile(JOnASUtils.getJOnASBase(), "conf/osgi/gateway.properties");
        Properties gatewayProperties = gatewayFile.exists() ? IOUtils.getPropertiesFromFile(gatewayFile) : IOUtils.getPropertiesFromClass("gateway.properties", JOnAS.class);
        this.resolver.getResolvers().add(new PropertiesResolver(gatewayProperties));
        this.resolveProperties(gatewayProperties);
        Properties autoDeployProperties = null;
        File autoDeployFile = IOUtils.getSystemFile(JOnASUtils.getJOnASBase(), "conf/osgi/auto-deploy.properties");
        autoDeployProperties = autoDeployFile.exists() ? IOUtils.getPropertiesFromFile(autoDeployFile) : IOUtils.getPropertiesFromClass("auto-deploy.properties", JOnAS.class);
        this.initLevelBundles(autoDeployProperties);
        File cacheDirectory = IOUtils.getSystemFile(JOnASUtils.getWorkDirectory(), "osgi-framework-storage");
        gatewayProperties.put("org.osgi.framework.storage", cacheDirectory.getAbsolutePath());
        return IOUtils.props2Map(gatewayProperties);
    }

    private void resolveProperties(Properties properties) {
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = properties.getProperty(name);
            String systemValue = System.getProperty(name);
            if (systemValue != null) {
                value = systemValue;
            }
            String resolved = this.substitutionEngine.substitute(value);
            properties.setProperty(name, resolved);
        }
    }

    private static String javaSeSpecificationVersion() {
        VersionNumber version;
        String value = System.class.getPackage().getSpecificationVersion();
        if (value != null) {
            version = new VersionNumber(value);
        } else {
            value = System.getProperty("java.specification.version", "1.5");
            version = new VersionNumber(value);
        }
        return version.getMajorMinor();
    }

    protected void initLevelBundles(Properties autoDeployProperties) throws IOException {
        List previousBundleListLocationLevelOne;
        for (String string : autoDeployProperties.keySet()) {
            String level;
            if (string.startsWith("install.level.")) {
                level = string.substring("install.level.".length());
                this.autoInstallLevelBundlesLocationMap.put(Integer.valueOf(level), this.getBundleLocations(autoDeployProperties, string));
            }
            if (!string.startsWith("start.level.")) continue;
            level = string.substring("start.level.".length());
            this.autoStartLevelBundlesLocationMap.put(Integer.valueOf(level), this.getBundleLocations(autoDeployProperties, string));
        }
        ArrayList<String> extraBundleListLocationLevelOne = new ArrayList<String>();
        File file = IOUtils.getSystemFile(JOnASUtils.getJOnASRoot(), "lib/bootstrap/bundles");
        List<String> jonasBootStrapBundlesLocations = this.getBundleLocationsFromDirectory(file);
        if (jonasBootStrapBundlesLocations != null && !jonasBootStrapBundlesLocations.isEmpty()) {
            extraBundleListLocationLevelOne.addAll(jonasBootStrapBundlesLocations);
        }
        if ((previousBundleListLocationLevelOne = (List)this.autoStartLevelBundlesLocationMap.get(1)) != null) {
            extraBundleListLocationLevelOne.addAll(previousBundleListLocationLevelOne);
        }
        this.autoStartLevelBundlesLocationMap.put(1, extraBundleListLocationLevelOne);
    }

    protected List<String> getBundleLocationsFromDirectory(File directory) throws IOException {
        ArrayList<String> locations = new ArrayList<String>();
        if (directory.exists()) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            };
            File[] bundlesArray = directory.listFiles(filter);
            List<File> bundles = Arrays.asList(bundlesArray);
            Collections.sort(bundles, new FileNamesComparator());
            LOGGER.log(Level.FINE, "Adding bundles from the directory '" + directory + "' :" + bundles);
            for (File file : bundles) {
                locations.add("reference:".concat(file.toURI().toURL().toExternalForm()));
            }
        }
        return locations;
    }

    private List<String> getBundleLocations(Properties levels, String key) throws IOException {
        ArrayList<String> locations = new ArrayList<String>();
        String value = levels.getProperty(key);
        String[] bundles = value.split(",");
        for (int i = 0; i < bundles.length; ++i) {
            String bundle = bundles[i];
            if ("".equals(bundle)) continue;
            String location = "";
            String[] artifact = bundle.split(":");
            String groupId = artifact[0].trim();
            String artifactId = artifact[1].trim();
            String version = null;
            String classifier = null;
            if (artifact.length == 3) {
                classifier = DefaultConfigurationProvider.getClassifier(artifact[2]);
                if (classifier == null) {
                    version = artifact[2].trim();
                }
            } else if (artifact.length == 4) {
                version = artifact[2].trim();
                classifier = DefaultConfigurationProvider.getClassifier(artifact[3]);
                if (classifier == null) {
                    throw new IOException("Incorrect classifier in bundle: " + bundle);
                }
            } else if (artifact.length > 4) {
                throw new IOException("Incorrect number of parts in bundle: " + bundle);
            }
            if (version == null) {
                version = JOnASUtils.getVersion();
            }
            location = location.concat("reference:");
            File repository = null;
            repository = JOnASUtils.isDeveloperMode() ? Maven2Utils.getMaven2Repository() : Maven2Utils.getMaven2InternalRepository();
            location = location.concat(Maven2Utils.getBundleMaven2Location(repository.getPath(), groupId, artifactId, version, classifier));
            locations.add(location);
        }
        return locations;
    }

    private static String getClassifier(String value) {
        String classifier = null;
        String trimmed = value.trim();
        if (trimmed.startsWith("{") && trimmed.endsWith("}")) {
            classifier = trimmed.substring(1, trimmed.length() - 1);
        }
        return classifier;
    }

    @Override
    public SortedMap<Integer, List<String>> getAutoInstallBundles() {
        return this.autoInstallLevelBundlesLocationMap;
    }

    @Override
    public SortedMap<Integer, List<String>> getAutoStartBundles() {
        return this.autoStartLevelBundlesLocationMap;
    }

    @Override
    public ClassLoader getFrameworkClassLoader(ClassLoader parentClassLoader) {
        File[] frameworkFiles;
        File root = JOnASUtils.getJOnASRoot();
        File frameworkDir = IOUtils.getSystemFile(root, "lib/bootstrap/framework");
        if (!frameworkDir.exists()) {
            throw new IllegalStateException("No jar found in the '" + frameworkDir + "' directory.");
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        };
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (File file : frameworkFiles = frameworkDir.listFiles(filter)) {
            try {
                urlList.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Unable to get the URL from the file '" + file + "'.");
            }
        }
        return new URLClassLoader(urlList.toArray(new URL[urlList.size()]), parentClassLoader);
    }
}

