/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.jonasbase.bootstrap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.BaseTaskItf;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JTask;
import org.ow2.util.xml.XMLSerializer;
import org.w3c.dom.Document;

public class XMLSerializerTask
extends JTask
implements BaseTaskItf {
    private static final String INFO = "[XML Serializer] ";
    private Document xmlDoc = null;
    private String fileName = null;

    public void setXmlDoc(Document xmlDoc) {
        this.xmlDoc = xmlDoc;
    }

    public void setXmlFileName(String fileName) {
        this.fileName = fileName;
    }

    private void checkProperties() {
        if (this.xmlDoc == null) {
            throw new BuildException("[XML Serializer] XML document is missing.");
        }
        if (this.fileName == null) {
            throw new BuildException("[XML Serializer] XML filename is missing.");
        }
    }

    @Override
    public void execute() {
        FileOutputStream os;
        this.checkProperties();
        String jBaseConf = this.getDestDir().getPath() + File.separator + "conf";
        String xmlFile = jBaseConf + File.separator + this.fileName;
        try {
            os = new FileOutputStream(xmlFile);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("[XML Serializer] XML filename " + xmlFile + " is not valid", (Throwable)e);
        }
        XMLSerializer xmlSer = new XMLSerializer(this.xmlDoc);
        try {
            xmlSer.serialize(os);
        }
        catch (IOException e) {
            throw new BuildException("[XML Serializer] Error during serialization of " + xmlFile, (Throwable)e);
        }
    }
}

