/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.outers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.outer.JasmineOuter;
import org.ow2.jasmine.probe.outer.JasmineOuterException;
import org.ow2.jasmine.probe.outer.JasmineOuterService;
import org.ow2.jasmine.probe.outers.JOuter;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public abstract class JOuterService
implements JasmineOuterService {
    protected Log logger = LogFactory.getLog(JOuter.class);
    protected Map<String, JOuter> outerList = new HashMap<String, JOuter>();
    protected List<JasminePropertyInfo> properties;
    protected JmxService jmxService = null;

    public JmxService getJmxService() {
        return this.jmxService;
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    protected void registerJOuterMBean(JOuter outer) throws JasmineOuterException {
        ObjectName on;
        JOuter mbean;
        if (this.jmxService != null) {
            mbean = outer;
            on = null;
            try {
                on = new ObjectName("jasmine:type=jpouter,name=" + outer.output.getName());
            }
            catch (MalformedObjectNameException e) {
                throw new JasmineOuterException(e.toString());
            }
            catch (NullPointerException e) {
                throw new JasmineOuterException(e.toString());
            }
        } else {
            throw new JasmineOuterException("JMX service not available for registering JOuter MBean");
        }
        this.jmxService.registerMBean((Object)mbean, on);
    }

    protected void unregisterJOuterMBean(ObjectName on) {
        if (this.jmxService != null) {
            this.jmxService.unregisterMBean(on);
        }
    }

    public abstract JasmineOuter getOuter(JasmineOutput var1) throws JasmineOuterException;

    public synchronized void removeOuters(String name) {
        this.logger.debug((Object)name, new Object[0]);
        ArrayList<String> toremove = new ArrayList<String>();
        for (String key : this.outerList.keySet()) {
            JOuter outer = this.outerList.get(key);
            if (name != null && !outer.getOutput().getName().equals(name)) continue;
            toremove.add(key);
        }
        for (String rem : toremove) {
            this.outerList.get(rem).remove();
            this.outerList.remove(rem);
        }
    }

    public List<JasminePropertyInfo> getPropertiesInfo() {
        return this.properties;
    }

    public abstract String getType();
}

