/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.domain.xml;

import org.ow2.jonas.deployment.common.CommonsSchemas;
import org.ow2.jonas.deployment.common.xml.AbsDescriptionElement;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.common.xml.TopLevelElement;
import org.ow2.jonas.deployment.domain.DomainSchemas;
import org.ow2.jonas.deployment.domain.xml.Cluster;
import org.ow2.jonas.deployment.domain.xml.ClusterDaemon;
import org.ow2.jonas.deployment.domain.xml.Server;

public class Domain
extends AbsDescriptionElement
implements TopLevelElement {
    private static final long serialVersionUID = 3866056043763651049L;
    private JLinkedList serverList = new JLinkedList("server");
    private JLinkedList clusterDaemonList = null;
    private JLinkedList clusterList = new JLinkedList("cluster");
    private String name = null;
    private String username = null;
    private String password = null;
    private static final String header = CommonsSchemas.getHeaderForElement("domain", DomainSchemas.getLastSchema());

    public Domain() {
        this.clusterDaemonList = new JLinkedList("clusterDaemon");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final String getUsername() {
        return this.username;
    }

    public final void setUsername(String username) {
        this.username = username;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public void addCluster(Cluster cluster) {
        this.clusterList.add(cluster);
    }

    public void addClusterDaemon(ClusterDaemon clusterDaemon) {
        this.clusterDaemonList.add(clusterDaemon);
    }

    public void addServer(Server server) {
        this.serverList.add(server);
    }

    public JLinkedList getClusterList() {
        return this.clusterList;
    }

    public void setClusterList(JLinkedList clusterList) {
        this.clusterList = clusterList;
    }

    public void setClusterDaemonList(JLinkedList clusterDaemonList) {
        this.clusterDaemonList = clusterDaemonList;
    }

    public JLinkedList getClusterDaemonList() {
        return this.clusterDaemonList;
    }

    public JLinkedList getServerList() {
        return this.serverList;
    }

    public void setServerList(JLinkedList serverList) {
        this.serverList = serverList;
    }

    @Override
    public String toXML(int indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.indent(indent));
        sb.append(header);
        indent += 2;
        if (this.name != null) {
            sb.append(this.xmlElement(this.getName(), "name", indent));
        }
        if (this.getDescription() != null) {
            sb.append(this.xmlElement(this.getDescription(), "description", indent));
        }
        if (this.username != null && this.password != null) {
            sb.append(this.xmlElement(this.username, "username", indent));
            sb.append(this.xmlElement(this.password, "password", indent));
        }
        sb.append(this.getClusterDaemonList().toXML(indent));
        sb.append(this.getServerList().toXML(indent));
        sb.append(this.getClusterList().toXML(indent));
        sb.append(this.indent(indent -= 2));
        sb.append("</domain>\n");
        return sb.toString();
    }
}

