/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.ejb.EntityCmp1Desc;
import org.ow2.jonas.deployment.ejb.FieldDesc;
import org.ow2.jonas.deployment.ejb.FieldJdbcDesc;
import org.ow2.jonas.deployment.ejb.MethodDesc;
import org.ow2.jonas.deployment.ejb.MethodJdbcCmp1Desc;
import org.ow2.jonas.deployment.ejb.xml.AssemblyDescriptor;
import org.ow2.jonas.deployment.ejb.xml.CmpFieldJdbcMapping;
import org.ow2.jonas.deployment.ejb.xml.Entity;
import org.ow2.jonas.deployment.ejb.xml.FinderMethodJdbcMapping;
import org.ow2.jonas.deployment.ejb.xml.JdbcMapping;
import org.ow2.jonas.deployment.ejb.xml.JonasEntity;
import org.ow2.jonas.deployment.ejb.xml.JonasMethod;

public class EntityJdbcCmp1Desc
extends EntityCmp1Desc {
    String jdbcTableName;
    String datasourceJndiName;

    public EntityJdbcCmp1Desc(ClassLoader classLoader, Entity ent, AssemblyDescriptor asd, JonasEntity jEnt, JLinkedList jMDRList, String fileName) throws DeploymentDescException {
        super(classLoader, ent, asd, jEnt, jMDRList, fileName);
        JdbcMapping jm = jEnt.getJdbcMapping();
        if (jm == null) {
            throw new DeploymentDescException("jdbc-mapping missing for bean " + ent.getEjbName());
        }
        for (CmpFieldJdbcMapping cmpFieldJdbcMapping : jm.getCmpFieldJdbcMappingList()) {
            String fn = cmpFieldJdbcMapping.getFieldName();
            FieldDesc f = (FieldDesc)this.fieldDesc.get(fn);
            if (f == null) {
                throw new DeploymentDescException("field-name " + fn + " listed in cmp-field-jdbc-mapping is not of cmp-field of bean " + ent.getEjbName());
            }
            ((FieldJdbcDesc)f).setJdbcFieldName(cmpFieldJdbcMapping.getJdbcFieldName());
        }
        for (FieldJdbcDesc fd : this.fieldDesc.values()) {
            if (fd.getJdbcFieldName() != null) continue;
            throw new DeploymentDescException("field-name " + fd.getName() + " is missing in cmp-field-jdbc-mapping for bean " + ent.getEjbName());
        }
        for (FinderMethodJdbcMapping fmj : jm.getFinderMethodJdbcMappingList()) {
            JonasMethod m = fmj.getJonasMethod();
            Iterator j = this.getMethodDescIterator();
            while (j.hasNext()) {
                MethodJdbcCmp1Desc md = (MethodJdbcCmp1Desc)j.next();
                int matchStatus = md.matchPattern(null, m.getMethodName(), m.getMethodParams());
                md.overwriteJdbcWhereClause(fmj.getJdbcWhereClause(), matchStatus);
            }
        }
        this.datasourceJndiName = jm.getJndiName();
        this.jdbcTableName = jm.getJdbcTableName();
        if (jm.getAutomaticPk() != null) {
            this.jdbcAutomaticPk = jm.getAutomaticPk().equalsIgnoreCase("true");
        }
    }

    public String getDatasourceJndiName() {
        return this.datasourceJndiName;
    }

    public FieldJdbcDesc getFieldJdbcDesc(Field field) {
        return (FieldJdbcDesc)super.getCmpFieldDesc(field);
    }

    public String getJdbcTableName() {
        return this.jdbcTableName;
    }

    @Override
    protected MethodDesc newMethodDescInstance(Method meth, Class classDef, int index) {
        return new MethodJdbcCmp1Desc(this, meth, classDef, index);
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(super.toString());
        ret.append("\ngetDatasourceJndiName()=" + this.getDatasourceJndiName());
        ret.append("\ngetJdbcTableName()=" + this.getJdbcTableName());
        return ret.toString();
    }
}

