/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.base;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.deployment.api.EZBInjectionHolder;
import org.ow2.easybeans.persistence.api.EZBPersistenceUnitManager;
import org.ow2.easybeans.persistence.api.PersistenceXmlFileAnalyzerException;
import org.ow2.easybeans.resolver.api.EZBApplicationJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBJNDIResolverException;
import org.ow2.jonas.Version;
import org.ow2.jonas.audit.AuditService;
import org.ow2.jonas.datasource.DataSourceService;
import org.ow2.jonas.deployment.api.IEnvEntryDesc;
import org.ow2.jonas.deployment.api.IResourceEnvRefDesc;
import org.ow2.jonas.deployment.api.IResourceRefDesc;
import org.ow2.jonas.deployment.api.IServiceRefDesc;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.EjbLocalRefDesc;
import org.ow2.jonas.deployment.common.EjbRefDesc;
import org.ow2.jonas.deployment.common.MessageDestinationRefDesc;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDesc;
import org.ow2.jonas.deployment.web.lib.WarDeployableMetadataFactoryHolder;
import org.ow2.jonas.deployment.web.lib.WebDeploymentDescManager;
import org.ow2.jonas.ejb3.IEasyBeansService;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.jsf.JSFService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.loader.FilteringClassLoader;
import org.ow2.jonas.lib.loader.SimpleWebappClassLoader;
import org.ow2.jonas.lib.loader.WebappClassLoader;
import org.ow2.jonas.lib.naming.ComponentContext;
import org.ow2.jonas.lib.security.PermissionManagerException;
import org.ow2.jonas.lib.service.AbsConfigServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.work.DeployerLog;
import org.ow2.jonas.multitenant.MultitenantService;
import org.ow2.jonas.naming.JComponentContextFactory;
import org.ow2.jonas.naming.JNamingManager;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.jonas.web.JWebContainerService;
import org.ow2.jonas.web.JWebContainerServiceException;
import org.ow2.jonas.web.base.BaseWebContainerServiceMBean;
import org.ow2.jonas.web.base.WARDeployer;
import org.ow2.jonas.web.base.War;
import org.ow2.jonas.web.base.WarCleanTask;
import org.ow2.jonas.web.base.lib.PermissionManager;
import org.ow2.jonas.web.base.osgi.httpservice.HttpServiceFactory;
import org.ow2.jonas.web.base.osgi.httpservice.JOnASHttpService;
import org.ow2.jonas.web.base.proxy.HttpOnDemandProxy;
import org.ow2.jonas.web.base.proxy.HttpOnDemandProxyException;
import org.ow2.jonas.workcleaner.CleanTask;
import org.ow2.jonas.workcleaner.DeployerLogException;
import org.ow2.jonas.workcleaner.IDeployerLog;
import org.ow2.jonas.workcleaner.WorkCleanerService;
import org.ow2.jonas.ws.jaxrpc.IJAXRPCService;
import org.ow2.jonas.ws.jaxws.IJAXWSService;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.helper.DeployableHelperException;
import org.ow2.util.ee.deploy.api.helper.IDeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.ee.metadata.common.api.enc.IENCBinding;
import org.ow2.util.ee.metadata.common.api.enc.IENCBindingHolder;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationResource;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationSqlDataSourceDefinition;
import org.ow2.util.ee.metadata.common.api.struct.IJEjbEJB;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceContext;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceUnit;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.ee.metadata.war.api.IWarDeployableMetadataFactory;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.url.URLUtils;

public abstract class BaseWebContainerService
extends AbsConfigServiceImpl
implements JWebContainerService,
BaseWebContainerServiceMBean {
    protected static final String JONAS_BASE = JProp.getJonasBase();
    protected static final String SINGLE_WORK_WEBAPPS_DIR_SUFFIX = "single";
    protected static final String INEAR_WORK_WEBAPPS_DIR_SUFFIX = "ear";
    private static final int WAR_EXTENSION_LENGTH = ".war".length();
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.web");
    private JNamingManager naming;
    private WARDeployer warDeployer = null;
    private JComponentContextFactory contextFactory;
    private Hashtable warLoaders = new Hashtable();
    private Hashtable warBindings = new Hashtable();
    protected JmxService jmxService = null;
    private DataSourceService dataSourceService = null;
    protected JSFService jsfService = null;
    private List<War> warDeployed = new Vector<War>();
    private Map<URL, URL> unpackedWARs = new HashMap<URL, URL>();
    private String serverName = null;
    private String serverVersion = null;
    private IJAXRPCService jaxrpcService = null;
    private ClassLoader extClassLoader;
    private IDeployerManager deployerManager;
    private VersioningService versioningService;
    private MultitenantService multitenantService;
    private File workSingleWebAppsFile = null;
    private DeployerLog deployerLog;
    private IJAXWSService jaxwsService;
    private IEasyBeansService ejb3Service = null;
    private AuditService auditService;
    private boolean onDemandFeatureEnabled = false;
    private HttpOnDemandProxy onDemandProxy = null;
    private int onDemandRedirectPort = 0;
    private boolean ejbinwar = true;
    private BundleContext bundleContext;
    private ServiceRegistration osgiHttpService;
    private List<URL> tldResources = null;
    private IDeployableHelper deployableHelper = null;

    public BaseWebContainerService(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.warDeployer = new WARDeployer();
        this.onDemandProxy = new HttpOnDemandProxy();
        this.tldResources = new ArrayList<URL>();
    }

    public void setParsingwithvalidation(boolean validate) {
        WebDeploymentDescManager.setParsingWithValidation((boolean)validate);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            if (!validate) {
                logger.log(BasicLevel.DEBUG, (Object)"Web XML parsing without validation");
            } else {
                logger.log(BasicLevel.DEBUG, (Object)"Web XML parsing with validation");
            }
        }
    }

    protected void doStart() throws ServiceException {
        HttpServiceFactory<?> httpServiceFactory;
        String httpPort;
        this.initWorkingDirectory();
        try {
            LoaderManager lm = LoaderManager.getInstance();
            this.extClassLoader = lm.getExternalLoader();
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot get the Applications ClassLoader from Web Container Service: ", (Throwable)e);
            throw new ServiceException("Cannot get the Applications ClassLoader from Web Container Service", (Throwable)e);
        }
        if (this.onDemandFeatureEnabled && !this.getServerProperties().isDevelopment()) {
            logger.log(BasicLevel.INFO, (Object)"The OnDemand feature is disabled in production mode");
            this.onDemandFeatureEnabled = false;
        }
        if ((httpPort = this.getDefaultHttpPort()) != null) {
            this.setDefaultHttpPort(Integer.parseInt(httpPort));
        }
        Hashtable<String, String> httpServiceDictionary = new Hashtable<String, String>();
        ((Dictionary)httpServiceDictionary).put("service.pid", JOnASHttpService.class.getName());
        if (httpPort != null) {
            ((Dictionary)httpServiceDictionary).put("org.osgi.service.http.port", httpPort);
        }
        if ((httpServiceFactory = this.createHttpServiceFactory()) != null) {
            httpServiceFactory.setWorkDirectory(this.getServerProperties().getWorkDirectory());
            this.osgiHttpService = this.bundleContext.registerService(HttpService.class.getName(), httpServiceFactory, httpServiceDictionary);
        }
        this.warDeployer.setWebContainerService(this);
        this.deployerManager.register((IDeployer)this.warDeployer);
        this.registerWebServiceMBean(this, this.getDomainName());
    }

    protected abstract HttpServiceFactory<?> createHttpServiceFactory();

    protected void doStop() throws ServiceException {
        this.warDeployer.stop();
        if (this.deployerManager != null) {
            this.deployerManager.unregister((IDeployer)this.warDeployer);
        }
        if (this.onDemandProxy != null) {
            try {
                this.onDemandProxy.disable();
            }
            catch (HttpOnDemandProxyException e) {
                logger.log(BasicLevel.WARN, (Object)"Cannot stop the OnDemand proxy", (Throwable)e);
            }
        }
        if (this.osgiHttpService != null) {
            this.osgiHttpService.unregister();
        }
        this.unregisterWebServiceMBean(this.getDomainName());
        logger.log(BasicLevel.DEBUG, (Object)"WebContainerService stopped");
    }

    protected abstract void doRegisterWar(Context var1) throws JWebContainerServiceException;

    protected abstract void doUnRegisterWar(Context var1) throws JWebContainerServiceException;

    public abstract void startInternalWebContainer() throws JWebContainerServiceException;

    public abstract boolean isInternalContainerStarted();

    protected URL getUnpackedURL(URL warURL, EARDeployable earDeployable) throws JWebContainerServiceException {
        String folder = this.getWebappsWorkDirectory() + File.separator + this.getJonasServerName() + File.separator;
        File warFile = URLUtils.urlToFile((URL)warURL);
        if (warFile.isDirectory()) {
            return warURL;
        }
        if (earDeployable != null) {
            String earFileName = warFile.getParentFile().getName();
            if (!this.getServerProperties().isDevelopment()) {
                try {
                    earFileName = URLUtils.urlToFile((URL)((EARDeployable)earDeployable.getOriginalDeployable()).getArchive().getURL()).getName();
                }
                catch (Exception e) {
                    logger.log(BasicLevel.ERROR, (Object)"Cannot retrieve the original deployable");
                }
            }
            folder = folder + INEAR_WORK_WEBAPPS_DIR_SUFFIX + File.separator + earFileName;
        } else {
            folder = folder + SINGLE_WORK_WEBAPPS_DIR_SUFFIX + File.separator;
        }
        String archiveName = warFile.getName();
        if (this.getServerProperties().isDevelopment() && earDeployable == null) {
            try {
                archiveName = FileUtils.lastModifiedFileName((File)warFile);
            }
            catch (FileUtilsException e) {
                throw new JWebContainerServiceException("Failed creating the destination name", (Throwable)e);
            }
        }
        try {
            IArchive archive = ArchiveManager.getInstance().getArchive((Object)warFile);
            WARDeployable warDeployable = (WARDeployable)WARDeployable.class.cast(this.deployableHelper.getDeployable(archive));
            boolean keepArchives = false;
            File unpackedFolder = new File(folder, archiveName);
            if (unpackedFolder.exists() && warFile.lastModified() <= unpackedFolder.lastModified()) {
                keepArchives = true;
            }
            UnpackDeployableHelper.unpack((IDeployable)warDeployable, (File)new File(folder), (String)archiveName, (boolean)keepArchives);
            if (this.deployerLog != null && earDeployable == null && this.getServerProperties().isDevelopment()) {
                try {
                    this.deployerLog.addEntry(warFile, URLUtils.urlToFile((URL)((WARDeployable)warDeployable.getUnpackedDeployable()).getArchive().getURL()));
                }
                catch (Exception e) {
                    String err = "Error while adding the " + warFile + " entry in the log file";
                    logger.log(BasicLevel.ERROR, (Object)(err + " : " + e.getMessage()));
                    throw new JWebContainerServiceException(err, (Throwable)e);
                }
            }
            return ((WARDeployable)warDeployable.getUnpackedDeployable()).getArchive().getURL();
        }
        catch (Exception e) {
            throw new JWebContainerServiceException("Failed unpacking the war file " + warFile, (Throwable)e);
        }
    }

    public WebappClassLoader getClassLoader(URL warURL, EARDeployable earDeployable, ClassLoader parentLoader) throws JWebContainerServiceException {
        WebappClassLoader loaderForCls = null;
        try {
            WebLoaderHolder holder = (WebLoaderHolder)this.warLoaders.get(warURL);
            if (holder != null) {
                loaderForCls = holder.getJonasWebLoader();
            }
        }
        catch (Exception e) {
            throw new JWebContainerServiceException("Error when getting '" + warURL + "' in cache", (Throwable)e);
        }
        if (loaderForCls == null) {
            URL unpackedWarURL = this.getUnpackedURL(warURL, earDeployable);
            try {
                loaderForCls = parentLoader != null ? new WebappClassLoader(unpackedWarURL, parentLoader) : new WebappClassLoader(unpackedWarURL, this.extClassLoader);
            }
            catch (IOException ioe) {
                throw new JWebContainerServiceException("Cannot create WebAppClassLoader from '" + unpackedWarURL + "'", (Throwable)ioe);
            }
            try {
                WebLoaderHolder holder = new WebLoaderHolder(loaderForCls, null);
                this.warLoaders.put(warURL, holder);
            }
            catch (Exception e) {
                throw new JWebContainerServiceException("Error when adding '" + warURL + "' in cache", (Throwable)e);
            }
        }
        return loaderForCls;
    }

    public ClassLoader getContextLinkedClassLoader(URL warURL) {
        WebLoaderHolder holder = (WebLoaderHolder)this.warLoaders.get(warURL);
        if (holder != null) {
            return holder.getEnvWebLoader();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerWar(Context ctx) throws JWebContainerServiceException {
        String err;
        URL persistenceXmlEntryInWarFile;
        String moduleName;
        WARDeployable warDeployable;
        WARDeployable deployable;
        URL warURL;
        EZBInjectionHolder ezbInjectionHolder;
        String userURI;
        String earAppName;
        String contextRoot;
        EARDeployable earDeployable;
        URL earURL;
        block115: {
            block114: {
                earURL = null;
                earDeployable = null;
                contextRoot = null;
                earAppName = null;
                userURI = null;
                ezbInjectionHolder = null;
                try {
                    earURL = (URL)ctx.lookup("earURL");
                    earDeployable = (EARDeployable)ctx.lookup("earDeployable");
                    contextRoot = (String)ctx.lookup("contextRoot");
                }
                catch (NamingException e) {
                    if (earURL == null && earDeployable == null && contextRoot == null) break block114;
                    String err2 = "Error while getting parameter from context param :" + e.getMessage();
                    logger.log(BasicLevel.ERROR, (Object)err2);
                    throw new JWebContainerServiceException(err2, (Throwable)e);
                }
            }
            if (earDeployable != null) {
                earAppName = earDeployable.getModuleName();
            }
            warURL = null;
            try {
                warURL = (URL)ctx.lookup("warURL");
            }
            catch (NamingException e) {
                String err3 = "Error while getting parameter from context param :" + e.getMessage();
                logger.log(BasicLevel.ERROR, (Object)err3);
                throw new JWebContainerServiceException(err3, (Throwable)e);
            }
            deployable = null;
            try {
                deployable = (WARDeployable)ctx.lookup("deployable");
            }
            catch (NamingException e) {
                deployable = null;
            }
            try {
                ezbInjectionHolder = (EZBInjectionHolder)ctx.lookup(EZBInjectionHolder.class.getName());
            }
            catch (NamingException e) {
                logger.log(BasicLevel.DEBUG, (Object)"No injection holder");
                if (this.ejb3Service == null) break block115;
                ezbInjectionHolder = this.ejb3Service.buildInjectionHolder(null, null);
            }
        }
        File warFile = URLUtils.urlToFile((URL)warURL);
        if (!warFile.exists()) {
            String err4 = "registerWar: '" + warFile.getPath() + "' not found";
            logger.log(BasicLevel.ERROR, (Object)err4);
            throw new JWebContainerServiceException(err4);
        }
        War war = this.getWar(warURL);
        if (war != null) {
            String err5 = "Cannot deploy war '" + warURL.getFile() + "' is already deployed." + " You must undeploy the war before a new deployment.";
            throw new JWebContainerServiceException(err5);
        }
        URLClassLoader parentLoader = null;
        URLClassLoader earClassLoader = null;
        boolean isInEar = true;
        try {
            parentLoader = (URLClassLoader)ctx.lookup("parentClassLoader");
            earClassLoader = (URLClassLoader)ctx.lookup("earClassLoader");
        }
        catch (NamingException ne) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"Not an ear case");
            }
            isInEar = false;
        }
        if (!isInEar) {
            try {
                this.applyWSGenIfNeeded(warFile.getCanonicalPath());
            }
            catch (Exception e) {
                throw new JWebContainerServiceException("Cannot apply WsGen on the file : " + warFile, (Throwable)e);
            }
        }
        WebappClassLoader loaderForCls = this.getClassLoader(warURL, earDeployable, parentLoader);
        URL unpackedWarURL = loaderForCls.getBaseURL();
        ClassLoader ejb3ClassLoader = null;
        if (this.ejb3Service != null) {
            ejb3ClassLoader = parentLoader != null ? this.ejb3Service.buildByteCodeEnhancementClassLoader(new URL[]{unpackedWarURL}, (ClassLoader)parentLoader) : this.ejb3Service.buildByteCodeEnhancementClassLoader(new URL[]{unpackedWarURL}, this.extClassLoader);
            parentLoader = (URLClassLoader)ejb3ClassLoader;
        }
        String warName = unpackedWarURL.getFile();
        IArchive archive = ArchiveManager.getInstance().getArchive((Object)URLUtils.urlToFile((URL)unpackedWarURL));
        try {
            warDeployable = (WARDeployable)WARDeployable.class.cast(this.deployableHelper.getDeployable(archive));
        }
        catch (DeployableHelperException e) {
            throw new JWebContainerServiceException("Cannot get deployable", (Throwable)e);
        }
        if (deployable != null) {
            deployable.setUnpackedDeployable((IDeployable)warDeployable);
            warDeployable.setOriginalDeployable((IDeployable)deployable);
        }
        String applicationName = moduleName = warDeployable.getModuleName();
        if (earAppName != null) {
            applicationName = earAppName;
        }
        Context appContext = null;
        if (earAppName != null) {
            try {
                appContext = (Context)ctx.lookup("earApplicationContext");
            }
            catch (NamingException e) {
                throw new JWebContainerServiceException("Cannot get ear Application context", (Throwable)e);
            }
        }
        Context moduleContext = null;
        Context javaContext = null;
        Context encContext = null;
        try {
            if (appContext == null) {
                appContext = this.contextFactory.createComponentContext("module:".concat(warName));
                appContext.bind("AppName", (Object)applicationName);
            }
            moduleContext = this.contextFactory.createComponentContext("module:".concat(warName));
            moduleContext.bind("ModuleName", (Object)moduleName);
            javaContext = this.contextFactory.createComponentContext("java:".concat(warName), moduleContext, appContext);
            encContext = javaContext.createSubcontext("comp/env");
        }
        catch (NamingException e) {
            String err6 = "Error while populating environment of the war file " + warName;
            logger.log(BasicLevel.ERROR, (Object)(err6 + "  :" + e.getMessage()));
            throw new JWebContainerServiceException(err6, (Throwable)e);
        }
        if (this.jaxrpcService != null && earClassLoader == null) {
            try {
                ComponentContext contctx = null;
                try {
                    contctx = new ComponentContext(unpackedWarURL.getFile());
                    File unpackedWarFile = URLUtils.urlToFile((URL)unpackedWarURL);
                    contctx.rebind("unpackDir", (Object)unpackedWarFile);
                    contctx.rebind("jarUrls", (Object)new URL[0]);
                    contctx.rebind("warUrls", (Object)new URL[]{warURL});
                    if (parentLoader != null) {
                        contctx.rebind("ejbClassLoader", (Object)parentLoader);
                    }
                }
                catch (NamingException e) {
                    String err7 = "Can not bind params for the WebServices service, Can't deploy Web Services Endpoint";
                    throw new JWebContainerServiceException(err7, (Throwable)e);
                }
                this.jaxrpcService.deployWebServices((Context)contctx);
            }
            catch (ServiceException se) {
                String err8 = "Error during the deployment of the WebServices of the War file '" + warURL + "'";
                logger.log(BasicLevel.ERROR, (Object)(err8 + " : " + se.getMessage()));
                throw new JWebContainerServiceException(err8, (Throwable)se);
            }
        }
        SimpleWebappClassLoader webClassLoader = null;
        FilteringClassLoader filteringClassLoader = null;
        try {
            filteringClassLoader = this.createFilteringClassLoader(deployable, parentLoader, unpackedWarURL);
            webClassLoader = new SimpleWebappClassLoader(unpackedWarURL, (ClassLoader)filteringClassLoader);
        }
        catch (Exception e) {
            throw new JWebContainerServiceException("Unable to create classloader", (Throwable)e);
        }
        ArrayList<IArchive> persistenceArchives = new ArrayList<IArchive>();
        ArrayList<URL> urlsToAddToClassLoader = new ArrayList<URL>();
        URL urlWebInfClasses = webClassLoader.getResource("WEB-INF/classes/");
        if (urlWebInfClasses != null) {
            urlsToAddToClassLoader.add(urlWebInfClasses);
        }
        if ((persistenceXmlEntryInWarFile = webClassLoader.getResource("WEB-INF/classes/META-INF/persistence.xml")) != null) {
            persistenceArchives.add(archive);
        }
        try {
            Iterator itURLEntries = archive.getResources();
            while (itURLEntries.hasNext()) {
                URL urlWarEntry = (URL)itURLEntries.next();
                if (!urlWarEntry.toExternalForm().contains("/WEB-INF/lib/") || !urlWarEntry.toExternalForm().endsWith(".jar")) continue;
                IArchive archiveLib = ArchiveManager.getInstance().getArchive((Object)URLUtils.urlToFile((URL)urlWarEntry));
                URL persistenceXmlInLib = archiveLib.getResource("META-INF/persistence.xml");
                if (persistenceXmlInLib != null) {
                    persistenceArchives.add(archiveLib);
                }
                urlsToAddToClassLoader.add(urlWarEntry);
            }
        }
        catch (ArchiveException e) {
            throw new JWebContainerServiceException("Cannot check for persistence", (Throwable)e);
        }
        EZBContainer ejb3InWarContainer = null;
        if (this.ejb3Service != null) {
            for (URL urlToAdd : urlsToAddToClassLoader) {
                try {
                    Method addURLMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                    addURLMethod.setAccessible(true);
                    addURLMethod.invoke((Object)ejb3ClassLoader, urlToAdd);
                }
                catch (SecurityException e) {
                    throw new JWebContainerServiceException("Unable to add URLs", (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    throw new JWebContainerServiceException("Unable to add URLs", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    throw new JWebContainerServiceException("Unable to add URLs", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new JWebContainerServiceException("Unable to add URLs", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new JWebContainerServiceException("Unable to add URLs", (Throwable)e);
                }
            }
            if (ezbInjectionHolder.getJNDIResolver() == null) {
                ezbInjectionHolder = this.ejb3Service.buildInjectionHolder(ezbInjectionHolder.getPersistenceUnitManager(), (EZBJNDIResolver)this.ejb3Service.buildApplicationJNDIResolver());
            }
            if (persistenceArchives.size() > 0) {
                for (IArchive persistenceArchive : persistenceArchives) {
                    EZBPersistenceUnitManager persistenceUnitManager = null;
                    ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        persistenceUnitManager = this.ejb3Service.getPersistenceUnitManager(persistenceArchive, ejb3ClassLoader);
                    }
                    catch (PersistenceXmlFileAnalyzerException e) {
                        throw new JWebContainerServiceException("Unable to analyze persistence.xml file", (Throwable)e);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldCL);
                    }
                    EZBPersistenceUnitManager existingPersistenceUnitManager = ezbInjectionHolder.getPersistenceUnitManager();
                    if (existingPersistenceUnitManager == null) {
                        ezbInjectionHolder = this.ejb3Service.buildInjectionHolder(persistenceUnitManager, ezbInjectionHolder.getJNDIResolver());
                    } else {
                        existingPersistenceUnitManager.merge(persistenceUnitManager);
                    }
                    if (!this.isMultitenantEnabled() || !this.multitenantService.isMultitenant((IDeployable)deployable)) continue;
                    this.multitenantService.updatePersistenceUnitManager(persistenceUnitManager, this.getTenantId((IDeployable)deployable));
                }
            }
            if (this.isEjbinwarEnabled()) {
                HashMap<Object, Object> properties = new HashMap<Object, Object>();
                properties.put(ClassLoader.class, ejb3ClassLoader);
                properties.put("application.name", earAppName);
                properties.put("module.name", moduleName);
                properties.put("application.context", appContext);
                properties.put("env.context", encContext);
                properties.put("module.context", moduleContext);
                properties.put(EZBApplicationJNDIResolver.class, ezbInjectionHolder.getJNDIResolver());
                ejb3InWarContainer = this.ejb3Service.getEJBContainerFromWar(warDeployable, properties);
                if (ejb3InWarContainer != null) {
                    try {
                        ejb3InWarContainer.resolve();
                        ejb3InWarContainer.setPersistenceUnitManager(ezbInjectionHolder.getPersistenceUnitManager());
                        ejb3InWarContainer.enhance(true);
                    }
                    catch (EZBContainerException e) {
                        throw new JWebContainerServiceException("Cannot deploy deployable", (Throwable)e);
                    }
                }
            }
        }
        WebContainerDeploymentDesc webDD = null;
        try {
            WebDeploymentDescManager manager = WebDeploymentDescManager.getInstance();
            webDD = ezbInjectionHolder != null ? manager.getDeploymentDesc(unpackedWarURL, warURL, (ClassLoader)loaderForCls, (ClassLoader)earClassLoader, ezbInjectionHolder.getJNDIResolver()) : manager.getDeploymentDesc(unpackedWarURL, warURL, (ClassLoader)loaderForCls, (ClassLoader)earClassLoader, null);
        }
        catch (DeploymentDescException e) {
            err = "Cannot read the deployment descriptors '" + warURL.getFile() + "'";
            logger.log(BasicLevel.ERROR, (Object)(err + ": " + (Object)((Object)e)));
            e.printStackTrace(System.err);
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        if (deployable == null && this.isMultitenantEnabled() && this.multitenantService.getTenantIdFromContext() != null) {
            deployable = warDeployable;
            war.setWarDeployable(deployable);
        }
        if (this.isMultitenantEnabled() && earDeployable == null && deployable != null) {
            this.multitenantService.addTenantIdDeployableInfo((IDeployable)deployable, webDD.getTenantId());
        }
        try {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Populating environment of the file " + warURL.getFile()));
            }
            ComponentContext ctxParam = new ComponentContext(unpackedWarURL.getFile());
            ctxParam.rebind("DeploymentDesc", (Object)webDD);
            ctxParam.rebind("warName", (Object)unpackedWarURL.getFile());
            if (earDeployable != null) {
                ctxParam.rebind("earDeployable", (Object)earDeployable);
            }
            ctxParam.rebind("javaContext", (Object)javaContext);
            if (deployable != null) {
                ctxParam.rebind("warDeployable", (Object)deployable);
            }
            this.setWebEnvironment((Context)ctxParam, ezbInjectionHolder, (ClassLoader)webClassLoader);
        }
        catch (Exception e) {
            err = "Error when populating ";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        if (ejb3InWarContainer != null) {
            try {
                ejb3InWarContainer.start();
            }
            catch (EZBContainerException e) {
                err = "Unable to start EJB3 embedded in war";
                logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
                throw new JWebContainerServiceException(err, (Throwable)e);
            }
        }
        WebLoaderHolder holder = (WebLoaderHolder)this.warLoaders.get(warURL);
        holder.setEnvWebLoader((ClassLoader)webClassLoader);
        contextRoot = this.getContextRoot(contextRoot, earClassLoader, warURL, webDD);
        if (this.isMultitenantEnabled() && this.multitenantService.isMultitenant((IDeployable)deployable)) {
            contextRoot = this.updateContextRoot(contextRoot, (IDeployable)deployable);
        }
        String versionID = null;
        if (this.isVersioningEnabled()) {
            versionID = earURL != null ? this.versioningService.getVersionID((IDeployable)earDeployable) : this.versioningService.getVersionID(warURL);
        }
        if (versionID == null) {
            userURI = contextRoot;
        } else {
            if (!contextRoot.contains(versionID)) {
                userURI = contextRoot;
                contextRoot = contextRoot + versionID;
            } else {
                userURI = contextRoot.replace(versionID, "");
            }
            if (userURI.equals("/") && contextRoot.charAt(0) == '/') {
                contextRoot = contextRoot.substring(1);
            }
        }
        String hostName = webDD.getHost();
        List<War> deployedWars = this.getWar(contextRoot);
        for (War deployedWar : deployedWars) {
            String hostDeployed = deployedWar.getHostName();
            if ((hostDeployed != null || hostName != null) && (hostDeployed == null || !hostDeployed.equals(hostName))) continue;
            String err9 = "Cannot deploy war '" + warURL.getFile() + "' is already deployed with the context '" + contextRoot + "'." + " You must undeploy the war before a new deployment.";
            throw new JWebContainerServiceException(err9);
        }
        boolean java2DelegationModel = webDD.getJava2DelegationModel();
        if (!java2DelegationModel) {
            logger.log(BasicLevel.INFO, (Object)("The application " + warURL.getFile() + " has its java2-delegation-model parameter set " + "to false. JOnAS 5 offers a new possibility called the filtering class loader that can replace this parameter " + "and doesn't suffer from the many unexpected behaviours caused by class loader inversion. Please see to JOnAS " + "configuration guide for details."));
        }
        war = new War(warURL, earURL, hostName, contextRoot, java2DelegationModel, webDD.getXmlContent(), webDD.getJOnASXmlContent(), webDD.getServletsName(), deployable);
        if (ejb3InWarContainer != null) {
            war.setEjb3ContainerId(ejb3InWarContainer.getId());
        }
        PermissionManager permissionManager = null;
        try {
            boolean removePContext = true;
            if (earClassLoader != null) {
                removePContext = false;
            }
            permissionManager = new PermissionManager(webDD, war.getContextId(), removePContext);
            permissionManager.translateServletDeploymentDescriptor();
            if (earClassLoader == null) {
                permissionManager.translateSecurityRoleMapping();
                permissionManager.commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String err10 = "Cannot build permission manager object for the webapp '" + unpackedWarURL + "'";
            logger.log(BasicLevel.ERROR, (Object)(err10 + ": " + e.getMessage()));
            throw new JWebContainerServiceException(err10, (Throwable)e);
        }
        ComponentContext ctxParam = null;
        try {
            ctxParam = new ComponentContext(unpackedWarURL.getFile());
            ctxParam.rebind("war", (Object)war);
            ctxParam.rebind("unpackedWarURL", (Object)unpackedWarURL);
            ctxParam.rebind("parentCL", (Object)webClassLoader);
            ctxParam.rebind(FilteringClassLoader.class.getName(), (Object)filteringClassLoader);
            ctxParam.rebind("webDD", (Object)webDD);
            ctxParam.rebind("userURI", (Object)userURI);
            ctxParam.rebind("webservices-metadatas", (Object)webDD.getWebServices());
            if (earAppName != null) {
                ctxParam.rebind("earAppName", (Object)earAppName);
            }
            if (deployable != null) {
                ctxParam.rebind(WARDeployable.class.getName(), (Object)deployable);
            }
            if (ezbInjectionHolder != null) {
                ctxParam.rebind(EZBInjectionHolder.class.getName(), (Object)ezbInjectionHolder);
            }
        }
        catch (NamingException e) {
            String err11 = "Error when deploying the war  '" + unpackedWarURL.getFile() + "'";
            logger.log(BasicLevel.ERROR, (Object)(err11 + e.getMessage()));
            throw new JWebContainerServiceException(err11, (Throwable)e);
        }
        war.setPermissionManager(permissionManager);
        if (parentLoader != null) {
            try {
                ctxParam.bind("ejbClassLoader", (Object)parentLoader);
            }
            catch (NamingException e) {
                throw new JWebContainerServiceException("Unable to bind a parameter", (Throwable)e);
            }
        }
        if (earClassLoader != null) {
            try {
                ctxParam.bind("earClassLoader", (Object)earClassLoader);
            }
            catch (NamingException e) {
                throw new JWebContainerServiceException("Unable to bind a parameter", (Throwable)e);
            }
        }
        this.doRegisterWar((Context)ctxParam);
        this.warDeployed.add(war);
        this.warBindings.put(warURL, webClassLoader);
        this.unpackedWARs.put(warURL, unpackedWarURL);
        if (this.isMultitenantEnabled()) {
            Object oldTenantContext = this.multitenantService.getTenantContext();
            try {
                this.multitenantService.setTenantIdInContext(this.getTenantId((IDeployable)deployable));
                this.registerWarMBean(war, this.getDomainName(), warURL.getFile());
            }
            finally {
                this.multitenantService.setTenantContext(oldTenantContext);
            }
        } else {
            this.registerWarMBean(war, this.getDomainName(), warURL.getFile());
        }
        if (this.jaxrpcService != null && earClassLoader == null) {
            try {
                ComponentContext contctx = null;
                try {
                    contctx = new ComponentContext(unpackedWarURL.getFile());
                    contctx.rebind("classloader", (Object)loaderForCls);
                    contctx.rebind("parentObjectName", ctxParam.lookup("WebModule"));
                    contctx.rebind("isInEar", (Object)Boolean.FALSE);
                }
                catch (NamingException e) {
                    String err12 = "Can not bind params for the WebServices service, can't complete deployment of Web Services Endpoints";
                    throw new JWebContainerServiceException(err12, (Throwable)e);
                }
                this.jaxrpcService.completeWSDeployment((Context)contctx);
            }
            catch (ServiceException se) {
                String err13 = "Error during the deployment of the WebServices of the War file '" + warURL + "'";
                logger.log(BasicLevel.ERROR, (Object)(err13 + " : " + se.getMessage()));
                throw new JWebContainerServiceException(err13, (Throwable)se);
            }
        }
        StringBuffer txtInfo = new StringBuffer("War " + URLUtils.urlToFile((URL)warURL).getName() + " available at the context ");
        if (!contextRoot.startsWith("/")) {
            txtInfo.append("/");
        }
        txtInfo.append(contextRoot);
        if (hostName != null) {
            txtInfo.append(" on the host ");
            txtInfo.append(hostName);
        }
        txtInfo.append(".");
        logger.log(BasicLevel.INFO, (Object)txtInfo.toString());
        if (this.jaxrpcService != null && earClassLoader == null) {
            this.jaxrpcService.removeCache((ClassLoader)loaderForCls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilteringClassLoader createFilteringClassLoader(WARDeployable deployable, URLClassLoader parentLoader, URL unpackedWarURL) {
        ClassLoader parent = parentLoader == null ? this.extClassLoader : parentLoader;
        FilteringClassLoader filteringClassLoader = new FilteringClassLoader(parent);
        IArchive archive = null;
        archive = deployable != null ? deployable.getArchive() : ArchiveManager.getInstance().getArchive((Object)unpackedWarURL);
        try {
            String name = "WEB-INF/classloader-filtering.xml";
            URL definition = archive.getResource(name);
            if (definition != null) {
                filteringClassLoader.setDefinitionUrl(definition);
            }
        }
        catch (ArchiveException ae) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                String message = "Cannot get classloader-filtering.xml file from the archive " + archive;
                logger.log(BasicLevel.DEBUG, (Object)message, (Throwable)ae);
            }
        }
        finally {
            archive.close();
        }
        filteringClassLoader.start();
        return filteringClassLoader;
    }

    private void applyWSGenIfNeeded(String path) throws DeployerException {
        if (this.jaxrpcService == null) {
            logger.log(BasicLevel.DEBUG, (Object)"The JAX-RPC service is not present, no need to call WSGen");
            return;
        }
        if (!this.jaxrpcService.isAutoWsGenEngaged()) {
            logger.log(BasicLevel.DEBUG, (Object)"Automatic WsGen is not enabled, no need to call WSGen");
            return;
        }
        IArchive archive = ArchiveManager.getInstance().getArchive((Object)new File(path));
        String jonasVersionWsGen = archive.getMetadata().get("WsGen-JOnAS-Version");
        if (Version.getNumber().equals(jonasVersionWsGen)) {
            logger.log(BasicLevel.DEBUG, (Object)"No change: no need to call WSGen");
            return;
        }
        try {
            IDeployable deployable = this.deployableHelper.getDeployable(archive);
            this.jaxrpcService.applyWSGen(deployable);
        }
        catch (Exception e) {
            throw new DeployerException((Throwable)e);
        }
    }

    protected String getContextRoot(String contextRoot, URLClassLoader earClassLoader, URL warURL, WebContainerDeploymentDesc webDD) {
        if (earClassLoader == null && contextRoot == null) {
            String file;
            String cRoot = webDD.getContextRoot();
            contextRoot = cRoot == null ? ((file = new File(warURL.getFile()).getName()).toLowerCase().endsWith(".war") ? file.substring(0, file.length() - WAR_EXTENSION_LENGTH) : file.substring(0, file.length())) : cRoot;
        }
        if (contextRoot.startsWith("/") && !contextRoot.equals("/")) {
            logger.log(BasicLevel.WARN, (Object)("Context-Root '" + contextRoot + "' contains invalid starting / in the name. Fixing it."));
            int c = 0;
            while (contextRoot.charAt(c) == '/') {
                ++c;
            }
            contextRoot = contextRoot.substring(c);
        }
        return contextRoot;
    }

    protected String getTenantId(IDeployable deployable) {
        String tenantId = null;
        if (this.isMultitenantEnabled()) {
            if (this.multitenantService.getTenantContext() != null) {
                tenantId = this.multitenantService.getTenantIdFromContext();
            }
            if (tenantId == null) {
                tenantId = this.multitenantService.getTenantIdDeployableInfo(deployable);
            }
        }
        if (tenantId != null) {
            return tenantId;
        }
        return null;
    }

    protected String getInstanceName() {
        if (this.isMultitenantEnabled() && this.multitenantService.getTenantContext() != null) {
            return this.multitenantService.getInstanceNameFromContext();
        }
        return null;
    }

    protected String updateContextRoot(String contextRoot, IDeployable deployable) {
        String tenantId = this.getTenantId(deployable);
        String instanceName = this.getInstanceName();
        if (instanceName != null) {
            contextRoot = instanceName + "/" + contextRoot;
        }
        if (tenantId != null) {
            contextRoot = tenantId + "/" + contextRoot;
        }
        return contextRoot;
    }

    public void registerWar(String fileName) throws RemoteException, JWebContainerServiceException {
        URL warURL = this.checkWarFile(fileName);
        ComponentContext ctx = null;
        try {
            ctx = new ComponentContext(fileName);
            ctx.rebind("warURL", (Object)warURL);
        }
        catch (NamingException e) {
            String err = "Error when deploying the war  '" + fileName + "'";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        this.registerWar((Context)ctx);
    }

    public void registerWar(WARDeployable deployable) throws JWebContainerServiceException {
        ComponentContext ctx = null;
        try {
            ctx = new ComponentContext(deployable.getModuleName());
            ctx.rebind("warURL", (Object)deployable.getArchive().getURL());
            ctx.rebind("deployable", (Object)deployable);
        }
        catch (Exception e) {
            String err = "Error when deploying the war  '" + deployable.getModuleName() + "'";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        this.registerWar((Context)ctx);
    }

    protected void setWebEnvironment(Context ctxParam, EZBInjectionHolder ezbInjectionHolder, ClassLoader webAppClassLoader) throws JWebContainerServiceException {
        Context javaCtx;
        WARDeployable warDeployable;
        EARDeployable earDeployable;
        String warName;
        WebContainerDeploymentDesc dd;
        block47: {
            dd = null;
            warName = null;
            earDeployable = null;
            warDeployable = null;
            javaCtx = null;
            try {
                dd = (WebContainerDeploymentDesc)ctxParam.lookup("DeploymentDesc");
                warName = (String)ctxParam.lookup("warName");
                earDeployable = (EARDeployable)ctxParam.lookup("earDeployable");
                warDeployable = (WARDeployable)ctxParam.lookup("warDeployable");
            }
            catch (NamingException e) {
                if (earDeployable == null) break block47;
                String err = "Error while getting parameter from context param ";
                logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
                throw new JWebContainerServiceException(err, (Throwable)e);
            }
        }
        try {
            javaCtx = (Context)ctxParam.lookup("javaContext");
        }
        catch (NamingException e) {
            String err = "Error while getting parameter from context param ";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        try {
            LinkRef lref;
            String resname;
            this.naming.setComponentContext(javaCtx, webAppClassLoader);
            Context envCtx = (Context)javaCtx.lookup("comp/env");
            if (this.isMultitenantEnabled()) {
                String tenantId = this.getTenantId((IDeployable)warDeployable);
                if (tenantId != null) {
                    javaCtx.rebind("comp/tenantId", (Object)tenantId);
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)(warName + ": Binding object tenantId -> " + tenantId));
                    }
                } else if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(warName + ": Fail to bind object tenantId -> " + tenantId));
                }
            }
            IEnvEntryDesc[] envt = dd.getEnvEntryDesc();
            for (int i = 0; i < envt.length; ++i) {
                String name = envt[i].getName();
                Object obj = envt[i].getValue();
                String lookupName = envt[i].getLookupName();
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(warName + ": Binding object " + name + " -> " + obj));
                }
                if (lookupName != null) {
                    envCtx.rebind(name, (Object)new LinkRef(lookupName));
                    continue;
                }
                if (obj == null) continue;
                envCtx.rebind(name, obj);
            }
            IResourceRefDesc[] resref = dd.getResourceRefDesc();
            for (int i = 0; i < resref.length; ++i) {
                String name = resref[i].getName();
                String type = resref[i].getTypeName();
                resname = resref[i].getJndiName();
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(warName + ": Linking resource " + name + " -> " + resname));
                }
                if (type.equalsIgnoreCase("java.net.URL")) {
                    Reference ref = new Reference("java.net.URL", "org.ow2.jonas.lib.naming.URLFactory", null);
                    StringRefAddr refAddr = new StringRefAddr("url", resname);
                    ref.add(refAddr);
                    envCtx.rebind(name, (Object)ref);
                    continue;
                }
                lref = new LinkRef(resname);
                envCtx.rebind(name, (Object)lref);
            }
            IResourceEnvRefDesc[] resEnvref = dd.getResourceEnvRefDesc();
            for (int i = 0; i < resEnvref.length; ++i) {
                String name = resEnvref[i].getName();
                resname = resEnvref[i].getJndiName();
                lref = new LinkRef(resname);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(warName + ": Linking resource environment " + name + " -> " + resname));
                }
                envCtx.rebind(name, (Object)lref);
            }
            EjbRefDesc[] ejbref = dd.getEjbRefDesc();
            for (int i = 0; i < ejbref.length; ++i) {
                String name = ejbref[i].getEjbRefName();
                String ejbname = null;
                ejbname = ejbref[i].getJndiName();
                LinkRef lref2 = new LinkRef(ejbname);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(warName + ": Linking ejb " + name + " -> " + ejbname));
                }
                envCtx.rebind(name, (Object)lref2);
            }
            EjbLocalRefDesc[] ejblocalref = dd.getEjbLocalRefDesc();
            for (int i = 0; i < ejblocalref.length; ++i) {
                String name = ejblocalref[i].getEjbRefName();
                String ejbname = ejblocalref[i].getJndiLocalName();
                LinkRef lref3 = new LinkRef(ejbname);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(warName + ": Linking ejb " + name + " -> " + ejbname));
                }
                envCtx.rebind(name, (Object)lref3);
            }
            MessageDestinationRefDesc[] mdref = dd.getMessageDestinationRefDesc();
            for (int i = 0; i < mdref.length; ++i) {
                String name = mdref[i].getMessageDestinationRefName();
                String mdname = null;
                mdname = mdref[i].getJndiName();
                LinkRef lref4 = new LinkRef(mdname);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(warName + ": Linking message-destination " + name + " -> " + mdname));
                }
                envCtx.rebind(name, (Object)lref4);
            }
            if (this.jaxrpcService != null) {
                IServiceRefDesc[] serviceRefs = dd.getServiceRefDesc();
                for (int i = 0; i < serviceRefs.length; ++i) {
                    String name = serviceRefs[i].getServiceRefName();
                    Reference ref = this.jaxrpcService.buildServiceRef(serviceRefs[i], webAppClassLoader);
                    envCtx.rebind(name, (Object)ref);
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, (Object)("Adding service-ref 'java:comp/env/" + name + "'"));
                }
            }
            IENCBindingHolder encBindingHolder = dd.getENCBindingHolder();
            if (this.getDataSourceService() != null) {
                for (IENCBinding dataSourceDefinitionIENCBinding : encBindingHolder.getDataSourceBindings()) {
                    IJAnnotationSqlDataSourceDefinition dataSourceDefinition = (IJAnnotationSqlDataSourceDefinition)dataSourceDefinitionIENCBinding.getValue();
                    String normalizedDataSourceName = dataSourceDefinition.getName();
                    normalizedDataSourceName = normalizedDataSourceName.startsWith("java:") ? normalizedDataSourceName.replaceFirst("java:", "") : "comp/env/" + normalizedDataSourceName;
                    try {
                        if (javaCtx.lookup(normalizedDataSourceName) != null) {
                            continue;
                        }
                    }
                    catch (NamingException e) {
                        logger.log(BasicLevel.DEBUG, (Object)("Registering data-source " + dataSourceDefinition.getName()));
                    }
                    HashMap<String, String> dsProperties = new HashMap<String, String>();
                    for (String propertyString : dataSourceDefinition.getProperties()) {
                        String[] property = propertyString.split("=");
                        if (property.length != 2) continue;
                        dsProperties.put(property[0], property[1]);
                    }
                    String globalDSJndiName = this.getDataSourceService().deployDataSource(dataSourceDefinition.getClassName(), dataSourceDefinition.getDescription(), dataSourceDefinition.getUrl(), dataSourceDefinition.getUser(), dataSourceDefinition.getPassword(), dataSourceDefinition.getDatabaseName(), dataSourceDefinition.getPortNumber(), dataSourceDefinition.getServerName(), dataSourceDefinition.getIsolationLevel(), dataSourceDefinition.isTransactional(), dataSourceDefinition.getInitialPoolSize(), dataSourceDefinition.getMaxPoolSize(), dataSourceDefinition.getMinPoolSize(), dataSourceDefinition.getMaxIdleTime(), dataSourceDefinition.getMaxStatements(), dataSourceDefinition.getLoginTimeout(), dsProperties);
                    javaCtx.rebind(normalizedDataSourceName, (Object)new LinkRef(globalDSJndiName));
                }
            }
            if (ezbInjectionHolder != null) {
                String unitName;
                String encName;
                EZBPersistenceUnitManager persistenceUnitManager = ezbInjectionHolder.getPersistenceUnitManager();
                if (persistenceUnitManager != null) {
                    for (IENCBinding binding : encBindingHolder.getPersistenceContextBindings()) {
                        encName = binding.getName();
                        unitName = ((IJavaxPersistenceContext)binding.getValue()).getUnitName();
                        PersistenceContextType type = ((IJavaxPersistenceContext)binding.getValue()).getType();
                        EntityManager em = persistenceUnitManager.getEntityManager(unitName, type);
                        envCtx.rebind(encName, (Object)em);
                        if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                        logger.log(BasicLevel.DEBUG, (Object)("Adding persistence-context 'java:comp/env/" + encName + "'"));
                    }
                }
                for (IENCBinding binding : encBindingHolder.getPersistenceUnitBindings()) {
                    if (persistenceUnitManager == null) continue;
                    encName = binding.getName();
                    unitName = ((IJavaxPersistenceUnit)binding.getValue()).getUnitName();
                    EntityManagerFactory emf = persistenceUnitManager.getEntityManagerFactory(unitName);
                    envCtx.rebind(encName, (Object)emf);
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, (Object)("Adding persistence-unit 'java:comp/env/" + encName + "'"));
                }
                for (IENCBinding binding : encBindingHolder.getResourceBindings()) {
                    encName = binding.getName();
                    IJAnnotationResource jAnnotationResource = (IJAnnotationResource)binding.getValue();
                    if (jAnnotationResource.getLookup() == null) continue;
                    envCtx.rebind(encName, (Object)new LinkRef(jAnnotationResource.getLookup()));
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, (Object)("Adding @Resource 'java:comp/env/" + encName + "'"));
                }
                EZBJNDIResolver jndiResolver = ezbInjectionHolder.getJNDIResolver();
                if (jndiResolver != null) {
                    for (IENCBinding binding : encBindingHolder.getEJBBindings()) {
                        String encName2 = binding.getName();
                        IJEjbEJB jEjbEJB = (IJEjbEJB)binding.getValue();
                        String interfaceName = jEjbEJB.getBeanInterface();
                        String beanName = jEjbEJB.getBeanName();
                        String lookup = jEjbEJB.getLookup();
                        try {
                            String jndiName = lookup != null ? lookup : jndiResolver.getEJBJNDIUniqueName(interfaceName, beanName);
                            envCtx.rebind(encName2, (Object)new LinkRef(jndiName));
                            if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                            logger.log(BasicLevel.DEBUG, (Object)("Adding ejb 'java:comp/env/" + encName2 + "' from JNDIName '" + jndiName + "'."));
                        }
                        catch (EZBJNDIResolverException e) {
                            logger.log(BasicLevel.ERROR, (Object)("Cannot get JNDI name for enc name '" + encName2 + "'"), (Throwable)e);
                        }
                    }
                }
            }
            if (this.jaxwsService != null) {
                for (IENCBinding binding : encBindingHolder.getWebServicesBindings()) {
                    String name = binding.getName();
                    Reference ref = this.jaxwsService.createNamingReference((IJaxwsWebServiceRef)binding.getValue());
                    envCtx.rebind(name, (Object)ref);
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, (Object)("Adding WebServiceRef 'java:comp/env/" + name + "'."));
                }
            }
            if (earDeployable != null && this.isVersioningEnabled()) {
                String jndiPrefix = this.versioningService.getPrefix((IDeployable)earDeployable);
                if (jndiPrefix != null) {
                    envCtx.rebind("JNDILookupPrefix", (Object)jndiPrefix);
                }
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"Adding JNDI-lookup-prefix 'java:comp/env/JNDILookupPrefix'");
                }
            }
            envCtx.bind("BundleContext", (Object)this.bundleContext);
        }
        catch (NamingException e) {
            String err = "Error while populating environment of the war file " + warName;
            logger.log(BasicLevel.ERROR, (Object)(err + "  :" + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unRegisterWar(Context ctx) throws JWebContainerServiceException {
        EZBContainer ejb3container;
        URL warURL = null;
        boolean isEarCase = true;
        try {
            warURL = (URL)ctx.lookup("warURL");
            isEarCase = (Boolean)ctx.lookup("isEarCase");
        }
        catch (NamingException e) {
            String err = "Error while getting parameter from context param.";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        WARDeployable deployable = null;
        try {
            deployable = (WARDeployable)ctx.lookup("deployable");
        }
        catch (NamingException e) {
            deployable = null;
        }
        String fileName = warURL.getFile();
        War war = null;
        war = this.getWar(warURL);
        if (war == null) {
            String err = "Cannot undeploy war: '" + fileName + "' is not deployed.";
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new JWebContainerServiceException(err);
        }
        if (isEarCase != war.isInEarCase()) {
            String err = "Cannot undeploy war: '" + fileName + "' it is in an ear application. You must undeploy the ear associated.";
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new JWebContainerServiceException(err);
        }
        try {
            String hostName = war.getHostName();
            if (hostName != null) {
                ctx.rebind("hostName", (Object)war.getHostName());
            }
            ctx.rebind("contextRoot", (Object)war.getContextRoot());
            ctx.rebind("webClassLoader", this.warBindings.get(warURL));
        }
        catch (NamingException e) {
            String err = "Error when undeploying the war  '" + fileName + "'";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        PermissionManager permissionManager = war.getPermissionManager();
        try {
            permissionManager.delete();
            permissionManager = null;
        }
        catch (PermissionManagerException pme) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot remove permission manager for file '" + fileName + "'."), (Throwable)pme);
        }
        if (this.isMultitenantEnabled()) {
            Object oldTenantContext = this.multitenantService.getTenantContext();
            try {
                String tenantId = this.getTenantId((IDeployable)war.getWarDeployable());
                this.multitenantService.setTenantIdInContext(tenantId);
                this.doUnRegisterWar(ctx);
            }
            finally {
                this.multitenantService.setTenantContext(oldTenantContext);
            }
        } else {
            this.doUnRegisterWar(ctx);
        }
        if (war.getEjb3ContainerId() != null && (ejb3container = this.ejb3Service.getEasyBeansServer().getContainer(war.getEjb3ContainerId())) != null) {
            ejb3container.stop();
            this.ejb3Service.getEasyBeansServer().removeContainer(ejb3container);
        }
        if (this.jaxrpcService != null) {
            this.jaxrpcService.undeployWebServices(ctx);
        }
        URLClassLoader loader = (URLClassLoader)this.warBindings.remove(warURL);
        this.naming.unSetComponentContext((ClassLoader)loader);
        this.warLoaders.remove(warURL);
        this.warDeployed.remove(war);
        this.unpackedWARs.remove(warURL);
        if (this.isMultitenantEnabled()) {
            Object oldTenantContext = this.multitenantService.getTenantContext();
            try {
                String tenantId = this.getTenantId((IDeployable)war.getWarDeployable());
                this.multitenantService.setTenantIdInContext(tenantId);
                this.unregisterWarMBean(this.getDomainName(), fileName);
            }
            finally {
                this.multitenantService.setTenantContext(oldTenantContext);
            }
        } else {
            this.unregisterWarMBean(this.getDomainName(), fileName);
        }
        logger.log(BasicLevel.INFO, (Object)("War " + URLUtils.urlToFile((URL)warURL).getName() + " no longer available"));
    }

    public void unRegisterWar(String fileName) throws RemoteException, JWebContainerServiceException {
        URL warURL = this.checkWarDeployed(fileName);
        ComponentContext ctx = null;
        try {
            ctx = new ComponentContext(fileName);
            ctx.rebind("warURL", (Object)warURL);
            ctx.rebind("isEarCase", (Object)new Boolean(false));
        }
        catch (NamingException e) {
            String err = "Error when undeploying the war file '" + fileName + "'";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        this.unRegisterWar((Context)ctx);
    }

    public void unRegisterWar(WARDeployable deployable) throws JWebContainerServiceException {
        ComponentContext ctx = null;
        try {
            ctx = new ComponentContext(deployable.getModuleName());
            ctx.rebind("warURL", (Object)deployable.getArchive().getURL());
            ctx.rebind("isEarCase", (Object)Boolean.FALSE);
            ctx.rebind("deployable", (Object)deployable);
        }
        catch (Exception e) {
            String err = "Error when undeploying the war file '" + deployable.getModuleName() + "'";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        this.unRegisterWar((Context)ctx);
    }

    public void deployWars(Context ctx) throws JWebContainerServiceException {
        URL[] urls = null;
        URL earURL = null;
        EARDeployable earDeployable = null;
        List wars = null;
        ClassLoader parentClassLoader = null;
        ClassLoader earClassLoader = null;
        URL[] altDDs = null;
        String[] contextRoots = null;
        EZBInjectionHolder ejbInjectionHolder = null;
        Context appContext = null;
        try {
            urls = (URL[])ctx.lookup("urls");
            earURL = (URL)ctx.lookup("earURL");
            earDeployable = (EARDeployable)ctx.lookup("earDeployable");
            appContext = (Context)ctx.lookup("earApplicationContext");
            wars = (List)ctx.lookup("warDeployables");
            parentClassLoader = (ClassLoader)ctx.lookup("parentClassLoader");
            earClassLoader = (ClassLoader)ctx.lookup("earClassLoader");
            altDDs = (URL[])ctx.lookup("altDDs");
            contextRoots = (String[])ctx.lookup("contextRoots");
        }
        catch (NamingException e) {
            String err = "Error while getting parameter from context param ";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        try {
            ejbInjectionHolder = (EZBInjectionHolder)ctx.lookup(EZBInjectionHolder.class.getName());
        }
        catch (NamingException e) {
            logger.log(BasicLevel.DEBUG, (Object)"No persistence unit manager");
        }
        for (int i = 0; i < urls.length; ++i) {
            String fileName = URLUtils.urlToFile((URL)urls[i]).getPath();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Deploy war '" + fileName + "' for the ear service"));
            }
            ComponentContext contctx = null;
            try {
                contctx = new ComponentContext(fileName);
                contctx.rebind("warURL", (Object)urls[i]);
                contctx.rebind("parentClassLoader", (Object)parentClassLoader);
                contctx.rebind("earClassLoader", (Object)earClassLoader);
                contctx.rebind("earDeployable", (Object)earDeployable);
                contctx.rebind("deployable", wars.get(i));
                contctx.rebind("earApplicationContext", (Object)appContext);
                contctx.rebind("earURL", (Object)earURL);
                if (altDDs[i] != null) {
                    contctx.rebind("altDD", (Object)altDDs[i]);
                }
                if (contextRoots[i] != null) {
                    contctx.rebind("contextRoot", (Object)contextRoots[i]);
                }
                if (ejbInjectionHolder != null) {
                    contctx.rebind(EZBInjectionHolder.class.getName(), (Object)ejbInjectionHolder);
                }
                this.registerWar((Context)contctx);
                continue;
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Error when deploying '" + fileName + "'"));
                logger.log(BasicLevel.ERROR, (Object)e.getMessage());
                logger.log(BasicLevel.ERROR, (Object)"Undeploy war of the ear application");
                for (int j = 0; j < i; ++j) {
                    String warFileName = urls[j].getFile();
                    try {
                        ComponentContext context = new ComponentContext(warFileName);
                        context.rebind("warURL", (Object)urls[j]);
                        context.rebind("isEarCase", (Object)new Boolean(true));
                        this.unRegisterWar((Context)context);
                        continue;
                    }
                    catch (Exception ex) {
                        logger.log(BasicLevel.ERROR, (Object)("Error when undeploying '" + warFileName + "'"));
                        logger.log(BasicLevel.ERROR, (Object)ex.getMessage());
                        logger.log(BasicLevel.ERROR, (Object)"Cannot undeploy war of the ear application");
                    }
                }
                throw new JWebContainerServiceException("Error during the deployment", (Throwable)e);
            }
        }
    }

    public void unDeployWars(URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            String warFileName = urls[i].getFile();
            try {
                ComponentContext context = new ComponentContext(warFileName);
                context.rebind("warURL", (Object)urls[i]);
                context.rebind("isEarCase", (Object)new Boolean(true));
                this.unRegisterWar((Context)context);
                continue;
            }
            catch (Exception ex) {
                String message = "Error when undeploying '" + warFileName + "' from the Ear";
                logger.log(BasicLevel.ERROR, (Object)message, (Throwable)ex);
            }
        }
    }

    public War getWar(URL url) {
        for (War war : this.warDeployed) {
            if (!war.getWarURL().equals(url)) continue;
            return war;
        }
        return null;
    }

    protected List<War> getWar(String pContext) {
        ArrayList<War> checkDeployed = new ArrayList<War>();
        for (War war : this.warDeployed) {
            if (!war.getContextRoot().equals(pContext)) continue;
            checkDeployed.add(war);
        }
        return checkDeployed;
    }

    public void removeCache(ClassLoader earClassLoader) {
        WebDeploymentDescManager.getInstance().removeCache(earClassLoader);
    }

    protected URL checkWarFile(String fileName) throws JWebContainerServiceException {
        File f = null;
        try {
            f = new File(fileName).getCanonicalFile();
            if (!f.exists()) {
                boolean found = false;
            }
        }
        catch (IOException e) {
            String err = "Invalid war file name '" + fileName;
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        return URLUtils.fileToURL((File)f);
    }

    protected URL checkWarDeployed(String fileName) throws JWebContainerServiceException {
        URL url = null;
        try {
            for (War war : this.warDeployed) {
                url = URLUtils.fileToURL((File)new File(fileName).getCanonicalFile());
                URL deployedWarURL = war.getWarURL();
                String deployedWarPath = deployedWarURL.toString();
                if (deployedWarPath.endsWith(File.separator)) {
                    deployedWarPath = deployedWarPath.substring(0, deployedWarPath.length() - 1);
                }
                if (!deployedWarPath.equals(url.toString()) && !(deployedWarPath + "/").equals(url.toString())) continue;
                return deployedWarURL;
            }
            String err = "Cannot undeploy war: '" + fileName + "' is not deployed.";
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new JWebContainerServiceException(err);
        }
        catch (MalformedURLException e) {
            String err = "Invalid war file name '" + fileName + "'.";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        catch (IOException e) {
            String err = "Invalid war file name '" + fileName;
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
    }

    @Override
    public Integer getCurrentNumberOfWars() {
        return new Integer(this.warDeployed.size());
    }

    @Override
    public boolean isWarLoaded(String fileName) {
        boolean isLoaded;
        block5: {
            URL url = null;
            isLoaded = false;
            try {
                try {
                    url = URLUtils.fileToURL((File)new File(fileName).getCanonicalFile());
                    if (this.getWar(url) != null) {
                        isLoaded = true;
                        break block5;
                    }
                    url = null;
                }
                catch (Exception e) {
                    url = null;
                }
            }
            catch (Exception e) {
                String err = "Can not found if the war is deployed or not";
                logger.log(BasicLevel.ERROR, (Object)err);
                return false;
            }
        }
        return isLoaded;
    }

    @Override
    public List<String> getDeployedWars() {
        ArrayList<String> al = new ArrayList<String>();
        for (War war : this.warDeployed) {
            URL warURL = war.getWarURL();
            al.add(warURL.getFile());
        }
        return al;
    }

    @Override
    public String getServerName() {
        if (this.serverName == null) {
            this.updateServerInfos();
        }
        return this.serverName;
    }

    @Override
    public String getServerVersion() {
        if (this.serverVersion == null) {
            this.updateServerInfos();
        }
        return this.serverVersion;
    }

    public boolean isWarDeployedByWorkName(String unpackName) {
        for (URL unpackedURL : this.unpackedWARs.values()) {
            if (!URLUtils.urlToFile((URL)unpackedURL).getName().equals(unpackName)) continue;
            return true;
        }
        return false;
    }

    protected abstract void updateServerInfos();

    public abstract String getDefaultHost() throws JWebContainerServiceException;

    public abstract String getDefaultHttpPort() throws JWebContainerServiceException;

    public abstract String getDefaultHttpsPort() throws JWebContainerServiceException;

    protected static Logger getLogger() {
        return logger;
    }

    protected JNamingManager getNaming() {
        return this.naming;
    }

    protected void setServerName(String serverName) {
        this.serverName = serverName;
    }

    protected void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    protected JComponentContextFactory getContextFactory() {
        return this.contextFactory;
    }

    protected void registerWebServiceMBean(Object service, String domainName) {
        ObjectName on = JonasObjectName.webContainerService((String)domainName);
        this.jmxService.registerMBean(service, on);
    }

    protected void unregisterWebServiceMBean(String domainName) {
        ObjectName on = JonasObjectName.webContainerService((String)domainName);
        this.jmxService.unregisterMBean(on);
    }

    protected void registerWarMBean(War war, String domainName, String fileName) {
        try {
            ObjectName on = JonasObjectName.war((String)domainName, (String)fileName);
            this.jmxService.registerMBean((Object)war, on);
        }
        catch (MalformedObjectNameException e) {
            logger.log(BasicLevel.WARN, (Object)"Could not register War MBean", (Throwable)e);
        }
    }

    protected void unregisterWarMBean(String domainName, String fileName) {
        try {
            ObjectName on = JonasObjectName.war((String)domainName, (String)fileName);
            this.jmxService.unregisterMBean(on);
        }
        catch (MalformedObjectNameException e) {
            logger.log(BasicLevel.WARN, (Object)"Could not unregister War MBean", (Throwable)e);
        }
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setJSFService(JSFService jsfService) {
        this.jsfService = jsfService;
    }

    public JmxService getJmxService() {
        return this.jmxService;
    }

    public void setJAXRPCService(IJAXRPCService jaxrpcService) {
        this.jaxrpcService = jaxrpcService;
    }

    public void setNaming(JNamingManager naming) {
        this.naming = naming;
    }

    public void setContextFactory(JComponentContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    protected void initWorkingDirectory() {
        if (this.workSingleWebAppsFile == null) {
            this.workSingleWebAppsFile = new File(this.getWebappsWorkDirectory() + File.separator + this.getServerProperties().getServerName() + File.separator + SINGLE_WORK_WEBAPPS_DIR_SUFFIX);
            this.workSingleWebAppsFile.mkdirs();
        }
    }

    public void setWorkCleanerService(WorkCleanerService workCleanerService) {
        this.initWorkingDirectory();
        File fileLog = new File(this.workSingleWebAppsFile.getPath() + File.separator + this.getServerProperties().getServerName() + ".log");
        if (!fileLog.exists()) {
            try {
                fileLog.getParentFile().mkdirs();
                fileLog.createNewFile();
            }
            catch (IOException e) {
                logger.log(BasicLevel.ERROR, (Object)("cannot create the log file" + fileLog), (Throwable)e);
            }
        }
        try {
            this.deployerLog = new DeployerLog(fileLog);
            WarCleanTask cleanTask = new WarCleanTask(this, (IDeployerLog)this.deployerLog);
            workCleanerService.registerTask((CleanTask)cleanTask);
            workCleanerService.executeTasks();
        }
        catch (DeployerLogException e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot register the clean task", (Throwable)e);
        }
    }

    protected Hashtable getWarLoaders() {
        return this.warLoaders;
    }

    protected Hashtable getWarBindings() {
        return this.warBindings;
    }

    protected List<War> getWarDeployed() {
        return this.warDeployed;
    }

    protected IJAXRPCService getJAXRPCService() {
        return this.jaxrpcService;
    }

    protected ClassLoader getAppsClassLoader() {
        return this.extClassLoader;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    public void unsetVersioningService() {
        this.versioningService = null;
    }

    public VersioningService getVersioningService() {
        return this.versioningService;
    }

    public boolean isVersioningEnabled() {
        return this.versioningService != null && this.versioningService.isVersioningEnabled();
    }

    public void setMultitenantService(MultitenantService multitenantService) {
        this.multitenantService = multitenantService;
    }

    public void unsetMultitenantService() {
        this.multitenantService = null;
    }

    public MultitenantService getMultitenantService() {
        return this.multitenantService;
    }

    public boolean isMultitenantEnabled() {
        return this.multitenantService != null;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public void unsetAuditService() {
        this.auditService = null;
    }

    public AuditService getAuditService() {
        return this.auditService;
    }

    public void setWarDeployableMetadataFactory(IWarDeployableMetadataFactory warDeployableMetadataFactory) {
        WarDeployableMetadataFactoryHolder.setWarDeployableMetadataFactory((IWarDeployableMetadataFactory)warDeployableMetadataFactory);
    }

    public void bindJaxwsService(IJAXWSService jaxwsService) {
        this.jaxwsService = jaxwsService;
    }

    protected IJAXWSService getJAXWSService() {
        return this.jaxwsService;
    }

    public void unbindJaxwsService(IJAXWSService jaxwsService) {
        this.jaxwsService = null;
    }

    public void setEjb3Service(IEasyBeansService service) {
        this.ejb3Service = service;
    }

    public void unsetEjb3Service() {
        this.ejb3Service = null;
    }

    public void setDeployableHelper(IDeployableHelper deployableHelper) {
        this.deployableHelper = deployableHelper;
    }

    public void unsetDeployableHelper() {
        this.deployableHelper = null;
    }

    public void setOnDemandFeature(boolean onDemandFeatureEnabled) {
        this.onDemandFeatureEnabled = onDemandFeatureEnabled;
    }

    public void setOnDemandRedirectPort(int onDemandRedirectPort) {
        this.onDemandRedirectPort = onDemandRedirectPort;
    }

    public boolean isOnDemandFeatureEnabled() {
        return this.onDemandFeatureEnabled && this.getServerProperties().isDevelopment();
    }

    public int getOnDemandRedirectPort() {
        return this.onDemandRedirectPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRandomPort() {
        int retry;
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        int portNumber = 0;
        for (retry = 0; portNumber == 0 && retry < 50; ++retry) {
            int randomPort = 8950 + random.nextInt(50);
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket(randomPort);
                portNumber = randomPort;
                continue;
            }
            catch (IOException e) {
                logger.log(BasicLevel.DEBUG, (Object)"unable to listen on the server socket", (Throwable)e);
                continue;
            }
            finally {
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException e) {
                        logger.log(BasicLevel.DEBUG, (Object)"unable to close server socket", (Throwable)e);
                    }
                }
            }
        }
        if (retry == 50) {
            throw new IllegalStateException("Unable to choose a random free port");
        }
        return portNumber;
    }

    protected void setDefaultHttpPort(int portNumber) {
        Hashtable<String, String> httpServiceDictionary = new Hashtable<String, String>();
        ((Dictionary)httpServiceDictionary).put("org.osgi.service.http.port", Integer.toString(portNumber));
        if (this.osgiHttpService != null) {
            this.osgiHttpService.setProperties(httpServiceDictionary);
        }
        if (this.onDemandFeatureEnabled) {
            this.warDeployer.setOnDemandProxy(this.onDemandProxy);
            this.onDemandProxy.setWebContainerService(this);
            this.onDemandProxy.setHttpPortNumber(portNumber);
            if (this.onDemandRedirectPort == 0) {
                this.onDemandRedirectPort = this.getRandomPort();
            }
            this.onDemandProxy.setRedirectPortNumber(this.onDemandRedirectPort);
            try {
                this.onDemandProxy.enable();
            }
            catch (HttpOnDemandProxyException e) {
                logger.log(BasicLevel.ERROR, (Object)"Cannot start the OnDemand proxy for web container: ", (Throwable)e);
                throw new ServiceException("Cannot start the OnDemand proxy for web container", (Throwable)e);
            }
            logger.log(BasicLevel.INFO, (Object)("OnDemand Feature enabled: Listening on '" + this.onDemandProxy.getHttpPortNumber() + "' port (internal:" + this.onDemandProxy.getRedirectPortNumber() + ")."));
        }
    }

    protected void setDefaultHttpsPort(int portNumber) {
        Hashtable<String, String> httpServiceDictionary = new Hashtable<String, String>();
        ((Dictionary)httpServiceDictionary).put("org.osgi.service.http.port.secure", Integer.toString(portNumber));
        if (this.osgiHttpService != null) {
            this.osgiHttpService.setProperties(httpServiceDictionary);
        }
    }

    protected BundleContext getBundleContext() {
        return this.bundleContext;
    }

    protected String getWebappsWorkDirectory() {
        return this.getServerProperties().getWorkDirectory() + File.separator + "webapps";
    }

    public void addTldResource(URL tldResource) {
        this.tldResources.add(tldResource);
    }

    public void removeTldResource(URL tldResource) {
        this.tldResources.remove(tldResource);
    }

    public List<URL> getTLDResources() {
        return this.tldResources;
    }

    protected WARDeployer getWarDeployer() {
        return this.warDeployer;
    }

    public boolean isEjbinwarEnabled() {
        return this.ejbinwar;
    }

    public void setEjbinwar(boolean ejbinwar) {
        this.ejbinwar = ejbinwar;
    }

    public DataSourceService getDataSourceService() {
        return this.dataSourceService;
    }

    public void setDataSourceService(DataSourceService dataSourceService) {
        this.dataSourceService = dataSourceService;
    }

    public class WebLoaderHolder {
        private WebappClassLoader jonasWebLoader;
        private ClassLoader envWebLoader;

        public WebLoaderHolder(WebappClassLoader jonas, ClassLoader env) {
            this.jonasWebLoader = jonas;
            this.envWebLoader = env;
        }

        public WebappClassLoader getJonasWebLoader() {
            return this.jonasWebLoader;
        }

        public ClassLoader getEnvWebLoader() {
            return this.envWebLoader;
        }

        public void setEnvWebLoader(ClassLoader envWebLoader) {
            this.envWebLoader = envWebLoader;
        }

        public void setJonasWebLoader(WebappClassLoader jonasWebLoader) {
            this.jonasWebLoader = jonasWebLoader;
        }
    }
}

