/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingDeque;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingDeque;
import java.util.ArrayList;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import javax.resource.spi.work.WorkException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.AbstractReceiverWorker;
import org.mule.providers.ConnectException;
import org.mule.providers.jms.JmsClientAcknowledgeTransaction;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsSupport;
import org.mule.providers.jms.JmsTransaction;
import org.mule.providers.jms.RedeliveryHandler;
import org.mule.providers.jms.filters.JmsSelectorFilter;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.LifecycleException;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.ClassUtils;

public class MultiConsumerJmsMessageReceiver
extends AbstractMessageReceiver {
    protected final BlockingDeque consumers;
    protected volatile int receiversCount;
    private final JmsConnector jmsConnector;

    public MultiConsumerJmsMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
        this.jmsConnector = (JmsConnector)connector;
        boolean isTopic = this.jmsConnector.getTopicResolver().isTopic(endpoint, true);
        this.receiversCount = this.jmsConnector.getNumberOfConcurrentTransactedReceivers();
        if (isTopic && this.receiversCount != 1) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Destination " + this.getEndpoint().getEndpointURI() + " is a topic, but " + this.receiversCount + " receivers have been configured. Will configure only 1."));
            }
            this.receiversCount = 1;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating " + this.receiversCount + " sub-receivers for " + endpoint.getEndpointURI()));
        }
        this.consumers = new LinkedBlockingDeque(this.receiversCount);
        for (int i = 0; i < this.receiversCount; ++i) {
            this.consumers.addLast(new SubReceiver());
        }
    }

    protected void doStart() throws UMOException {
        this.logger.debug((Object)"doStart()");
        for (int i = 0; i < this.receiversCount; ++i) {
            SubReceiver sub = (SubReceiver)this.consumers.removeFirst();
            sub.doStart();
            this.consumers.addLast(sub);
        }
    }

    protected void doStop() throws UMOException {
        this.logger.debug((Object)"doStop()");
        for (int i = 0; i < this.receiversCount; ++i) {
            SubReceiver sub = (SubReceiver)this.consumers.removeFirst();
            sub.doStop();
            this.consumers.addLast(sub);
        }
    }

    protected void doConnect() throws Exception {
        this.logger.debug((Object)"doConnect()");
        for (int i = 0; i < this.receiversCount; ++i) {
            SubReceiver sub = (SubReceiver)this.consumers.removeFirst();
            sub.doConnect();
            this.consumers.addLast(sub);
        }
    }

    protected void doDisconnect() throws Exception {
        this.logger.debug((Object)"doDisconnect()");
        for (int i = 0; i < this.receiversCount; ++i) {
            SubReceiver sub = (SubReceiver)this.consumers.removeFirst();
            sub.doDisconnect();
            this.consumers.addLast(sub);
        }
    }

    protected void doDispose() {
        this.logger.debug((Object)"doDispose()");
    }

    protected class JmsWorker
    extends AbstractReceiverWorker {
        private final SubReceiver subReceiver;

        public JmsWorker(Message message, AbstractMessageReceiver receiver, SubReceiver subReceiver) {
            super(new ArrayList(1), receiver);
            this.subReceiver = subReceiver;
            this.messages.add(message);
        }

        protected Object preProcessMessage(Object message) throws Exception {
            Message m = (Message)message;
            if (MultiConsumerJmsMessageReceiver.this.logger.isDebugEnabled()) {
                MultiConsumerJmsMessageReceiver.this.logger.debug((Object)("Message received it is of type: " + ClassUtils.getSimpleName(message.getClass())));
                if (m.getJMSDestination() != null) {
                    MultiConsumerJmsMessageReceiver.this.logger.debug((Object)("Message received on " + m.getJMSDestination() + " (" + m.getJMSDestination().getClass().getName() + ")"));
                } else {
                    MultiConsumerJmsMessageReceiver.this.logger.debug((Object)"Message received on unknown destination");
                }
                MultiConsumerJmsMessageReceiver.this.logger.debug((Object)("Message CorrelationId is: " + m.getJMSCorrelationID()));
                MultiConsumerJmsMessageReceiver.this.logger.debug((Object)("Jms Message Id is: " + m.getJMSMessageID()));
            }
            if (m.getJMSRedelivered()) {
                RedeliveryHandler redeliveryHandler = MultiConsumerJmsMessageReceiver.this.jmsConnector.createRedeliveryHandler();
                redeliveryHandler.setConnector(MultiConsumerJmsMessageReceiver.this.jmsConnector);
                if (MultiConsumerJmsMessageReceiver.this.logger.isDebugEnabled()) {
                    MultiConsumerJmsMessageReceiver.this.logger.debug((Object)("Message with correlationId: " + m.getJMSCorrelationID() + " has redelivered flag set, handing off to Exception Handler"));
                }
                redeliveryHandler.handleRedelivery(m);
            }
            return m;
        }

        protected void bindTransaction(UMOTransaction tx) throws TransactionException {
            if (tx instanceof JmsTransaction) {
                if (MultiConsumerJmsMessageReceiver.this.logger.isDebugEnabled()) {
                    MultiConsumerJmsMessageReceiver.this.logger.debug((Object)(">>> !!  Binding " + this.subReceiver.session + " to " + MultiConsumerJmsMessageReceiver.this.jmsConnector.getConnection()));
                }
                tx.bindResource(MultiConsumerJmsMessageReceiver.this.jmsConnector.getConnection(), this.subReceiver.session);
            } else if (tx instanceof JmsClientAcknowledgeTransaction) {
                ((JmsClientAcknowledgeTransaction)tx).setMessage((Message)this.messages.get(0));
            }
        }
    }

    private class SubReceiver
    implements MessageListener {
        private final Log subLogger = LogFactory.getLog(this.getClass());
        private volatile Session session;
        private volatile MessageConsumer consumer;

        private SubReceiver() {
        }

        protected void doConnect() throws Exception {
            this.subLogger.debug((Object)"SUB doConnect()");
            this.createConsumer();
        }

        protected void doDisconnect() throws Exception {
            this.closeConsumer();
        }

        protected void closeConsumer() {
            MultiConsumerJmsMessageReceiver.this.jmsConnector.closeQuietly(this.consumer);
            this.consumer = null;
            MultiConsumerJmsMessageReceiver.this.jmsConnector.closeQuietly(this.session);
            this.session = null;
        }

        protected void doStart() throws UMOException {
            try {
                this.consumer.setMessageListener((MessageListener)this);
            }
            catch (JMSException e) {
                throw new LifecycleException(e, (Object)this);
            }
        }

        protected void doStop() throws UMOException {
            try {
                if (this.consumer != null) {
                    this.consumer.setMessageListener(null);
                }
            }
            catch (JMSException e) {
                throw new LifecycleException(e, (Object)this);
            }
        }

        protected void createConsumer() throws Exception {
            try {
                String durableName;
                JmsSupport jmsSupport = MultiConsumerJmsMessageReceiver.this.jmsConnector.getJmsSupport();
                if (this.session == null) {
                    this.session = MultiConsumerJmsMessageReceiver.this.jmsConnector.getSession(MultiConsumerJmsMessageReceiver.this.endpoint);
                }
                boolean topic = MultiConsumerJmsMessageReceiver.this.jmsConnector.getTopicResolver().isTopic(MultiConsumerJmsMessageReceiver.this.endpoint, true);
                Destination dest = jmsSupport.createDestination(this.session, MultiConsumerJmsMessageReceiver.this.endpoint.getEndpointURI().getAddress(), topic);
                String selector = null;
                if (MultiConsumerJmsMessageReceiver.this.endpoint.getFilter() != null && MultiConsumerJmsMessageReceiver.this.endpoint.getFilter() instanceof JmsSelectorFilter) {
                    selector = ((JmsSelectorFilter)MultiConsumerJmsMessageReceiver.this.endpoint.getFilter()).getExpression();
                } else if (MultiConsumerJmsMessageReceiver.this.endpoint.getProperties() != null) {
                    selector = (String)MultiConsumerJmsMessageReceiver.this.endpoint.getProperties().get("selector");
                }
                String tempDurable = (String)MultiConsumerJmsMessageReceiver.this.endpoint.getProperties().get("durable");
                boolean durable = MultiConsumerJmsMessageReceiver.this.jmsConnector.isDurable();
                if (tempDurable != null) {
                    durable = Boolean.valueOf(tempDurable);
                }
                if ((durableName = (String)MultiConsumerJmsMessageReceiver.this.endpoint.getProperties().get("durableName")) == null && durable && dest instanceof Topic) {
                    durableName = "mule." + MultiConsumerJmsMessageReceiver.this.jmsConnector.getName() + "." + MultiConsumerJmsMessageReceiver.this.endpoint.getEndpointURI().getAddress();
                    MultiConsumerJmsMessageReceiver.this.logger.debug((Object)("Jms Connector for this receiver is durable but no durable name has been specified. Defaulting to: " + durableName));
                }
                this.consumer = jmsSupport.createConsumer(this.session, dest, selector, MultiConsumerJmsMessageReceiver.this.jmsConnector.isNoLocal(), durableName, topic);
            }
            catch (JMSException e) {
                throw new ConnectException(e, (Object)this);
            }
        }

        public void onMessage(Message message) {
            try {
                MultiConsumerJmsMessageReceiver.this.getWorkManager().doWork(new JmsWorker(message, MultiConsumerJmsMessageReceiver.this, this));
            }
            catch (WorkException e) {
                throw new MuleRuntimeException(MessageFactory.createStaticMessage("Couldn't submit a work item to the WorkManager"), (Throwable)e);
            }
        }
    }
}

