/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms.i18n;

import org.mule.config.i18n.Message;
import org.mule.config.i18n.MessageFactory;
import org.mule.providers.jms.JmsMessageAdapter;
import org.mule.util.ClassUtils;
import org.mule.util.ObjectUtils;
import org.mule.util.StringMessageUtils;

public class JmsMessages
extends MessageFactory {
    private static final String BUNDLE_PATH = JmsMessages.getBundlePath("jms");

    public static Message connectorDoesNotSupportSyncReceiveWhenTransacted() {
        return JmsMessages.createMessage(BUNDLE_PATH, 2);
    }

    public static Message sessionShouldBeTransacted() {
        return JmsMessages.createMessage(BUNDLE_PATH, 4);
    }

    public static Message sessionShouldNotBeTransacted() {
        return JmsMessages.createMessage(BUNDLE_PATH, 5);
    }

    public static Message noMessageBoundForAck() {
        return JmsMessages.createMessage(BUNDLE_PATH, 6);
    }

    public static Message messageMarkedForRedelivery(JmsMessageAdapter jmsMessage) {
        String messageDescription = jmsMessage == null ? "[null message]" : jmsMessage.getUniqueId();
        return JmsMessages.createMessage(BUNDLE_PATH, 7, messageDescription);
    }

    public static Message failedToCreateAndDispatchResponse(Object object) {
        return JmsMessages.createMessage(BUNDLE_PATH, 8, ObjectUtils.toString(object, "null"));
    }

    public static Message tooManyRedeliveries(String id, String times) {
        return JmsMessages.createMessage(BUNDLE_PATH, 11, id, times);
    }

    public static Message invalidResourceType(Class expectedClass, Class actualClass) {
        return JmsMessages.createMessage(BUNDLE_PATH, 12, StringMessageUtils.toString(expectedClass), StringMessageUtils.toString(actualClass));
    }

    public static Message checkTransformer(String string, Class class1, String name) {
        return JmsMessages.createMessage(BUNDLE_PATH, 13, string, ClassUtils.getSimpleName(class1.getClass()), name);
    }
}

