/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.internal.realm.principal;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.ow2.jonas.security.internal.realm.lib.XML;
import org.ow2.jonas.security.internal.realm.principal.GroupMBean;

public class Group
implements Serializable,
GroupMBean {
    protected static final String SEPARATOR = ",";
    private String name = null;
    private Vector roles = new Vector();
    private String description = null;

    public Group() {
    }

    public Group(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setRoles(String roles) {
        StringTokenizer st = new StringTokenizer(roles, SEPARATOR);
        String role = null;
        while (st.hasMoreTokens()) {
            role = st.nextToken().trim();
            this.addRole(role);
        }
    }

    @Override
    public void addRole(String role) {
        if (!this.roles.contains(role)) {
            this.roles.addElement(role);
        }
    }

    @Override
    public void removeRole(String role) {
        if (this.roles.contains(role)) {
            this.roles.removeElement(role);
        }
    }

    public String getRoles() {
        String rolesList = "";
        Enumeration r = this.roles.elements();
        int nb = 0;
        String role = null;
        while (r.hasMoreElements()) {
            if (nb > 0) {
                rolesList = rolesList + ", ";
            }
            role = (String)r.nextElement();
            rolesList = rolesList + role;
        }
        return rolesList;
    }

    @Override
    public String[] getArrayRoles() {
        return this.roles.toArray(new String[this.roles.size()]);
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer("<group name=\"");
        xml.append(this.name);
        xml.append("\" description=\"");
        if (this.description != null) {
            xml.append(this.description);
        }
        xml.append("\"");
        XML.appendVectorToBuffer("roles=", xml, this.roles);
        xml.append(" />");
        return xml.toString();
    }

    public String toString() {
        return this.toXML();
    }
}

