/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.shell;

import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.ow2.jasmine.probe.JasmineCollectorInfo;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.shell.Util;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Command(name="indicator-properties", scope="jasmine", description="List properties for the given indicator type. Mandatory properties are flagged by an *")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class IndicatorProperties
implements Action,
Pojo {
    private InstanceManager __IM;
    private boolean __FprobeManager;
    @Requires
    JasmineProbeManager probeManager;
    private boolean __Ftype;
    @Option(name="-t", aliases={"--type"}, description="Indicator Type", required=true, multiValued=false)
    private String type;
    protected static Log logger = LogFactory.getLog(Util.class);
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;

    JasmineProbeManager __getprobeManager() {
        if (!this.__FprobeManager) {
            return this.probeManager;
        }
        return (JasmineProbeManager)this.__IM.onGet((Object)this, "probeManager");
    }

    void __setprobeManager(JasmineProbeManager jasmineProbeManager) {
        if (!this.__FprobeManager) {
            this.probeManager = jasmineProbeManager;
            return;
        }
        this.__IM.onSet((Object)this, "probeManager", (Object)jasmineProbeManager);
    }

    String __gettype() {
        if (!this.__Ftype) {
            return this.type;
        }
        return (String)this.__IM.onGet((Object)this, "type");
    }

    void __settype(String string) {
        if (!this.__Ftype) {
            this.type = string;
            return;
        }
        this.__IM.onSet((Object)this, "type", (Object)string);
    }

    public IndicatorProperties() {
        this(null);
    }

    private IndicatorProperties(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setprobeManager(null);
        this.__settype(null);
    }

    public Object execute(CommandSession commandSession) {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __execute(CommandSession commandSession) {
        logger.debug((Object)"", new Object[0]);
        try {
            JasmineCollectorInfo info = this.__getprobeManager().getIndicatorTypeInfo(this.__gettype());
            List properties = info.getPropertyInfos();
            if (properties == null) {
                logger.error((Object)("Invalid type " + this.__gettype()), new Object[0]);
                return null;
            }
            if (!properties.isEmpty()) {
                System.out.println("The properties flagged with * are mandatory:");
                for (JasminePropertyInfo prop : properties) {
                    System.out.println(prop.toString());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"indicator-properties failed", new Object[]{e});
        }
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("probeManager")) {
                this.__FprobeManager = true;
            }
            if (set.contains("type")) {
                this.__Ftype = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null && set.contains("execute$org_apache_felix_service_command_CommandSession")) {
            this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

