/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.service.report.internal;

import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.ow2.jonas.endpoint.collector.util.Util;
import org.ow2.jonas.event.provider.api.Event;
import org.ow2.jonas.event.provider.api.EventLevel;
import org.ow2.jonas.event.provider.api.IEventProvider;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.report.api.IReport;
import org.ow2.jonas.report.api.IReportExtension;
import org.ow2.jonas.report.generated.DateTimeType;
import org.ow2.jonas.report.generated.EventType;
import org.ow2.jonas.report.generated.EventsType;
import org.ow2.jonas.report.generated.InfoType;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.service.report.internal.ReportMBean;
import org.ow2.jonas.service.report.util.Utility;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.xml.sax.SAXException;

public class Report
extends AbsServiceImpl
implements IReport,
ReportMBean,
Pojo {
    private InstanceManager __IM;
    private boolean __FjmxService;
    private JmxService jmxService;
    private boolean __FobjectName;
    private ObjectName objectName;
    private boolean __FeventProvider;
    private IEventProvider eventProvider;
    public static final Log logger = LogFactory.getLog(Report.class);
    public static final File JONAS_BASE_DIR = new File(System.getProperty("jonas.base"));
    public static final File JONAS_REPORTS_DIR = new File(JONAS_BASE_DIR, "reports");
    public static final String DASH = "-";
    private boolean __FreportExtensions;
    private Map<IReportExtension, String> reportExtensions;
    private boolean __MdoStart;
    private boolean __MdoStop;
    private boolean __MgenerateReport;
    private boolean __MbindJmxService$org_ow2_jonas_jmx_JmxService;
    private boolean __MunbindJmxService$org_ow2_jonas_jmx_JmxService;
    private boolean __MbindEventProvider$org_ow2_jonas_event_provider_api_IEventProvider;
    private boolean __MbindReportExtension$org_ow2_jonas_report_api_IReportExtension$org_osgi_framework_ServiceReference;
    private boolean __MunbindReportExtension$org_ow2_jonas_report_api_IReportExtension;

    JmxService __getjmxService() {
        if (!this.__FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this.__IM.onGet((Object)this, "jmxService");
    }

    void __setjmxService(JmxService jmxService) {
        if (!this.__FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this.__IM.onSet((Object)this, "jmxService", (Object)jmxService);
    }

    ObjectName __getobjectName() {
        if (!this.__FobjectName) {
            return this.objectName;
        }
        return (ObjectName)this.__IM.onGet((Object)this, "objectName");
    }

    void __setobjectName(ObjectName objectName) {
        if (!this.__FobjectName) {
            this.objectName = objectName;
            return;
        }
        this.__IM.onSet((Object)this, "objectName", (Object)objectName);
    }

    IEventProvider __geteventProvider() {
        if (!this.__FeventProvider) {
            return this.eventProvider;
        }
        return (IEventProvider)this.__IM.onGet((Object)this, "eventProvider");
    }

    void __seteventProvider(IEventProvider iEventProvider) {
        if (!this.__FeventProvider) {
            this.eventProvider = iEventProvider;
            return;
        }
        this.__IM.onSet((Object)this, "eventProvider", (Object)iEventProvider);
    }

    Map __getreportExtensions() {
        if (!this.__FreportExtensions) {
            return this.reportExtensions;
        }
        return (Map)this.__IM.onGet((Object)this, "reportExtensions");
    }

    void __setreportExtensions(Map map) {
        if (!this.__FreportExtensions) {
            this.reportExtensions = map;
            return;
        }
        this.__IM.onSet((Object)this, "reportExtensions", (Object)map);
    }

    public Report(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private Report(InstanceManager _manager, BundleContext bundleContext) {
        this._setInstanceManager(_manager);
        this.__setreportExtensions(new HashMap());
    }

    protected void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__M_doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__M_doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __M_doStart() throws ServiceException {
        this.__getjmxService().loadDescriptors(this.getClass().getPackage().getName(), this.getClass().getClassLoader());
        this.__setobjectName(Util.getObjectName((String)(this.__getjmxService().getDomainName() + ":type=service,name=report")));
        if (this.__getobjectName() != null) {
            try {
                this.__getjmxService().registerModelMBean((Object)this, this.__getobjectName());
            }
            catch (Exception e) {
                logger.error((Object)"Could not register JOnAS report model MBean.", new Object[]{e});
            }
        }
    }

    protected void doStop() throws ServiceException {
        if (!this.__MdoStop) {
            this.__M_doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__M_doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __M_doStop() throws ServiceException {
        this.generateReport();
        if (this.__getjmxService() != null) {
            this.__getjmxService().unregisterModelMBean(this.__getobjectName());
        }
    }

    @Override
    public String generateReport() {
        String string;
        if (!this.__MgenerateReport) {
            return this.__M_generateReport();
        }
        try {
            this.__IM.onEntry((Object)this, "generateReport", new Object[0]);
            string = this.__M_generateReport();
            this.__IM.onExit((Object)this, "generateReport", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateReport", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_generateReport() {
        if (!JONAS_REPORTS_DIR.exists()) {
            JONAS_REPORTS_DIR.mkdirs();
        }
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-ss.SSSZ");
        String timestamp = simpleDateFormat.format(date);
        File logFile = new File(JONAS_REPORTS_DIR, "report-" + timestamp + ".log");
        EventsType eventsType = new EventsType();
        List eventTypeList = eventsType.getEvent();
        if (this.__geteventProvider() != null) {
            ArrayList<EventLevel> eventLevels = new ArrayList<EventLevel>();
            eventLevels.add(EventLevel.INFO);
            eventLevels.add(EventLevel.EXCEPTION);
            eventLevels.add(EventLevel.SEVERE);
            eventLevels.add(EventLevel.WARNING);
            List events = this.__geteventProvider().getEvents(eventLevels);
            if (events != null) {
                for (Event event : events) {
                    EventType eventType = new EventType();
                    eventType.setType(event.getType());
                    eventType.setValue(event.getValue());
                    eventType.setTimestamp(event.getTimestamp());
                    eventType.setSource(event.getSource());
                    eventTypeList.add(eventType);
                }
            }
        }
        InfoType info = new InfoType();
        DateTimeType currentTime = new DateTimeType();
        currentTime.setDateTime(Utility.date2XMLGregorianCalendar(date));
        currentTime.setTimestamp(BigInteger.valueOf(date.getTime()));
        info.setCurrentTime(currentTime);
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(org.ow2.jonas.report.generated.Report.class);
        for (IReportExtension reportExtension : this.__getreportExtensions().keySet()) {
            Object report = reportExtension.generateReport();
            if (report == null) continue;
            info.getAny().add(report);
            Class clazz = reportExtension.getRootClass();
            if (clazz == null) continue;
            classes.add(clazz);
        }
        org.ow2.jonas.report.generated.Report report = new org.ow2.jonas.report.generated.Report();
        report.setInfo(info);
        report.setEvents(eventsType);
        String rootClass = org.ow2.jonas.report.generated.Report.class.getPackage().getName();
        JAXBContext jaxbContext = null;
        try {
            jaxbContext = JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]));
        }
        catch (JAXBException e) {
            logger.error((Object)("Cannot create a new instance of JAXBContext object with rootClass " + rootClass), new Object[]{e});
        }
        if (jaxbContext != null) {
            Marshaller marshaller = null;
            try {
                marshaller = jaxbContext.createMarshaller();
            }
            catch (JAXBException e) {
                logger.error((Object)("Cannot create instanciate Marshaller from the JAXBContext " + jaxbContext), new Object[]{e});
            }
            if (marshaller != null) {
                ArrayList<Source> sources = new ArrayList<Source>();
                InputStream xsd = org.ow2.jonas.report.generated.Report.class.getClassLoader().getResourceAsStream("xsd/jonas-report.xsd");
                StreamSource streamSource = null;
                if (xsd != null) {
                    streamSource = new StreamSource(xsd);
                } else {
                    logger.error((Object)"Cannot find XSD xsd/jonas-report.xsd", new Object[0]);
                }
                sources.add(streamSource);
                for (IReportExtension reportExtension : this.__getreportExtensions().keySet()) {
                    Source source = reportExtension.getXsd();
                    if (source != null) {
                        sources.add(source);
                        continue;
                    }
                    logger.error((Object)("Cannot get XSD source of extension " + reportExtension.getClass().getName()), new Object[0]);
                }
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = null;
                if (streamSource != null) {
                    try {
                        schema = schemaFactory.newSchema(sources.toArray(new Source[sources.size()]));
                    }
                    catch (SAXException e) {
                        logger.error((Object)"Cannot create a new instance of Schema object with the given XSD xsd/jonas-report.xsd", new Object[]{e});
                    }
                    marshaller.setSchema(schema);
                }
                try {
                    marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                }
                catch (PropertyException e) {
                    logger.error((Object)("Cannot set property jaxb.formatted.output to " + Boolean.TRUE), new Object[]{e});
                }
                try {
                    marshaller.marshal((Object)report, logFile);
                }
                catch (JAXBException e) {
                    logger.error((Object)"Cannot marshall the JOnAS report", new Object[]{e});
                }
            }
        }
        return logFile.getAbsolutePath();
    }

    public void bindJmxService(JmxService jmxService) {
        if (!this.__MbindJmxService$org_ow2_jonas_jmx_JmxService) {
            this.__M_bindJmxService(jmxService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindJmxService$org_ow2_jonas_jmx_JmxService", new Object[]{jmxService});
            this.__M_bindJmxService(jmxService);
            this.__IM.onExit((Object)this, "bindJmxService$org_ow2_jonas_jmx_JmxService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindJmxService$org_ow2_jonas_jmx_JmxService", throwable);
            throw throwable;
        }
    }

    private void __M_bindJmxService(JmxService jmxService) {
        this.__setjmxService(jmxService);
    }

    public void unbindJmxService(JmxService jmxService) {
        if (!this.__MunbindJmxService$org_ow2_jonas_jmx_JmxService) {
            this.__M_unbindJmxService(jmxService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindJmxService$org_ow2_jonas_jmx_JmxService", new Object[]{jmxService});
            this.__M_unbindJmxService(jmxService);
            this.__IM.onExit((Object)this, "unbindJmxService$org_ow2_jonas_jmx_JmxService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindJmxService$org_ow2_jonas_jmx_JmxService", throwable);
            throw throwable;
        }
    }

    private void __M_unbindJmxService(JmxService jmxService) {
    }

    public void bindEventProvider(IEventProvider eventProvider) {
        if (!this.__MbindEventProvider$org_ow2_jonas_event_provider_api_IEventProvider) {
            this.__M_bindEventProvider(eventProvider);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindEventProvider$org_ow2_jonas_event_provider_api_IEventProvider", new Object[]{eventProvider});
            this.__M_bindEventProvider(eventProvider);
            this.__IM.onExit((Object)this, "bindEventProvider$org_ow2_jonas_event_provider_api_IEventProvider", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindEventProvider$org_ow2_jonas_event_provider_api_IEventProvider", throwable);
            throw throwable;
        }
    }

    private void __M_bindEventProvider(IEventProvider eventProvider) {
        this.__seteventProvider(eventProvider);
    }

    public void bindReportExtension(IReportExtension reportExtension, ServiceReference serviceReference) {
        if (!this.__MbindReportExtension$org_ow2_jonas_report_api_IReportExtension$org_osgi_framework_ServiceReference) {
            this.__M_bindReportExtension(reportExtension, serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindReportExtension$org_ow2_jonas_report_api_IReportExtension$org_osgi_framework_ServiceReference", new Object[]{reportExtension, serviceReference});
            this.__M_bindReportExtension(reportExtension, serviceReference);
            this.__IM.onExit((Object)this, "bindReportExtension$org_ow2_jonas_report_api_IReportExtension$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindReportExtension$org_ow2_jonas_report_api_IReportExtension$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    private void __M_bindReportExtension(IReportExtension reportExtension, ServiceReference serviceReference) {
        if (reportExtension != null) {
            String namespace = null;
            Object object = serviceReference.getProperty("namespace");
            if (object != null) {
                namespace = String.valueOf(object);
            }
            this.__getreportExtensions().put(reportExtension, namespace);
        }
    }

    public void unbindReportExtension(IReportExtension reportExtension) {
        if (!this.__MunbindReportExtension$org_ow2_jonas_report_api_IReportExtension) {
            this.__M_unbindReportExtension(reportExtension);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindReportExtension$org_ow2_jonas_report_api_IReportExtension", new Object[]{reportExtension});
            this.__M_unbindReportExtension(reportExtension);
            this.__IM.onExit((Object)this, "unbindReportExtension$org_ow2_jonas_report_api_IReportExtension", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindReportExtension$org_ow2_jonas_report_api_IReportExtension", throwable);
            throw throwable;
        }
    }

    private void __M_unbindReportExtension(IReportExtension reportExtension) {
        this.__getreportExtensions().remove(reportExtension);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("eventProvider")) {
                this.__FeventProvider = true;
            }
            if (set.contains("jmxService")) {
                this.__FjmxService = true;
            }
            if (set.contains("objectName")) {
                this.__FobjectName = true;
            }
            if (set.contains("reportExtensions")) {
                this.__FreportExtensions = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("generateReport")) {
                this.__MgenerateReport = true;
            }
            if (set.contains("bindJmxService$org_ow2_jonas_jmx_JmxService")) {
                this.__MbindJmxService$org_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("unbindJmxService$org_ow2_jonas_jmx_JmxService")) {
                this.__MunbindJmxService$org_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("bindEventProvider$org_ow2_jonas_event_provider_api_IEventProvider")) {
                this.__MbindEventProvider$org_ow2_jonas_event_provider_api_IEventProvider = true;
            }
            if (set.contains("bindReportExtension$org_ow2_jonas_report_api_IReportExtension$org_osgi_framework_ServiceReference")) {
                this.__MbindReportExtension$org_ow2_jonas_report_api_IReportExtension$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("unbindReportExtension$org_ow2_jonas_report_api_IReportExtension")) {
                this.__MunbindReportExtension$org_ow2_jonas_report_api_IReportExtension = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

