/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.rest.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineProbeException;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.jasmine.probe.api.generated.ErrorType;
import org.ow2.jasmine.probe.api.generated.IndicatorBaseType;
import org.ow2.jasmine.probe.api.generated.IndicatorResource;
import org.ow2.jasmine.probe.api.generated.Link;
import org.ow2.jasmine.probe.api.generated.PropType;
import org.ow2.jasmine.probe.rest.Indicators;
import org.ow2.jasmine.probe.rest.impl.RestUtil;

public class JIndicators
implements Indicators {
    private JasmineProbeManager jpManager = null;

    public JIndicators(JasmineProbeManager jpManager) {
        this.jpManager = jpManager;
    }

    @Override
    public Response getIndicators(String type, boolean verbose, UriInfo ui) {
        ArrayList<JAXBElement> elementsList = new ArrayList<JAXBElement>();
        List indicList = this.jpManager.getIndicators();
        for (JasmineIndicator indic : indicList) {
            String indicType = indic.getType();
            if (type != null && !type.equals(indicType)) continue;
            String indicName = indic.getName();
            IndicatorResource indicElement = new IndicatorResource();
            indicElement.setName(indic.getName());
            URI indicUri = ui.getAbsolutePathBuilder().path(indicName).build(new Object[0]);
            indicElement.setHref(indicUri.toString());
            if (verbose) {
                indicElement.setType(indicType);
            }
            QName name = new QName("org.ow2.jasmine.probe:probe-config", "indicator");
            JAXBElement xmlElement = new JAXBElement(name, IndicatorResource.class, (Object)indicElement);
            elementsList.add(xmlElement);
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new GenericEntity<List<JAXBElement<IndicatorResource>>>(elementsList){}).type(MediaType.APPLICATION_XML_TYPE).build();
    }

    @Override
    public Response getIndicator(String name, UriInfo ui) {
        JasmineIndicator jindic;
        UriBuilder ub = ui.getAbsolutePathBuilder();
        String indicatorUri = ub.build(new Object[]{""}).toString();
        String baseUri = indicatorUri.substring(0, indicatorUri.lastIndexOf(name));
        try {
            jindic = this.jpManager.getIndicator(name);
        }
        catch (JasmineProbeException e) {
            ErrorType err = new ErrorType();
            err.setMessage(e.getMessage());
            QName qname = new QName("org.ow2.jasmine.probe:probe-config", "error");
            JAXBElement errElem = new JAXBElement(qname, ErrorType.class, (Object)err);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errElem).type("application/xml").build();
        }
        IndicatorResource indicator = new IndicatorResource();
        indicator.setName(name);
        indicator.setType(jindic.getType());
        indicator.setHref(indicatorUri);
        int scale = jindic.getScale();
        indicator.setScale(Integer.valueOf(scale));
        ArrayList<Link> links = new ArrayList<Link>();
        List sources = jindic.getSources();
        for (String source : sources) {
            Link link = new Link();
            link.setRel("source");
            UriBuilder builder = UriBuilder.fromPath((String)baseUri);
            URI uri = builder.path(source).build(new Object[0]);
            link.setHref(uri.toString());
            links.add(link);
        }
        indicator.setSource(sources);
        indicator.setLink(links);
        ArrayList<PropType> property = new ArrayList<PropType>();
        for (String propKey : jindic.getProperties().keySet()) {
            String propValue = (String)jindic.getProperties().get(propKey);
            PropType prop = new PropType();
            prop.setValue(propValue);
            prop.setKey(propKey);
            property.add(prop);
        }
        indicator.setProperty(property);
        QName qname = new QName("org.ow2.jasmine.probe:probe-config", "indicator");
        JAXBElement indicResource = new JAXBElement(qname, IndicatorResource.class, (Object)indicator);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)indicResource).type(MediaType.APPLICATION_XML_TYPE).build();
    }

    @Override
    public Response createIndicator(IndicatorBaseType indicatorDef) {
        JasmineIndicator indicator = new JasmineIndicator();
        indicator.setName(indicatorDef.getName());
        indicator.setScale(indicatorDef.getScale());
        indicator.setType(indicatorDef.getType());
        HashMap<String, String> properties = new HashMap<String, String>();
        for (PropType prop : indicatorDef.getProperty()) {
            properties.put(prop.getKey(), prop.getValue());
        }
        indicator.setProperties(properties);
        indicator.setSources(indicatorDef.getSource());
        try {
            this.jpManager.createIndicator(indicator);
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.BAD_REQUEST);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Override
    public Response changeIndicator(IndicatorBaseType indicatorDef, String name) {
        try {
            this.jpManager.getIndicator(name);
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.NOT_FOUND);
        }
        JasmineIndicator indicator = new JasmineIndicator();
        indicator.setName(name);
        indicator.setScale(indicatorDef.getScale());
        indicator.setType(indicatorDef.getType());
        HashMap<String, String> properties = new HashMap<String, String>();
        for (PropType prop : indicatorDef.getProperty()) {
            properties.put(prop.getKey(), prop.getValue());
        }
        indicator.setProperties(properties);
        indicator.setSources(indicatorDef.getSource());
        try {
            this.jpManager.changeIndicator(indicator);
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.BAD_REQUEST);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Override
    public Response deleteIndicator(String name) {
        try {
            this.jpManager.removeIndicator(name);
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.NOT_FOUND);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

