/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.rest.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.JasmineProbeException;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.jasmine.probe.api.generated.ErrorType;
import org.ow2.jasmine.probe.api.generated.Link;
import org.ow2.jasmine.probe.api.generated.ProbeConfType;
import org.ow2.jasmine.probe.api.generated.ProbeResource;
import org.ow2.jasmine.probe.api.generated.ProbeType;
import org.ow2.jasmine.probe.api.generated.Status;
import org.ow2.jasmine.probe.api.generated.StatusType;
import org.ow2.jasmine.probe.api.generated.TaskType;
import org.ow2.jasmine.probe.rest.Probes;
import org.ow2.jasmine.probe.rest.TasksManager;
import org.ow2.jasmine.probe.rest.impl.RestUtil;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JProbes
implements Probes {
    private Log logger = LogFactory.getLog(this.getClass());
    private JasmineProbeManager jpManager = null;
    private TasksManager taskManager = null;
    private static final String REST_OUTPUT_TYPE = "rest";
    private static final String REST_OUTPUT_PREFIX = "rest_out_";
    private static final String REST_OUTPUT_PROP = "taskId";

    public JProbes(JasmineProbeManager jpManager, TasksManager taskManager) {
        this.jpManager = jpManager;
        this.taskManager = taskManager;
    }

    @Override
    public Response getProbes(UriInfo ui) {
        ArrayList<JAXBElement> elementsList = new ArrayList<JAXBElement>();
        List probesList = this.jpManager.getProbes();
        for (JasmineProbe probe : probesList) {
            ProbeResource probeElement = this.createSimpleProbeResource(probe, ui);
            QName name = new QName("org.ow2.jasmine.probe:probe-config", "probe");
            JAXBElement xmlElement = new JAXBElement(name, ProbeResource.class, (Object)probeElement);
            elementsList.add(xmlElement);
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new GenericEntity<List<JAXBElement<ProbeResource>>>(elementsList){}).type(MediaType.APPLICATION_XML_TYPE).build();
    }

    @Override
    public Response getProbe(String probeId, UriInfo ui) {
        JasmineProbe jprobe;
        try {
            jprobe = this.jpManager.getProbe(probeId);
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.NOT_FOUND);
        }
        ProbeResource probe = this.createProbeResource(jprobe, ui);
        QName name = new QName("org.ow2.jasmine.probe:probe-config", "probe");
        JAXBElement probeResource = new JAXBElement(name, ProbeResource.class, (Object)probe);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)probeResource).type(MediaType.APPLICATION_XML_TYPE).build();
    }

    @Override
    public Response createProbe(ProbeType probeDef) {
        JasmineProbe probe = new JasmineProbe();
        probe.setId(probeDef.getId());
        probe.setPeriod(probeDef.getPeriod().intValue());
        probe.setIndicatorList(probeDef.getIndicator());
        probe.setOutputList(probeDef.getOutput());
        probe.setTargetList(probeDef.getTarget());
        boolean toStart = false;
        if (probeDef.getStatus() != null && probeDef.getStatus().equals((Object)StatusType.STARTED)) {
            probe.setStatus(4);
            toStart = true;
        }
        String probeId = null;
        try {
            probeId = this.jpManager.createProbe(probe);
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.BAD_REQUEST);
        }
        URI location = UriBuilder.fromPath((String)probeId).build(new Object[0]);
        if (toStart) {
            try {
                this.jpManager.startProbe(probeId);
                return Response.status((Response.Status)Response.Status.ACCEPTED).header("Location", (Object)location).build();
            }
            catch (JasmineProbeException e) {
                return RestUtil.errorResponse(e, Response.Status.BAD_REQUEST);
            }
        }
        return Response.created((URI)location).build();
    }

    @Override
    public Response changeProbe(ProbeConfType probeDef, String probeId) {
        try {
            this.jpManager.getProbe(probeId);
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.NOT_FOUND);
        }
        JasmineProbe probe = new JasmineProbe();
        probe.setId(probeId);
        Integer intPeriod = probeDef.getPeriod();
        if (intPeriod == null) {
            probe.setPeriod(0);
        } else {
            probe.setPeriod(intPeriod.intValue());
        }
        probe.setIndicatorList(probeDef.getIndicator());
        probe.setOutputList(probeDef.getOutput());
        probe.setTargetList(probeDef.getTarget());
        try {
            this.jpManager.changeProbe(probe);
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.BAD_REQUEST);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Override
    public Response changeProbePeriod(String probeId, String newPeriod) {
        int p;
        try {
            p = Integer.parseInt(newPeriod);
        }
        catch (NumberFormatException e) {
            ErrorType err = new ErrorType();
            err.setMessage(e.toString());
            QName qname = new QName("org.ow2.jasmine.probe:probe-config", "error");
            JAXBElement errElem = new JAXBElement(qname, ErrorType.class, (Object)err);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errElem).type("application/xml").build();
        }
        try {
            this.jpManager.changeProbePeriod(probeId, p);
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.NOT_FOUND);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Override
    public Response deleteProbe(String probeId) {
        try {
            this.jpManager.removeProbe(probeId);
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.NOT_FOUND);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Override
    public Response setState(String probeId, String actionName) {
        try {
            if ("start".equals(actionName)) {
                this.jpManager.startProbe(probeId);
            }
            if ("stop".equals(actionName)) {
                this.jpManager.stopProbe(probeId);
            }
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @Override
    public Response getDataTask(String probeId, UriInfo ui) {
        JasmineProbe probe = null;
        try {
            probe = this.jpManager.getProbe(probeId);
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.NOT_FOUND);
        }
        String taskId = this.taskManager.createTask(probeId);
        JasmineOutput jor = this.getRestOutput(taskId);
        if (jor == null) {
            return RestUtil.errorResponse(new JasmineProbeException("Cannot create task for probe " + probeId + " because cannot create REST output " + REST_OUTPUT_PREFIX + taskId), Response.Status.INTERNAL_SERVER_ERROR);
        }
        try {
            this.jpManager.createOutput(jor);
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        try {
            probe = this.jpManager.getProbe(probeId);
            List outputList = probe.getOutputList();
            if (!outputList.contains(jor.getName())) {
                outputList.add(jor.getName());
                probe.setOutputList(outputList);
                this.jpManager.changeProbe(probe);
            }
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        URI taskUri = ui.getBaseUriBuilder().path("data/" + taskId).build(new Object[0]);
        TaskType taskElement = new TaskType();
        taskElement.setHref(taskUri.toString());
        taskElement.setId(taskId);
        QName name = new QName("org.ow2.jasmine.probe:probe-config", "data");
        JAXBElement xmlElement = new JAXBElement(name, TaskType.class, (Object)taskElement);
        return Response.status((Response.Status)Response.Status.ACCEPTED).header("Location", (Object)taskUri).entity((Object)xmlElement).type(MediaType.APPLICATION_XML_TYPE).build();
    }

    @Override
    public Response deleteDataTask(String probeId) {
        JasmineProbe probe = null;
        try {
            probe = this.jpManager.getProbe(probeId);
            List outList = probe.getOutputList();
            JasmineOutput out = null;
            String outId = null;
            for (String outputId : outList) {
                String taskId;
                out = this.jpManager.getOutput(outputId);
                if (!REST_OUTPUT_TYPE.equals(out.getType()) || (taskId = (String)out.getProperties().get(REST_OUTPUT_PROP)) == null) continue;
                outId = outputId;
                this.taskManager.removeTask(taskId);
                break;
            }
            if (outId != null) {
                ArrayList updatedList = new ArrayList(outList);
                updatedList.remove(outId);
                probe.setOutputList(updatedList);
                this.jpManager.removeOutput(outId);
            }
        }
        catch (JasmineProbeException e) {
            return RestUtil.errorResponse(e, Response.Status.NOT_FOUND);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private ProbeResource createSimpleProbeResource(JasmineProbe probe, UriInfo ui) {
        ProbeResource probeResource = new ProbeResource();
        String probeId = probe.getId();
        URI probeUri = ui.getAbsolutePathBuilder().path(probeId).build(new Object[0]);
        probeResource.setId(probe.getId());
        probeResource.setHref(probeUri.toString());
        return probeResource;
    }

    private ProbeResource createProbeResource(JasmineProbe probe, UriInfo ui) {
        ProbeResource probeResource = this.createSimpleProbeResource(probe, ui);
        UriBuilder ub = ui.getAbsolutePathBuilder();
        String probePath = ui.getPath();
        String probeUri = ub.build(new Object[]{""}).toString();
        String probeBaseUri = probeUri.substring(0, probeUri.lastIndexOf(probePath));
        String indicatorsUri = probeBaseUri + "indicator";
        String outputsUri = probeBaseUri + "output";
        String targetsUri = probeBaseUri + "target";
        probeResource.setHref(probeUri);
        Integer value = probe.getPeriod();
        probeResource.setPeriod(value);
        ArrayList<Link> links = new ArrayList<Link>();
        ArrayList<String> indicators = new ArrayList<String>();
        List indicNames = probe.getIndicatorList();
        this.updateListAndLinks(indicNames, indicators, links, indicatorsUri);
        ArrayList<String> outputs = new ArrayList<String>();
        List outNames = probe.getOutputList();
        this.updateListAndLinks(outNames, outputs, links, outputsUri);
        ArrayList<String> targets = new ArrayList<String>();
        List targetNames = probe.getTargetList();
        this.updateListAndLinks(targetNames, targets, links, targetsUri);
        probeResource.setLink(links);
        probeResource.setIndicator(indicators);
        probeResource.setOutput(outputs);
        probeResource.setTarget(targets);
        Status status = null;
        int statusCode = probe.getStatus();
        switch (statusCode) {
            case 2: {
                status = Status.RUNNING;
                break;
            }
            case 1: 
            case 4: {
                status = Status.STARTED;
                break;
            }
            case 3: {
                status = Status.FAILED;
                break;
            }
            case 0: {
                status = Status.STOPPED;
                break;
            }
            default: {
                status = Status.INVALID;
            }
        }
        probeResource.setStatus(status);
        return probeResource;
    }

    private void updateListAndLinks(List<String> nameList, List<String> updateList, List<Link> links, String path) {
        for (String name : nameList) {
            Link link = new Link();
            link.setRel("down");
            UriBuilder builder = UriBuilder.fromPath((String)path);
            URI uri = builder.path(name).build(new Object[0]);
            link.setHref(uri.toString());
            links.add(link);
            updateList.add(name);
        }
    }

    private JasmineOutput getRestOutput(String taskId) {
        String defaultId = REST_OUTPUT_PREFIX + taskId;
        try {
            JasmineOutput output = this.jpManager.getOutput(defaultId);
            if (REST_OUTPUT_TYPE.equals(output.getType()) && output.getProperties().containsKey(REST_OUTPUT_PROP) && taskId.equals(output.getProperties().get(REST_OUTPUT_PROP))) {
                return output;
            }
            return null;
        }
        catch (JasmineProbeException e) {
            return this.createRestOutput(defaultId, taskId);
        }
    }

    private JasmineOutput createRestOutput(String outputId, String taskId) {
        JasmineOutput creaOutput = new JasmineOutput();
        creaOutput.setName(outputId);
        creaOutput.setType(REST_OUTPUT_TYPE);
        HashMap<String, String> creaOutProps = new HashMap<String, String>();
        creaOutProps.put(REST_OUTPUT_PROP, taskId);
        creaOutput.setProperties(creaOutProps);
        return creaOutput;
    }
}

