/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jndi.interceptors.impl.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.ow2.jonas.jndi.checker.api.IResourceCheckerInfo;
import org.ow2.jonas.jndi.interceptors.impl.datasource.ConnectionClassUtils;
import org.ow2.jonas.jndi.interceptors.impl.datasource.DatasourceWrapper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public abstract class ConnectionProxy
implements InvocationHandler {
    private static Log logger = LogFactory.getLog(ConnectionProxy.class);
    private static final Method CLOSE_METHOD = ConnectionClassUtils.getCloseMethod();
    private Connection delegate = null;
    private boolean forceClose = false;
    private List<StackTraceElement> callerStackTrace;

    public ConnectionProxy(Connection delegate) {
        this.delegate = delegate;
        this.initCallerStackTrace();
    }

    public void setForceClose(boolean forceClose) {
        this.forceClose = forceClose;
    }

    public boolean isForceClose() {
        return this.forceClose;
    }

    protected Connection delegate() {
        return this.delegate;
    }

    private void initCallerStackTrace() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        this.callerStackTrace = new ArrayList<StackTraceElement>();
        boolean wrapperFound = false;
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            if (wrapperFound) {
                this.callerStackTrace.add(stackTraceElement);
            }
            if (!DatasourceWrapper.class.getName().equals(stackTraceElement.getClassName()) || !"getConnection".equals(stackTraceElement.getMethodName())) continue;
            wrapperFound = true;
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws SQLException, Throwable {
        if (CLOSE_METHOD.equals(method)) {
            this.unregisterConnection();
        }
        try {
            return method.invoke((Object)this.delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    protected abstract void unregisterConnection();

    public abstract void registerConnection();

    protected void autoCloseOrWarn(IResourceCheckerInfo resourceCheckerInfo) {
        if (this.isForceClose()) {
            logger.warn((Object)"JDBC connection not closed by the caller, close has been forced by the server. Stack trace of the getConnection() call is ''{0}''. Additional info ''{1}''", new Object[]{this.callerStackTrace.toString().replace(",", "\n"), resourceCheckerInfo.getCallerInfo()});
            try {
                this.delegate().close();
            }
            catch (SQLException e) {
                logger.error((Object)"Unable to force the close of the JDBC connection", new Object[]{e});
            }
        } else {
            logger.warn((Object)"JDBC connection not closed by the caller. Stack trace of the getConnection() call is ''{0}''. Additional info ''{1}''", new Object[]{this.callerStackTrace.toString().replace(",", "\n"), resourceCheckerInfo.getCallerInfo()});
        }
    }
}

