/*
 * Decompiled with CFR 0.152.
 */
package javax.jms;

import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;

public class QueueRequestor {
    private QueueSession session;
    private TemporaryQueue temporaryQueue;
    private QueueSender sender;
    private QueueReceiver receiver;

    public QueueRequestor(QueueSession session, Queue queue) throws JMSException {
        if (queue == null) {
            throw new InvalidDestinationException("Invalid queue");
        }
        this.session = session;
        this.temporaryQueue = session.createTemporaryQueue();
        this.sender = session.createSender(queue);
        this.receiver = session.createReceiver(this.temporaryQueue);
    }

    public Message request(Message message) throws JMSException {
        message.setJMSReplyTo(this.temporaryQueue);
        this.sender.send(message);
        return this.receiver.receive();
    }

    public void close() throws JMSException {
        this.session.close();
        this.temporaryQueue.delete();
    }
}

