/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.handler.completer;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import jline.console.ConsoleReader;
import jline.console.CursorBuffer;
import jline.console.completer.CandidateListCompletionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShelbieCandidateListCompletionHandler
extends CandidateListCompletionHandler {
    @Override
    public boolean complete(ConsoleReader reader, List<CharSequence> candidates, int pos) throws IOException {
        CursorBuffer buf = reader.getCursorBuffer();
        if (candidates.size() == 1) {
            CharSequence value = candidates.get(0);
            if (value.equals(buf.toString())) {
                return false;
            }
            ShelbieCandidateListCompletionHandler.setBuffer(reader, value, pos);
            return true;
        }
        if (candidates.size() > 1) {
            String value = this.getUnambiguousCompletions(buf, candidates);
            ShelbieCandidateListCompletionHandler.setBuffer(reader, value, pos);
        }
        ShelbieCandidateListCompletionHandler.printCandidates(reader, candidates);
        reader.drawLine();
        return true;
    }

    private String getUnambiguousCompletions(CursorBuffer buf, List<CharSequence> candidates) {
        String[] strings;
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        String buffer = buf.toString();
        if (buffer.contains(":")) {
            strings = candidates.toArray(new String[candidates.size()]);
        } else {
            HashSet<String> scopeAndCommands = new HashSet<String>();
            for (CharSequence c : candidates) {
                String[] scopeAndCommand = c.toString().split(":");
                if (scopeAndCommand[0].startsWith(buffer)) {
                    scopeAndCommands.add(scopeAndCommand[0]);
                }
                if (!scopeAndCommand[1].startsWith(buffer)) continue;
                scopeAndCommands.add(scopeAndCommand[1]);
            }
            strings = scopeAndCommands.toArray(new String[scopeAndCommands.size()]);
        }
        StringBuilder candidate = new StringBuilder();
        for (int i = 0; i < strings[0].length() && this.startsWith(strings[0].substring(0, i + 1), strings); ++i) {
            candidate.append(strings[0].charAt(i));
        }
        return candidate.toString();
    }

    private boolean startsWith(String starts, String[] candidates) {
        for (String candidate : candidates) {
            if (candidate.startsWith(starts)) continue;
            return false;
        }
        return true;
    }
}

