/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.jmx.internal;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.ow2.jasmine.probe.JasmineIndicValue;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;
import org.ow2.jasmine.probe.collectors.jmx.Metric;
import org.ow2.jasmine.probe.util.CsvConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxCollector
extends JCollector {
    private String pattern;
    private ObjectName objname = null;
    private Collection<String> attrlist;
    private List<Metric> metrics = null;
    private JasmineIndicValue cached = null;

    public JmxCollector(String name, JasmineIndicator indicator, int period, String mbean, String csv) {
        super(name, indicator, period);
        this.pattern = mbean;
        this.attrlist = CsvConverter.csv2list((String)csv);
        if (this.attrlist == null) {
            // empty if block
        }
    }

    public ObjectName getObjectName() throws JasmineCollectorException {
        if (this.objname == null) {
            try {
                this.objname = new ObjectName(this.pattern);
            }
            catch (MalformedObjectNameException e) {
                throw new JasmineCollectorException("Malformed pattern: " + this.pattern);
            }
            catch (NullPointerException e) {
                throw new JasmineCollectorException("Null pattern");
            }
        }
        return this.objname;
    }

    public String[] getAttributes() {
        String[] ret = new String[this.attrlist.size()];
        int i = 0;
        for (String elem : this.attrlist) {
            String attrname = this.attrName(elem);
            ret[i++] = attrname;
            this.logger.debug((Object)attrname, new Object[0]);
        }
        return ret;
    }

    public JasmineIndicValue getLastResult() throws JasmineCollectorException {
        if (this.cached != null) {
            this.logger.debug((Object)"cached value returned", new Object[0]);
            return this.cached;
        }
        if (this.metrics == null) {
            this.logger.warn((Object)"No result ready to return", new Object[0]);
            return null;
        }
        JasmineIndicValue jiv = new JasmineIndicValue();
        String name = this.getIndicator().getName();
        this.logger.debug((Object)name, new Object[0]);
        jiv.setName(name);
        for (Metric metric : this.metrics) {
            if (metric.getAttributeList().size() == 0) {
                this.logger.warn((Object)("Result with no value: " + metric.toString()), new Object[0]);
                continue;
            }
            for (Attribute att : metric.getAttributeList()) {
                Number value;
                JasmineSingleResult jsr;
                String aname;
                Object attval;
                if (att.getValue() == null) {
                    this.logger.warn((Object)("no value for this indicator: " + att.getName()), new Object[0]);
                    continue;
                }
                if (att.getValue().getClass().isArray()) {
                    this.logger.debug((Object)("array: " + att.getName()), new Object[0]);
                    attval = (Array)att.getValue();
                    for (int i = 0; i < Array.getLength(attval); ++i) {
                        String aname2 = att.getName() + "[" + i + "]";
                        JasmineSingleResult jasmineSingleResult = new JasmineSingleResult();
                        jasmineSingleResult.setName(aname2);
                        jasmineSingleResult.setTimestamp(metric.getTimestamp());
                        Number value2 = (Number)Array.get(attval, i);
                        if (this.indicator.getScale() != 1) {
                            value2 = this.divideValues(value2, this.indicator.getScale());
                        }
                        jasmineSingleResult.setValue(value2);
                        jiv.addValue(jasmineSingleResult);
                    }
                    continue;
                }
                if (att.getValue() instanceof Map) {
                    this.logger.debug((Object)("map: " + att.getName()), new Object[0]);
                    attval = (Map)att.getValue();
                    TreeSet ts = new TreeSet(attval.keySet());
                    for (Object object : ts) {
                        aname = att.getName() + "." + object.toString();
                        if (!this.isWanted(aname)) continue;
                        jsr = new JasmineSingleResult();
                        jsr.setName(aname);
                        jsr.setTimestamp(metric.getTimestamp());
                        value = (Number)attval.get(object);
                        if (this.indicator.getScale() != 1) {
                            value = this.divideValues(value, this.indicator.getScale());
                        }
                        jsr.setValue(value);
                        jiv.addValue(jsr);
                    }
                    continue;
                }
                if (att.getValue() instanceof CompositeData) {
                    this.logger.debug((Object)("composite: " + att.getName()), new Object[0]);
                    attval = (CompositeData)att.getValue();
                    Set<String> ks = attval.getCompositeType().keySet();
                    for (String string : ks) {
                        aname = att.getName() + "." + string.toString();
                        if (!this.isWanted(aname)) continue;
                        jsr = new JasmineSingleResult();
                        jsr.setName(aname);
                        jsr.setTimestamp(metric.getTimestamp());
                        value = (Number)attval.get(string);
                        if (this.indicator.getScale() != 1) {
                            value = this.divideValues(value, this.indicator.getScale());
                        }
                        jsr.setValue(value);
                        jiv.addValue(jsr);
                    }
                    continue;
                }
                String aname3 = att.getName();
                this.logger.debug((Object)("simple: " + aname3), new Object[0]);
                if (this.isWanted(aname3)) {
                    JasmineSingleResult jsr3 = new JasmineSingleResult();
                    jsr3.setName(aname3);
                    jsr3.setTimestamp(metric.getTimestamp());
                    Number value3 = (Number)att.getValue();
                    if (this.indicator.getScale() != 1) {
                        value3 = this.divideValues(value3, this.indicator.getScale());
                    }
                    jsr3.setValue(value3);
                    jiv.addValue(jsr3);
                    continue;
                }
                this.logger.warn((Object)("Attribute not wanted ? " + aname3), new Object[0]);
            }
        }
        this.cached = jiv;
        this.metrics = null;
        return jiv;
    }

    public void stopPolling() {
        this.logger.debug((Object)"", new Object[0]);
    }

    public boolean needResult() {
        if (this.metrics == null) {
            return true;
        }
        long timestamp = this.metrics.get(0).getTimestamp();
        return this.oldvalue(timestamp);
    }

    public void addResult(List<Metric> metrics) {
        if (metrics.size() == 0) {
            this.logger.warn((Object)"Empty metric list", new Object[0]);
            return;
        }
        this.logger.debug((Object)"", new Object[0]);
        this.metrics = metrics;
        this.cached = null;
    }

    private boolean oldvalue(long timestamp) {
        long now = System.currentTimeMillis();
        return now - timestamp > (long)(this.period * 1000);
    }

    private String attrName(String elem) {
        if (elem.endsWith("]")) {
            return elem.substring(0, elem.indexOf(91));
        }
        if (elem.indexOf(46) > 0) {
            return elem.substring(0, elem.indexOf(46));
        }
        return elem;
    }

    private boolean isWanted(String attr) {
        String root = this.attrName(attr);
        for (String elem : this.attrlist) {
            if (!elem.equals(attr) && !elem.equals(root)) continue;
            return true;
        }
        return false;
    }
}

