/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.correlate.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.ow2.jasmine.probe.JasmineIndicValue;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelateCollector
extends JCollector {
    private int ope;
    private Collection<JasmineCollector> sources;

    public CorrelateCollector(String key, JasmineIndicator indic, int period, int ope, Collection<JasmineCollector> sources) {
        super(key, indic, period);
        this.ope = ope;
        this.sources = sources;
    }

    public JasmineIndicValue getLastResult() throws JasmineCollectorException {
        this.logger.debug((Object)"", new Object[0]);
        JasmineIndicValue jiv = new JasmineIndicValue();
        JasmineSingleResult jsr = new JasmineSingleResult();
        long timestamp = System.currentTimeMillis();
        Number result = 0;
        ArrayList<Number> liste = new ArrayList<Number>();
        Number number1 = null;
        Number number2 = null;
        int count = 0;
        for (JasmineCollector elem : this.sources) {
            JasmineIndicValue jivs = elem.getLastResult();
            if (jivs == null) {
                this.logger.warn((Object)"No result available on source indicator", new Object[0]);
                return null;
            }
            if (jivs.getValues().size() > 1) {
                this.logger.warn((Object)"Correlation on multivalued indicator not supported", new Object[0]);
                throw new JasmineCollectorException("Correlation on multivalued indicator not supported");
            }
            Iterator i$ = jivs.getValues().iterator();
            if (i$.hasNext()) {
                JasmineSingleResult jsr1 = (JasmineSingleResult)i$.next();
                liste.add(jsr1.getValue());
                if (count == 0) {
                    number1 = jsr1.getValue();
                } else if (count == 1) {
                    number2 = jsr1.getValue();
                }
            }
            ++count;
        }
        switch (this.ope) {
            case 1: {
                result = this.addValues(liste);
                break;
            }
            case 2: {
                result = this.diffValues(number1, number2);
                break;
            }
            case 3: {
                result = this.multiplyValues(liste);
                break;
            }
            case 4: {
                result = this.divideValues(number1, number2);
                break;
            }
            case 5: {
                result = 100L * this.divideValues(number1, number2);
                break;
            }
            default: {
                throw new JasmineCollectorException("Bad correlate operation");
            }
        }
        if (this.indicator.getScale() != 1) {
            result = this.divideValues(result, this.indicator.getScale());
        }
        jsr.setTimestamp(timestamp);
        jsr.setValue(result);
        jsr.setName(this.indicator.getName());
        jiv.setName(this.indicator.getName());
        jiv.addValue(jsr);
        return jiv;
    }

    public void stopPolling() {
        this.logger.debug((Object)"", new Object[0]);
    }
}

