/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.make.component;

import aQute.lib.osgi.Annotation;
import aQute.lib.osgi.ClassDataCollector;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Verifier;
import aQute.libg.reporter.Reporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentAnnotationReader
extends ClassDataCollector {
    static Pattern BINDDESCRIPTOR = Pattern.compile("\\(L([^;]*);(Ljava/util/Map;|Lorg/osgi/framework/ServiceReference;)*\\)V");
    static Pattern BINDMETHOD = Pattern.compile("(set|bind|add)(.)(.*)");
    static Pattern ACTIVATEDESCRIPTOR = Pattern.compile("\\(((Lorg/osgi/service/component/ComponentContext;)|(Lorg/osgi/framework/BundleContext;)|(Ljava/util/Map;))*\\)V");
    static Pattern OLDACTIVATEDESCRIPTOR = Pattern.compile("\\(Lorg/osgi/service/component/ComponentContext;\\)V");
    static Pattern OLDBINDDESCRIPTOR = Pattern.compile("\\(L([^;]*);\\)V");
    static Pattern REFERENCEBINDDESCRIPTOR = Pattern.compile("\\(Lorg/osgi/framework/ServiceReference;\\)V");
    Reporter reporter = new Processor();
    String method;
    String methodDescriptor;
    int methodAccess;
    String className;
    Clazz clazz;
    String[] interfaces;
    Set<String> multiple = new HashSet<String>();
    Set<String> optional = new HashSet<String>();
    Set<String> dynamic = new HashSet<String>();
    Map<String, String> map = new HashMap<String, String>();
    Set<String> descriptors = new HashSet<String>();
    List<String> properties = new ArrayList<String>();
    boolean v1_1_0;
    static Pattern PROPERTY_PATTERN = Pattern.compile("[^=]+=.+");

    ComponentAnnotationReader(Clazz clazz) {
        this.clazz = clazz;
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public static Map<String, String> getDefinition(Clazz c) throws Exception {
        return ComponentAnnotationReader.getDefinition(c, new Processor());
    }

    public static Map<String, String> getDefinition(Clazz c, Reporter reporter) throws Exception {
        ComponentAnnotationReader r = new ComponentAnnotationReader(c);
        r.setReporter(reporter);
        c.parseClassFileWithCollector(r);
        r.finish();
        return r.map;
    }

    @Override
    public void annotation(Annotation annotation) {
        if (annotation.getName().equals("LaQute/bnd/annotation/component/Component;")) {
            String[] p;
            this.set("name:", annotation.get("name"), "<>");
            this.set("factory:", annotation.get("factory"), false);
            this.setBoolean("enabled:", annotation.get("enabled"), true);
            this.setBoolean("immediate:", annotation.get("immediate"), false);
            this.setBoolean("servicefactory:", annotation.get("servicefactory"), false);
            String configurationPolicy = (String)annotation.get("configurationPolicy");
            if (configurationPolicy != null) {
                this.set("configuration-policy:", configurationPolicy.toLowerCase(), "<>");
            }
            this.doProperties(annotation);
            Object[] provides = (Object[])annotation.get("provide");
            if (provides == null) {
                if (this.interfaces != null) {
                    p = new String[this.interfaces.length];
                    for (int i = 0; i < this.interfaces.length; ++i) {
                        p[i] = this.interfaces[i].replace('/', '.');
                    }
                } else {
                    p = new String[]{};
                }
            } else {
                p = new String[provides.length];
                for (int i = 0; i < provides.length; ++i) {
                    p[i] = this.descriptorToFQN(provides[i].toString());
                }
            }
            if (p.length > 0) {
                this.set("provide:", Processor.join(Arrays.asList(p)), "<>");
            }
        } else if (annotation.getName().equals("LaQute/bnd/annotation/component/Activate;")) {
            if (!this.checkMethod()) {
                this.reporter.warning("Activate method %s.%s is not public or protected", this.clazz, this.method);
            }
            if (!ACTIVATEDESCRIPTOR.matcher(this.methodDescriptor).matches()) {
                this.reporter.error("Activate method for %s does not have an acceptable prototype, only Map, ComponentContext, or BundleContext is allowed. Found: %s", this.className, this.methodDescriptor);
            }
            if (!this.method.equals("activate") || !OLDACTIVATEDESCRIPTOR.matcher(this.methodDescriptor).matches()) {
                this.v1_1_0 = true;
                this.set("activate:", this.method, "<>");
            }
        } else if (annotation.getName().equals("LaQute/bnd/annotation/component/Deactivate;")) {
            if (!this.checkMethod()) {
                this.reporter.warning("Deactivate method %s.%s is not public or protected", this.clazz, this.method);
            }
            if (!ACTIVATEDESCRIPTOR.matcher(this.methodDescriptor).matches()) {
                this.reporter.error("Deactivate method for %s does not have an acceptable prototype, only Map, ComponentContext, or BundleContext is allowed. Found: %s", this.className, this.methodDescriptor);
            }
            if (!this.method.equals("deactivate") || !OLDACTIVATEDESCRIPTOR.matcher(this.methodDescriptor).matches()) {
                this.v1_1_0 = true;
                this.set("deactivate:", this.method, "<>");
            }
        } else if (annotation.getName().equals("LaQute/bnd/annotation/component/Modified;")) {
            if (!this.checkMethod()) {
                this.reporter.warning("Modified method %s.%s is not public or protected", this.clazz, this.method);
            }
            this.set("modified:", this.method, "<>");
            this.v1_1_0 = true;
        } else if (annotation.getName().equals("LaQute/bnd/annotation/component/Reference;")) {
            Integer c;
            String service;
            if (!this.checkMethod()) {
                this.reporter.warning("Reference method %s.%s is not public or protected", this.clazz, this.method);
            }
            String name = (String)annotation.get("name");
            String bind = this.method;
            String unbind = null;
            if (name == null) {
                Matcher m = BINDMETHOD.matcher(this.method);
                name = m.matches() ? m.group(2).toLowerCase() + m.group(3) : this.method.toLowerCase();
            }
            String simpleName = name;
            unbind = (String)annotation.get("unbind");
            if (bind != null) {
                name = name + "/" + bind;
                if (unbind != null) {
                    name = name + "/" + unbind;
                }
            }
            if ((service = (String)annotation.get("service")) != null) {
                service = service.substring(1, service.length() - 1).replace('/', '.');
            } else {
                Matcher m = BINDDESCRIPTOR.matcher(this.methodDescriptor);
                if (m.matches()) {
                    service = m.group(1).replace('/', '.');
                } else {
                    throw new IllegalArgumentException("Cannot detect the type of a Component Reference from the descriptor: " + this.methodDescriptor);
                }
            }
            String target = (String)annotation.get("target");
            if (target != null) {
                Verifier.verifyFilter(target, 0);
                service = service + target;
            }
            if ((c = (Integer)annotation.get("type")) != null && !c.equals(0) && !c.equals(49)) {
                service = service + (char)c.intValue();
            }
            if (this.map.containsKey(name)) {
                this.reporter.error("In component %s, Multiple references with the same name: %s. Previous def: %s, this def: %s", name, this.map.get(name), service, "");
            }
            this.map.put(name, service);
            if (this.isTrue(annotation.get("multiple"))) {
                this.multiple.add(simpleName);
            }
            if (this.isTrue(annotation.get("optional"))) {
                this.optional.add(simpleName);
            }
            if (this.isTrue(annotation.get("dynamic"))) {
                this.dynamic.add(simpleName);
            }
            if (REFERENCEBINDDESCRIPTOR.matcher(this.methodDescriptor).matches() || !OLDBINDDESCRIPTOR.matcher(this.methodDescriptor).matches()) {
                this.v1_1_0 = true;
            }
        }
    }

    private boolean checkMethod() {
        return true;
    }

    private void doProperties(Annotation annotation) {
        Object[] properties = (Object[])annotation.get("properties");
        if (properties != null) {
            for (Object o : properties) {
                String p = (String)o;
                if (!PROPERTY_PATTERN.matcher(p).matches()) {
                    throw new IllegalArgumentException("Malformed property '" + p + "' on: " + annotation.get("name"));
                }
                this.properties.add(p);
            }
        }
    }

    private boolean isTrue(Object object) {
        if (object == null) {
            return false;
        }
        return (Boolean)object;
    }

    private void setBoolean(String string, Object object, boolean b) {
        Boolean bb;
        if (object == null) {
            object = b;
        }
        if ((bb = (Boolean)object) == b) {
            return;
        }
        this.map.put(string, bb.toString());
    }

    private void set(String string, Object object, Object deflt) {
        if (object == null || object.equals(deflt)) {
            return;
        }
        this.map.put(string, object.toString());
    }

    private String descriptorToFQN(String string) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < string.length() - 1; ++i) {
            char c = string.charAt(i);
            if (c == '/') {
                c = '.';
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public void classBegin(int access, String name) {
        this.className = name;
    }

    @Override
    public void implementsInterfaces(String[] interfaces) {
        this.interfaces = interfaces;
    }

    @Override
    public void method(int access, String name, String descriptor) {
        this.method = name;
        this.methodDescriptor = descriptor;
        this.methodAccess = access;
        this.descriptors.add(this.method);
    }

    void set(String name, Collection<String> l) {
        if (l.size() == 0) {
            return;
        }
        this.set(name, Processor.join(l), "<>");
    }

    public void finish() {
        this.set("multiple:", this.multiple);
        this.set("dynamic:", this.dynamic);
        this.set("optional:", this.optional);
        this.set("implementation:", this.clazz.getFQN(), "<>");
        this.set("properties:", this.properties);
        if (this.v1_1_0) {
            this.set("version:", "1.1.0", "<>");
            this.reporter.trace("Component %s is v1.1", this.map);
        }
        this.set(".descriptors:", this.descriptors);
    }
}

