/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.df.internal;

import java.util.Collection;
import java.util.Map;
import org.ow2.jasmine.probe.JasmineIndicValue;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;
import org.ow2.jasmine.probe.util.CsvConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfCollector
extends JCollector {
    private Collection<String> diskList = null;
    private JasmineIndicValue cache = null;
    private static final long OBSOLATE_TIME = 3000L;

    public DfCollector(String name, JasmineIndicator indicator, int period) {
        super(name, indicator, period);
        Map props = indicator.getProperties();
        this.diskList = CsvConverter.csv2list((String)((String)props.get("disk")));
    }

    public Collection<String> getDiskList() {
        return this.diskList;
    }

    public JasmineIndicValue getLastResult() throws JasmineCollectorException {
        JasmineIndicValue ret = this.cache;
        this.logger.debug((Object)("value=" + ret), new Object[0]);
        if (this.indicator.getScale() != 1) {
            for (JasmineSingleResult jsr : ret.getValues()) {
                long value = this.longValue(jsr.getValue()) / (long)this.indicator.getScale();
                jsr.setValue((Number)value);
            }
        }
        this.cache = null;
        return ret;
    }

    public void stopPolling() {
        this.logger.debug((Object)"", new Object[0]);
    }

    public boolean needResult() {
        if (this.cache == null) {
            return true;
        }
        long timestamp = this.cache.getTimestamp();
        if (this.oldvalue(timestamp)) {
            this.cache = null;
            return true;
        }
        return false;
    }

    public void addResult(JasmineIndicValue value) {
        this.logger.debug((Object)value.getName(), new Object[0]);
        this.cache = value;
    }

    private boolean oldvalue(long timestamp) {
        long now = System.currentTimeMillis();
        return now - timestamp > (long)(this.period * 1000) + 3000L;
    }
}

