/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.derived.internal;

import org.ow2.jasmine.probe.JasmineIndicValue;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;

public class DerivedCollector
extends JCollector {
    private int ope;
    private String operation;
    private JasmineCollector source;
    private JasmineIndicValue previous = null;

    public DerivedCollector(String name, JasmineIndicator indic, int period, String op, JasmineCollector source) {
        super(name, indic, period);
        this.operation = op;
        if (this.operation.equalsIgnoreCase("prev")) {
            this.ope = 1;
        } else if (this.operation.equalsIgnoreCase("delta")) {
            this.ope = 2;
        } else if (this.operation.equalsIgnoreCase("rate")) {
            this.ope = 3;
        } else {
            String err = "Operation not supported in DerivedCollectorService: " + this.operation;
            this.logger.error((Object)err, new Object[0]);
            return;
        }
        this.source = source;
    }

    public JasmineIndicValue getLastResult() throws JasmineCollectorException {
        this.logger.debug((Object)"", new Object[0]);
        JasmineIndicValue current = this.source.getLastResult();
        if (this.previous == null) {
            this.previous = current;
            this.logger.debug((Object)"First call: No previous value yet", new Object[0]);
            return null;
        }
        long curtime = current.getTimestamp();
        long timeslice = curtime - this.previous.getTimestamp();
        JasmineIndicValue jiv = new JasmineIndicValue();
        jiv.setName(this.indicator.getName());
        jiv.addMetadata("op", this.operation);
        for (JasmineSingleResult res : current.getValues()) {
            JasmineSingleResult old = this.previous.getValue(res.getName());
            JasmineSingleResult val = new JasmineSingleResult();
            String name = this.indicator.getName();
            if (current.getValues().size() > 1) {
                name = name + "(" + res.getName() + ")";
            }
            val.setName(name);
            val.setTimestamp(curtime);
            Number value = null;
            switch (this.ope) {
                case 1: {
                    value = old.getValue();
                    if (this.indicator.getScale() != 1) {
                        value = this.divideValues(value, this.indicator.getScale());
                    }
                    val.setValue(value);
                    break;
                }
                case 2: {
                    value = this.diffValues(res.getValue(), old.getValue());
                    if (this.indicator.getScale() != 1) {
                        value = this.divideValues(value, this.indicator.getScale());
                    }
                    val.setValue(value);
                    break;
                }
                case 3: {
                    long diff = this.diffValues(res.getValue(), old.getValue()) * 1000L / timeslice;
                    if (this.indicator.getScale() != 1) {
                        diff /= (long)this.indicator.getScale();
                    }
                    val.setValue((Number)diff);
                    break;
                }
                default: {
                    throw new JasmineCollectorException("Unimplemented derived operation " + this.ope);
                }
            }
            jiv.addValue(val);
        }
        this.previous = current;
        return jiv;
    }

    public void stopPolling() {
        this.logger.debug((Object)"", new Object[0]);
        this.previous = null;
    }
}

