/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JasmineProbe {
    private String id;
    private List<String> outputList = new ArrayList<String>();
    private List<String> indicatorList = new ArrayList<String>();
    private List<String> targetList = new ArrayList<String>();
    private int status;
    public static final int PROBE_STOPPED = 0;
    public static final int PROBE_STARTED = 1;
    public static final int PROBE_RUNNING = 2;
    public static final int PROBE_FAILED = 3;
    public static final int PROBE_TOSTART = 4;
    private String error;
    private int period = 10;

    public String printStatus() {
        String statusString = null;
        switch (this.status) {
            case 0: {
                statusString = "STOPPED";
                break;
            }
            case 1: {
                statusString = "STARTED";
                break;
            }
            case 2: {
                statusString = "RUNNING";
                break;
            }
            case 3: {
                statusString = "FAILED";
                break;
            }
            case 4: {
                statusString = "TOSTART";
                break;
            }
            default: {
                statusString = "Invalid status";
            }
        }
        return statusString;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String mess) {
        this.error = mess;
    }

    public List<String> getOutputList() {
        return this.outputList;
    }

    public void setOutputList(List<String> outputList) {
        this.outputList = outputList;
    }

    public List<String> getIndicatorList() {
        return this.indicatorList;
    }

    public void setIndicatorList(List<String> indicatorList) {
        this.indicatorList = indicatorList;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public List<String> getTargetList() {
        return this.targetList;
    }

    public void setTargetList(List<String> targetList) {
        this.targetList = targetList;
    }

    public String toString() {
        String probeString = "JasmineProbe " + this.id;
        String targets = null;
        if (this.targetList != null && !this.targetList.isEmpty()) {
            targets = "\n> targets: ";
            for (String target : this.targetList) {
                targets = targets + target + " ";
            }
            probeString = probeString + targets;
        }
        String indicators = null;
        if (this.indicatorList != null && !this.indicatorList.isEmpty()) {
            indicators = "\n> indicators : ";
            for (String indicator : this.indicatorList) {
                indicators = indicators + indicator + " ";
            }
            probeString = probeString + indicators;
        }
        String outputs = null;
        if (this.outputList != null && !this.outputList.isEmpty()) {
            outputs = "\n> outputs : ";
            for (String output : this.outputList) {
                outputs = outputs + output + " ";
            }
            probeString = probeString + outputs;
        }
        String periods = "\n> period: " + Integer.toString(this.period);
        probeString = probeString + periods;
        String status = "\n> status: " + this.printStatus();
        probeString = probeString + status;
        return probeString;
    }
}

