/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.jmx.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.ow2.jasmine.probe.collectors.jmx.internal.FragmentNameException;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxCollector;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentUtil {
    private static Log logger = LogFactory.getLog(JmxCollector.class);
    public static String DOT = ".";
    public static String COMMA = ",";
    public static String BRACKLEFT = "[";
    public static String BRACKRIGHT = "]";

    public static List<Attribute> getFragments(Attribute att) {
        String name = att.getName();
        logger.debug((Object)name, new Object[0]);
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        Object value = att.getValue();
        if (value instanceof Number || value instanceof String || value instanceof Boolean) {
            result.add(att);
            logger.debug((Object)("Return final fragment with name: " + name + " and value: " + value), new Object[0]);
            return result;
        }
        if (value instanceof CompositeData) {
            CompositeData compValue = (CompositeData)value;
            Set<String> keys = compValue.getCompositeType().keySet();
            for (String key : keys) {
                Attribute itemAtt = FragmentUtil.getCompositeItemAttribute(name, key, compValue);
                List<Attribute> frags = FragmentUtil.getFragments(itemAtt);
                result.addAll(frags);
            }
            return result;
        }
        if (value instanceof TabularData) {
            TabularData tabData = (TabularData)value;
            Collection<?> values = tabData.values();
            for (Object tabValue : values) {
                CompositeData compValue = (CompositeData)tabValue;
                Object[] indexes = tabData.calculateIndex(compValue);
                Attribute tabAtt = FragmentUtil.getTabularDataAttribute(name, indexes, compValue);
                List<Attribute> frags = FragmentUtil.getFragments(tabAtt);
                result.addAll(frags);
            }
            return result;
        }
        if (value.getClass().isArray()) {
            try {
                Array attval = (Array)value;
                for (int i = 0; i < Array.getLength(attval); ++i) {
                    Attribute elemAtt = FragmentUtil.getArrayElementAttribute(name, i, attval);
                    List<Attribute> frags = FragmentUtil.getFragments(elemAtt);
                    result.addAll(frags);
                }
                return result;
            }
            catch (ClassCastException cc) {
                String[] attval = (String[])value;
                for (int i = 0; i < attval.length; ++i) {
                    String elem = attval[i];
                    String elemName = FragmentUtil.getNameForArrayElement(name, new Integer(i).toString());
                    Attribute elemAtt = new Attribute(elemName, elem);
                    List<Attribute> frags = FragmentUtil.getFragments(elemAtt);
                    result.addAll(frags);
                }
                return result;
            }
        }
        if (value instanceof Map) {
            Map attval = (Map)att.getValue();
            Set keys = attval.keySet();
            for (Object key : keys) {
                Attribute elemAtt = FragmentUtil.getMapElementAttribute(name, key, attval);
                List<Attribute> frags = FragmentUtil.getFragments(elemAtt);
                result.addAll(frags);
            }
            return result;
        }
        logger.debug((Object)"No attribute returned, the type is not supported: {0}", new Object[]{value.getClass().getName()});
        return result;
    }

    private static Attribute getArrayElementAttribute(String name, int index, Array attval) {
        Object elem = Array.get(attval, index);
        String elemName = FragmentUtil.getNameForArrayElement(name, new Integer(index).toString());
        return new Attribute(elemName, elem);
    }

    private static Attribute getMapElementAttribute(String name, Object key, Map<?, ?> attval) {
        Object item = attval.get(key);
        String itemName = FragmentUtil.getNameForItem(name, key.toString());
        return new Attribute(itemName, item);
    }

    private static Attribute getCompositeItemAttribute(String name, String key, CompositeData compValue) {
        Object item = compValue.get(key);
        String itemName = FragmentUtil.getNameForItem(name, key);
        return new Attribute(itemName, item);
    }

    private static Attribute getTabularDataAttribute(String name, Object[] indexes, CompositeData row) {
        String rowName = FragmentUtil.getNameForTabularElement(name, indexes);
        return new Attribute(rowName, row);
    }

    public static boolean isFragmentName(String name) {
        if (name.contains(DOT)) {
            return true;
        }
        return name.contains(BRACKLEFT) && name.contains(BRACKLEFT) && name.indexOf(BRACKLEFT) < name.indexOf(BRACKRIGHT);
    }

    public static String getNameForItem(String name, String key) {
        String itemName = name + DOT + key;
        return itemName;
    }

    public static String getNameForArrayElement(String name, String index) {
        String elemName = name + BRACKLEFT + index + BRACKRIGHT;
        return elemName;
    }

    public static String getNameForTabularElement(String name, Object[] indexes) {
        String s_indexes = indexes[0].toString();
        if (indexes.length > 1) {
            for (int i = 1; i < indexes.length; ++i) {
                s_indexes = s_indexes + COMMA + indexes[i];
            }
        }
        String elemName = name + BRACKLEFT + s_indexes + BRACKRIGHT;
        return elemName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getAttributeName(String name) throws FragmentNameException {
        int index;
        int dotIndex = name.indexOf(DOT);
        int brackLeftIndex = name.indexOf(BRACKLEFT);
        if (dotIndex > 0) {
            if (brackLeftIndex > 0) {
                if (dotIndex < brackLeftIndex) {
                    index = dotIndex;
                    return name.substring(0, index);
                } else {
                    if (name.indexOf(BRACKRIGHT) <= 0 || name.indexOf(BRACKRIGHT) <= brackLeftIndex) throw new FragmentNameException("Can't get attribute name from: " + name);
                    index = brackLeftIndex;
                }
                return name.substring(0, index);
            } else {
                index = dotIndex;
            }
            return name.substring(0, index);
        } else {
            if (brackLeftIndex <= 0) throw new FragmentNameException("Can't get attribute name from: " + name);
            if (name.indexOf(BRACKRIGHT) <= 0 || name.indexOf(BRACKRIGHT) <= brackLeftIndex) throw new FragmentNameException("Can't get attribute name from: " + name);
            index = brackLeftIndex;
        }
        return name.substring(0, index);
    }

    public static String getItemName(String fragmentName) throws FragmentNameException {
        int dotIndex = fragmentName.indexOf(DOT);
        if (dotIndex > 0) {
            return fragmentName.substring(dotIndex + 1);
        }
        throw new FragmentNameException("Can't get item name from: " + fragmentName);
    }

    public static String getElementName(String fragmentName) throws FragmentNameException {
        int brackLeftIndex = fragmentName.indexOf(BRACKLEFT);
        int brackRightIndex = fragmentName.indexOf(BRACKRIGHT);
        if (brackLeftIndex > 0 && brackRightIndex > 0 && brackLeftIndex < brackRightIndex) {
            return fragmentName;
        }
        throw new FragmentNameException("Can't get element name from: " + fragmentName);
    }
}

