/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.jmx.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.annotations.Validate;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.JasmineTarget;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collector.JasmineCollectorService;
import org.ow2.jasmine.probe.collectors.JCollector;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxCollector;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxWorker;
import org.ow2.jasmine.probe.jmx.JmxBrowserService;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionService;
import org.ow2.jasmine.probe.probemanager.ProbeManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="JmxCollectorService")
@Provides
public class JmxCollectorService
implements JasmineCollectorService,
JmxBrowserService,
Pojo {
    private InstanceManager __IM;
    private boolean __Flogger;
    protected Log logger;
    private boolean __FcollectorList;
    private HashMap<String, JmxCollector> collectorList;
    private boolean __FworkerList;
    private HashMap<String, JmxWorker> workerList;
    private boolean __Fproperties;
    private Collection<JasminePropertyInfo> properties;
    public static final String PROP_TARGET = "target";
    public static final String PROP_MBEAN = "mbean";
    public static final String PROP_ATTR = "attr";
    public static final String VALUE_ALL = "all";
    private boolean __FindicatorType;
    @ServiceProperty(name="indicator.type", value="jmx")
    private String indicatorType;
    private boolean __FjmxConnectionService;
    @Requires
    private JmxConnectionService jmxConnectionService;
    private boolean __FprobeManager;
    @Requires
    ProbeManager probeManager;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MgetCollector$org_ow2_jasmine_probe_JasmineIndicator$int$java_lang_String;
    private boolean __MgetPropertiesInfo;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    HashMap __getcollectorList() {
        if (!this.__FcollectorList) {
            return this.collectorList;
        }
        return (HashMap)this.__IM.onGet((Object)this, "collectorList");
    }

    void __setcollectorList(HashMap hashMap) {
        if (!this.__FcollectorList) {
            this.collectorList = hashMap;
            return;
        }
        this.__IM.onSet((Object)this, "collectorList", (Object)hashMap);
    }

    HashMap __getworkerList() {
        if (!this.__FworkerList) {
            return this.workerList;
        }
        return (HashMap)this.__IM.onGet((Object)this, "workerList");
    }

    void __setworkerList(HashMap hashMap) {
        if (!this.__FworkerList) {
            this.workerList = hashMap;
            return;
        }
        this.__IM.onSet((Object)this, "workerList", (Object)hashMap);
    }

    Collection __getproperties() {
        if (!this.__Fproperties) {
            return this.properties;
        }
        return (Collection)this.__IM.onGet((Object)this, "properties");
    }

    void __setproperties(Collection collection) {
        if (!this.__Fproperties) {
            this.properties = collection;
            return;
        }
        this.__IM.onSet((Object)this, "properties", (Object)collection);
    }

    String __getindicatorType() {
        if (!this.__FindicatorType) {
            return this.indicatorType;
        }
        return (String)this.__IM.onGet((Object)this, "indicatorType");
    }

    void __setindicatorType(String string) {
        if (!this.__FindicatorType) {
            this.indicatorType = string;
            return;
        }
        this.__IM.onSet((Object)this, "indicatorType", (Object)string);
    }

    JmxConnectionService __getjmxConnectionService() {
        if (!this.__FjmxConnectionService) {
            return this.jmxConnectionService;
        }
        return (JmxConnectionService)this.__IM.onGet((Object)this, "jmxConnectionService");
    }

    void __setjmxConnectionService(JmxConnectionService jmxConnectionService) {
        if (!this.__FjmxConnectionService) {
            this.jmxConnectionService = jmxConnectionService;
            return;
        }
        this.__IM.onSet((Object)this, "jmxConnectionService", (Object)jmxConnectionService);
    }

    ProbeManager __getprobeManager() {
        if (!this.__FprobeManager) {
            return this.probeManager;
        }
        return (ProbeManager)this.__IM.onGet((Object)this, "probeManager");
    }

    void __setprobeManager(ProbeManager probeManager) {
        if (!this.__FprobeManager) {
            this.probeManager = probeManager;
            return;
        }
        this.__IM.onSet((Object)this, "probeManager", (Object)probeManager);
    }

    public JmxCollectorService() {
        this(null);
    }

    private JmxCollectorService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(JCollector.class));
        this.__setcollectorList(new HashMap());
        this.__setworkerList(new HashMap());
        this.__setjmxConnectionService(null);
        this.__setprobeManager(null);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __start() {
        this.__setproperties(new ArrayList());
        this.__getproperties().add(new JasminePropertyInfo(PROP_TARGET, "Jmx target name", true));
        this.__getproperties().add(new JasminePropertyInfo(PROP_MBEAN, "MBean Jmx filter", true));
        this.__getproperties().add(new JasminePropertyInfo(PROP_ATTR, "Comma separated list of attributes", false));
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __stop() {
    }

    public synchronized JasmineCollector getCollector(JasmineIndicator jasmineIndicator, int n, String string) throws JasmineCollectorException {
        JasmineCollector jasmineCollector;
        if (!this.__MgetCollector$org_ow2_jasmine_probe_JasmineIndicator$int$java_lang_String) {
            return this.__getCollector(jasmineIndicator, n, string);
        }
        try {
            this.__IM.onEntry((Object)this, "getCollector$org_ow2_jasmine_probe_JasmineIndicator$int$java_lang_String", new Object[]{jasmineIndicator, new Integer(n), string});
            jasmineCollector = this.__getCollector(jasmineIndicator, n, string);
            this.__IM.onExit((Object)this, "getCollector$org_ow2_jasmine_probe_JasmineIndicator$int$java_lang_String", (Object)jasmineCollector);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCollector$org_ow2_jasmine_probe_JasmineIndicator$int$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineCollector;
    }

    private JasmineCollector __getCollector(JasmineIndicator indicator, int period, String probeid) throws JasmineCollectorException {
        String key = indicator.getName() + probeid;
        JmxCollector collector = (JmxCollector)((Object)this.__getcollectorList().get(key));
        if (collector == null) {
            if (!indicator.getType().equals(this.__getindicatorType())) {
                this.__getlogger().error((Object)("Bad type: " + indicator.getType()), new Object[0]);
                throw new JasmineCollectorException("Bad type: " + indicator.getType());
            }
            Map props = indicator.getProperties();
            String target = (String)props.get(PROP_TARGET);
            String mbean = (String)props.get(PROP_MBEAN);
            String attr = (String)props.get(PROP_ATTR);
            JasmineTarget jt = this.__getprobeManager().getTarget(target);
            if (jt == null) {
                this.__getlogger().error((Object)("Unknown target: " + target), new Object[0]);
                throw new JasmineCollectorException("Unknown target: " + target);
            }
            collector = new JmxCollector(key, indicator, period, mbean, attr);
            this.__getcollectorList().put(key, collector);
            JmxWorker worker = (JmxWorker)this.__getworkerList().get(target);
            if (worker == null) {
                worker = new JmxWorker(jt, this.__getjmxConnectionService());
                this.__getworkerList().put(target, worker);
            }
            worker.addCollector(collector);
        }
        return collector;
    }

    public Collection<JasminePropertyInfo> getPropertiesInfo() {
        Collection<JasminePropertyInfo> collection;
        if (!this.__MgetPropertiesInfo) {
            return this.__getPropertiesInfo();
        }
        try {
            this.__IM.onEntry((Object)this, "getPropertiesInfo", new Object[0]);
            collection = this.__getPropertiesInfo();
            this.__IM.onExit((Object)this, "getPropertiesInfo", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPropertiesInfo", throwable);
            throw throwable;
        }
        return collection;
    }

    private Collection<JasminePropertyInfo> __getPropertiesInfo() {
        return this.__getproperties();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("collectorList")) {
                this.__FcollectorList = true;
            }
            if (set.contains("probeManager")) {
                this.__FprobeManager = true;
            }
            if (set.contains("indicatorType")) {
                this.__FindicatorType = true;
            }
            if (set.contains("workerList")) {
                this.__FworkerList = true;
            }
            if (set.contains("jmxConnectionService")) {
                this.__FjmxConnectionService = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("properties")) {
                this.__Fproperties = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("getCollector$org_ow2_jasmine_probe_JasmineIndicator$int$java_lang_String")) {
                this.__MgetCollector$org_ow2_jasmine_probe_JasmineIndicator$int$java_lang_String = true;
            }
            if (set.contains("getPropertiesInfo")) {
                this.__MgetPropertiesInfo = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

