/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.jmx.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.ow2.jasmine.probe.JasmineTarget;
import org.ow2.jasmine.probe.collectors.JCollector;
import org.ow2.jasmine.probe.collectors.jmx.Metric;
import org.ow2.jasmine.probe.collectors.jmx.internal.FragmentNameException;
import org.ow2.jasmine.probe.collectors.jmx.internal.FragmentUtil;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxCollector;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxUtil;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionException;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionFactory;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxWorker
extends Thread {
    private Log logger = LogFactory.getLog(JCollector.class);
    private boolean started = false;
    private String targetName;
    private String url;
    private long collectorTimeout = 1000L;
    private static final long DEFAULT_TIMEOUT = 1000L;
    private Collection<JmxCollector> collectors = new ArrayList<JmxCollector>();
    private JmxConnectionService jmxService;
    private Map<String, String> props = new HashMap<String, String>();
    private JmxConnectionFactory cfactory = null;
    private String serverName = null;
    private String domainName = null;

    public JmxWorker(JasmineTarget target, JmxConnectionService jmxConnectionService) {
        this.logger.debug((Object)target.getName(), new Object[0]);
        this.targetName = target.getName();
        this.url = target.getUrl();
        this.props = target.getProperties();
        this.jmxService = jmxConnectionService;
    }

    public synchronized void remove() {
        this.started = false;
    }

    public synchronized void addCollector(JmxCollector col) {
        this.collectors.add(col);
        if (!this.started) {
            this.started = true;
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.started) {
            ArrayList<JmxCollector> topoll = new ArrayList<JmxCollector>();
            JmxWorker jmxWorker = this;
            synchronized (jmxWorker) {
                for (JmxCollector coll : this.collectors) {
                    if (!coll.needResult()) continue;
                    topoll.add(coll);
                }
            }
            if (!topoll.isEmpty()) {
                long t = System.currentTimeMillis();
                MBeanServerConnection cnx = null;
                try {
                    cnx = this.getMBeanServerConnection();
                }
                catch (JmxConnectionException e) {
                    this.logger.warn((Object)("Cannot get Jmx Access:" + (Object)((Object)e)), new Object[0]);
                }
                if (cnx != null) {
                    if (this.serverName == null || this.domainName == null) {
                        this.setServerAndDomain(cnx);
                    }
                    for (JmxCollector coll : topoll) {
                        List<Metric> metrics = this.collect(cnx, coll);
                        coll.addResult(metrics);
                    }
                }
            }
            jmxWorker = this;
            synchronized (jmxWorker) {
                try {
                    this.wait(this.collectorTimeout);
                }
                catch (InterruptedException e) {
                    this.logger.warn((Object)(this.getName() + ": collector interrupted"), new Object[]{e});
                }
                catch (Exception e) {
                    this.logger.warn((Object)(this.getName() + ": collector exception"), new Object[]{e});
                }
            }
        }
    }

    private MBeanServerConnection getMBeanServerConnection() throws JmxConnectionException {
        if (this.cfactory == null) {
            this.cfactory = this.jmxService.getJmxConnectionFactory(this.url, this.props);
        }
        return this.cfactory.getMBeanServerConnection();
    }

    private void setServerAndDomain(MBeanServerConnection cnx) {
        try {
            ObjectName j2eeinstance = ObjectName.getInstance("*:j2eeType=J2EEServer,*");
            Iterator<ObjectName> onames = cnx.queryNames(j2eeinstance, null).iterator();
            ObjectName serverOn = onames.next();
            this.serverName = (String)cnx.getAttribute(serverOn, "serverName");
            this.domainName = serverOn.getDomain();
        }
        catch (Exception e) {
            this.logger.warn((Object)"Cannot get server and domain names for target ", new Object[]{this.targetName});
        }
    }

    private List<Metric> collect(MBeanServerConnection cnx, JmxCollector col) {
        LinkedList<Metric> metrics = new LinkedList<Metric>();
        try {
            ObjectName objname = col.getObjectName();
            if (objname.isPattern()) {
                this.logger.debug((Object)("pattern:" + objname.toString()), new Object[0]);
                Set<ObjectName> onset = JmxUtil.getMBeans(cnx, objname);
                for (ObjectName mbean : onset) {
                    Metric m = this.getMBeanMetric(cnx, mbean, col);
                    if (m == null) continue;
                    metrics.add(m);
                }
            } else {
                this.logger.debug((Object)("single mbean:" + objname.toString()), new Object[0]);
                Metric m = this.getMBeanMetric(cnx, objname, col);
                if (m != null) {
                    metrics.add(m);
                }
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("getAttributes error on JmxServer: " + e), new Object[0]);
        }
        this.logger.debug((Object)("nb of metrics found: " + metrics.size()), new Object[0]);
        return metrics;
    }

    private Metric getMBeanMetric(MBeanServerConnection cnx, ObjectName objname, JmxCollector col) throws IOException, JMException {
        this.logger.debug((Object)("mbean:" + objname.toString()), new Object[0]);
        if (!cnx.isRegistered(objname)) {
            this.logger.error((Object)"Cannot get attributes in MBean {0}", new Object[]{objname});
        }
        Metric metric = null;
        AttributeList attl = null;
        long time = System.currentTimeMillis();
        if (col.hasAttributes()) {
            attl = new AttributeList();
            for (String name : col.geAttrlist()) {
                Attribute att = null;
                if (FragmentUtil.isFragmentName(name)) {
                    try {
                        att = JmxUtil.getAttributeFragment(cnx, objname, name);
                    }
                    catch (FragmentNameException e) {
                        this.logger.error((Object)"Cannot get value for {0} in MBean {1}", new Object[]{name, objname});
                    }
                } else {
                    try {
                        AttributeList atts = cnx.getAttributes(objname, new String[]{name});
                        if (atts.isEmpty()) {
                            this.logger.error((Object)"Cannot get value for {0} in MBean {1} (there is no attribute having this name)", new Object[0]);
                        } else {
                            att = (Attribute)atts.get(0);
                        }
                    }
                    catch (InstanceNotFoundException ae) {
                        this.logger.error((Object)"Cannot get value for {0} in MBean {1} (there is no such MBean)", new Object[0]);
                    }
                }
                if (att == null) continue;
                attl.add(att);
            }
        } else {
            List<String> attNameList = JmxUtil.getMBeanAttNames(cnx, objname);
            String[] attNames = new String[attNameList.size()];
            int i = 0;
            for (String attName : attNameList) {
                attNames[i++] = attName;
            }
            attl = cnx.getAttributes(objname, attNames);
        }
        if (attl.isEmpty()) {
            this.logger.warn((Object)("No metrics found for indicator: " + col.getIndicator().getName() + ", for mbean: " + objname.toString() + ", and target: " + this.targetName), new Object[0]);
        } else {
            metric = new Metric(time, objname, attl, this.targetName);
            metric.setProperty("server", this.serverName);
            metric.setProperty("domain", this.domainName);
            metric.setProperty("url", this.url);
        }
        return metric;
    }
}

