/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.tck.TestCaseWatchdogTimeoutHandler;

public class TestCaseWatchdog
extends Thread {
    protected static final AtomicInteger threadNumber = new AtomicInteger(0);
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final long delay;
    protected final TimeUnit unit;
    protected final TestCaseWatchdogTimeoutHandler handler;

    public TestCaseWatchdog(long delay, TimeUnit unit, TestCaseWatchdogTimeoutHandler timeoutHandler) {
        super("WatchdogThread-" + threadNumber.getAndIncrement());
        this.setDaemon(true);
        this.delay = delay;
        this.unit = unit;
        this.handler = timeoutHandler;
    }

    public void run() {
        block3: {
            long millisToWait = this.unit.toMillis(this.delay);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Starting with " + millisToWait + "ms timeout.");
            }
            try {
                Thread.sleep(millisToWait);
                this.handler.handleTimeout(this.delay, this.unit);
            }
            catch (InterruptedException interrupted) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug("Watchdog stopped.");
            }
        }
    }

    public void cancel() {
        this.interrupt();
    }
}

