/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class I18n {
    private static final String RESOURCE_BUNDLE_NAME = "I18n";
    private static Map<String, I18n> bundles = null;
    private ResourceBundle resourceBundle = null;

    private I18n(String packageName, ClassLoader cl) {
        String bundleName = packageName + "." + RESOURCE_BUNDLE_NAME;
        try {
            Locale locale = Locale.getDefault();
            this.resourceBundle = ResourceBundle.getBundle(bundleName, locale, cl);
        }
        catch (MissingResourceException mre) {
            String err = "Error when trying to get a ResourceBundle for package '" + packageName + "' : " + mre.getMessage();
            throw new IllegalStateException(err);
        }
    }

    public static I18n getInstance(Class<?> c) {
        return I18n.getInstance(c.getPackage().getName(), c.getClassLoader());
    }

    public static I18n getInstance(Class<?> c, ClassLoader cl) {
        return I18n.getInstance(c.getPackage().getName(), cl);
    }

    public static I18n getInstance(String packageName) {
        return I18n.getInstance(packageName, Thread.currentThread().getContextClassLoader());
    }

    public static I18n getInstance(String packageName, ClassLoader cl) {
        I18n i18n;
        if (bundles == null) {
            bundles = new HashMap<String, I18n>();
        }
        if ((i18n = bundles.get(packageName)) != null) {
            return i18n;
        }
        i18n = new I18n(packageName, cl);
        bundles.put(packageName, i18n);
        return i18n;
    }

    public String getMessage(String key, Object[] args) {
        String value = this.getMessage(key);
        return MessageFormat.format(value, args);
    }

    public String getMessage(String key) {
        String ret = null;
        if (this.resourceBundle == null) {
            return key;
        }
        try {
            ret = this.resourceBundle.getString(key);
        }
        catch (MissingResourceException mre) {
            ret = key;
        }
        return ret;
    }

    public String getMessage(String key, Object obj) {
        return this.getMessage(key, new Object[]{obj});
    }

    public String getMessage(String key, Object obj1, Object obj2) {
        return this.getMessage(key, new Object[]{obj1, obj2});
    }

    public String getMessage(String key, Object obj1, Object obj2, Object obj3) {
        return this.getMessage(key, new Object[]{obj1, obj2, obj3});
    }

    public String getMessage(String key, Object obj1, Object obj2, Object obj3, Object obj4) {
        return this.getMessage(key, new Object[]{obj1, obj2, obj3, obj4});
    }

    public String getMessage(String key, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5) {
        return this.getMessage(key, new Object[]{obj1, obj2, obj3, obj4, obj5});
    }

    public String getMessage(String key, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6) {
        return this.getMessage(key, new Object[]{obj1, obj2, obj3, obj4, obj5, obj6});
    }
}

