/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.auditreport.impl;

import java.io.Serializable;
import java.util.UUID;
import org.ow2.util.auditreport.api.IAuditID;

public class AuditIDImpl
implements IAuditID,
Serializable {
    private static final long serialVersionUID = 3855603875318289890L;
    private String parentID = "";
    private long localCount = 0L;
    private String id = "";

    public AuditIDImpl() {
    }

    public AuditIDImpl(String auditId) {
        this();
        String[] ids = auditId.split(":");
        this.parentID = ids[0];
        String localID = ids[1];
        String[] clientID = localID.split("/");
        this.id = clientID[0];
        this.localCount = Integer.valueOf(clientID[1]).longValue();
    }

    public String getParentID() {
        return this.parentID;
    }

    public String getID() {
        return this.getParentID() + ":" + this.getLocalID();
    }

    public String getLocalID() {
        return this.id + "/" + this.localCount;
    }

    public void increment() {
        ++this.localCount;
    }

    public void generate() {
        this.id = UUID.randomUUID().toString();
    }

    public void setParentID(String parentID) {
        this.parentID = parentID;
    }
}

