/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.facility.naming.rdbsequence;

import org.objectweb.jorm.api.PBindingCtrl;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PExceptionProtocol;
import org.objectweb.jorm.api.PStateGraph;
import org.objectweb.jorm.facility.naming.rdbsequence.RdbSequenceHelper;
import org.objectweb.jorm.facility.naming.rdbsequence.RdbSequencePName;
import org.objectweb.jorm.facility.naming.rdbsequence.SequenceIdAllocator;
import org.objectweb.jorm.mapper.rdb.lib.PMapperRdb;
import org.objectweb.jorm.naming.api.NamingFilterKeyProvider;
import org.objectweb.jorm.naming.api.PExceptionExistingName;
import org.objectweb.jorm.naming.api.PExceptionNaming;
import org.objectweb.jorm.naming.api.PName;
import org.objectweb.jorm.naming.api.PNameManager;
import org.objectweb.jorm.naming.lib.BasicPBinder;
import org.objectweb.perseus.cache.api.CacheEntry;
import org.objectweb.perseus.cache.api.CacheException;
import org.objectweb.perseus.cache.api.CacheManager;
import org.objectweb.perseus.persistence.api.ConnectionHolder;
import org.objectweb.perseus.persistence.api.PersistenceException;

public class RdbSequenceBinder
extends BasicPBinder {
    private RdbSequenceHelper sequenceHelper;
    private SequenceIdAllocator allocator;
    private Object key;

    public RdbSequenceBinder() {
        this.nullPName = new RdbSequencePName((PNameManager)this, RdbSequencePName.NULL_VALUE);
        this.sequenceHelper = new RdbSequenceHelper();
    }

    public void setSequenceIdAllocator(SequenceIdAllocator sia) {
        this.allocator = sia;
    }

    public SequenceIdAllocator getSequenceIdAllocator() {
        return this.allocator;
    }

    public RdbSequenceHelper getSequenceHelper() {
        return this.sequenceHelper;
    }

    public void setSequenceHelper(RdbSequenceHelper sequenceHelper) {
        this.sequenceHelper = sequenceHelper;
    }

    protected void initSequenceHelper() {
        if (this.sequenceHelper.getAdapter() != null) {
            return;
        }
        PClassMapping pcm = this.getBinderClassMapping();
        if (pcm == null) {
            throw new IllegalStateException("No PClassMapping bound to the PBinder");
        }
        PMapperRdb mapper = (PMapperRdb)pcm.getPMapper();
        if (mapper == null) {
            throw new IllegalStateException("No PMapper bound to the PClassMapping of the class " + pcm.getClassName());
        }
        if (pcm instanceof NamingFilterKeyProvider) {
            this.key = ((NamingFilterKeyProvider)((Object)pcm)).getNamingFilterKey();
        }
        this.sequenceHelper.setAdapter(mapper.getRdbAdapter());
    }

    public PName resolve(Object conn, PName pn) throws PException {
        if (pn == null) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this pname is null");
        }
        if (!pn.getPNameManager().equals(this)) {
            throw new PExceptionNaming("[" + this.getClassName() + "]: this pname is not valid in this binder");
        }
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PName export(Object conn, Object infoitem, Object hints) throws PException {
        if (hints instanceof RdbSequencePName) {
            PBindingCtrl pb = (PBindingCtrl)infoitem;
            byte nextstate = PStateGraph.nextStatePBinding(pb.getStatus(), (byte)3);
            if (nextstate == 5) {
                throw new PExceptionProtocol("Unauthorized operation");
            }
            RdbSequencePName pn = new RdbSequencePName((PNameManager)this, ((RdbSequencePName)hints).value);
            if (this.cache != null) {
                CacheManager cacheManager = this.cache;
                synchronized (cacheManager) {
                    if (this.cache.lookup(pn) != null) {
                        throw new PExceptionExistingName("[" + this.getClassName() + "]: an object has been already export with the same identifier");
                    }
                    try {
                        this.cache.fix(this.cache.bind(pn, pb));
                    }
                    catch (CacheException e) {
                        throw new PException(e, "[" + this.getClassName() + "]: problem with cache management");
                    }
                }
            }
            pb.setPName(pn);
            pb.setStatus(nextstate);
            return pn;
        }
        if (this.sequenceHelper.getSequenceName() == null && hints instanceof String) {
            this.sequenceHelper.setSequenceName((String)hints);
        }
        return this.export(conn, infoitem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PName export(Object c, Object en) throws PException {
        RdbSequencePName pn;
        byte nextstate;
        PBindingCtrl pb;
        block24: {
            block23: {
                if (en == null) {
                    throw new PExceptionNaming("[" + this.getClassName() + "]: cannot export null!");
                }
                if (en instanceof PName) {
                    if (((PName)en).getPNameManager() == this) {
                        return (PName)en;
                    }
                    return new RdbSequencePName((PNameManager)this, en);
                }
                pb = (PBindingCtrl)en;
                nextstate = PStateGraph.nextStatePBinding(pb.getStatus(), (byte)3);
                if (nextstate == 5) {
                    throw new PExceptionProtocol("Unauthorized operation");
                }
                pn = null;
                boolean connectionAllocatedLocaly = false;
                try {
                    if (c == null) {
                        c = this.getBinderClassMapping().getPMapper().getConnection();
                        connectionAllocatedLocaly = true;
                    }
                    this.initSequenceHelper();
                    if (!this.sequenceHelper.isSequenceCreated()) {
                        this.sequenceHelper.createSequence(c);
                    }
                    long lid = this.sequenceHelper.allocateId(c);
                    if (this.allocator != null) {
                        lid = this.allocator.allocateId(lid, this.key);
                    }
                    pn = new RdbSequencePName((PNameManager)this, new Long(lid));
                    Object var10_9 = null;
                    if (!connectionAllocatedLocaly) break block23;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (connectionAllocatedLocaly) {
                        this.getBinderClassMapping().getPMapper().closeConnection(c);
                    } else if (c instanceof ConnectionHolder) {
                        try {
                            ((ConnectionHolder)c).releaseCHConnection();
                        }
                        catch (PersistenceException e) {
                            throw new PException(e, "Problem with Perseus connection releasing.");
                        }
                    }
                    throw throwable;
                }
                this.getBinderClassMapping().getPMapper().closeConnection(c);
                break block24;
            }
            if (c instanceof ConnectionHolder) {
                try {
                    ((ConnectionHolder)c).releaseCHConnection();
                }
                catch (PersistenceException e) {
                    throw new PException(e, "Problem with Perseus connection releasing.");
                }
            }
        }
        if (this.cache != null) {
            CacheManager cacheManager = this.cache;
            synchronized (cacheManager) {
                if (this.cache.lookup(pn) != null) {
                    throw new PExceptionExistingName("[" + this.getClassName() + "]: an object has been already export with the same identifier");
                }
                try {
                    this.cache.fix(this.cache.bind(pn, pb));
                }
                catch (CacheException e) {
                    throw new PException(e, "[" + this.getClassName() + "]: problem with cache management");
                }
            }
        }
        pb.setPName(pn);
        pb.setStatus(nextstate);
        return pn;
    }

    public void unexport(Object conn, PName pn) throws PException {
        byte nextstate;
        PBindingCtrl pb;
        if (pn.isNull()) {
            throw new PExceptionProtocol("[" + this.getClassName() + "]: cannot unexport with a null pname.");
        }
        if (this.cache != null) {
            pb = null;
            CacheEntry ce = this.cache.lookup(pn);
            if (ce != null) {
                pb = (PBindingCtrl)ce.getCeObject();
            }
            if (pb == null) {
                throw new PExceptionProtocol("Unauthorized operation: No Pbinding found");
            }
            nextstate = PStateGraph.nextStatePBinding(pb.getStatus(), (byte)4);
            if (nextstate == 5) {
                throw new PExceptionProtocol("Unauthorized operation: status =" + pb.getStatus());
            }
        } else {
            throw new PExceptionProtocol("Unauthorized operation: No Pbinding can be found without a CacheManager");
        }
        pb.setStatus(nextstate);
    }

    public void unexport(Object conn, PName pn, Object hints) throws PException {
        CacheEntry ce;
        if (pn.isNull()) {
            throw new PExceptionProtocol("[" + this.getClassName() + "]: cannot unexport with a null pname.");
        }
        PBindingCtrl pb = null;
        if (hints instanceof PBindingCtrl) {
            pb = (PBindingCtrl)hints;
        } else if (this.cache != null && (ce = this.cache.lookup(pn)) != null) {
            pb = (PBindingCtrl)ce.getCeObject();
        }
        if (pb == null) {
            throw new PExceptionProtocol("Unauthorized operation: No Pbinding found");
        }
        byte nextstate = PStateGraph.nextStatePBinding(pb.getStatus(), (byte)4);
        if (nextstate == 5) {
            throw new PExceptionProtocol("Unauthorized operation: status =" + pb.getStatus());
        }
        pb.setStatus(nextstate);
    }

    public long encodeLong(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        Long val = ((RdbSequencePName)pn).value;
        return val == null ? -1L : val;
    }

    public Long encodeOlong(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        return ((RdbSequencePName)pn).value;
    }

    public PName decodeLong(long en) throws PExceptionNaming, UnsupportedOperationException {
        return this.decodeOlong(new Long(en));
    }

    public PName decodeOlong(Long en) throws PExceptionNaming, UnsupportedOperationException {
        if (en == RdbSequencePName.NULL_VALUE || en != null && en < 0L) {
            return this.nullPName;
        }
        return new RdbSequencePName((PNameManager)this, en);
    }

    public PName decodeString(String en) throws PExceptionNaming {
        Long val = en == null || en.equals("null") ? null : new Long(Long.parseLong(en));
        try {
            return this.decodeOlong(val);
        }
        catch (NumberFormatException e) {
            throw new PExceptionNaming(e, "[" + this.getClassName() + "]: Impossible to decode the String to long: " + en);
        }
    }

    public boolean codingSupported(int codingtype) {
        switch (codingtype) {
            case 16: 
            case 512: 
            case 1024: {
                return true;
            }
        }
        return false;
    }

    public String encodeString(PName pn) throws PExceptionNaming {
        return "" + ((RdbSequencePName)pn).value;
    }
}

