/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.log4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.wrapper.common.AbstractFactory;
import org.objectweb.util.monolog.wrapper.log4j.PatternConverter;

public class GenericHandler
implements Appender,
Handler {
    public static final String APPENDER_CLASS_NAME_ATTR = "appenderClassName";
    protected Appender appender = null;
    protected String name = null;
    protected HashMap prop = null;
    protected ArrayList filters = null;
    protected Layout layout = null;

    public GenericHandler() {
    }

    public GenericHandler(String name) {
        this.name = name;
    }

    public GenericHandler(Appender a) {
        this.appender = a;
        this.prop = new HashMap();
    }

    public Appender getAppender() {
        return this.appender;
    }

    public void setAppender(Appender a) {
        this.appender = a;
        if (this.layout != null) {
            this.appender.setLayout(this.layout);
        }
        if (this.filters != null) {
            Iterator it = this.filters.iterator();
            while (it.hasNext()) {
                this.appender.addFilter((Filter)it.next());
            }
        }
    }

    public String getName() {
        this.name = this.appender.getName();
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
        if (this.appender != null) {
            this.appender.setName(n);
        }
    }

    public String getType() {
        return "generic";
    }

    public String[] getAttributeNames() {
        return this.prop.keySet().toArray(new String[0]);
    }

    public Object getAttribute(String key) {
        return this.prop.get(key);
    }

    public Object setAttribute(String key, Object value) {
        if (this.prop == null) {
            this.prop = new HashMap();
        }
        if (!key.equalsIgnoreCase("activation")) {
            return this.prop.put(key, value);
        }
        if (this.prop.containsKey(key)) {
            return null;
        }
        if (APPENDER_CLASS_NAME_ATTR.equalsIgnoreCase(key)) {
            try {
                Appender _appender = (Appender)Class.forName((String)value).newInstance();
                if (this.name != null) {
                    _appender.setName(this.name);
                }
                this.setAppender(_appender);
            }
            catch (Exception e) {
                AbstractFactory.warn("setAttribute failed " + e.getMessage());
            }
        }
        String pattern = (String)this.prop.get("pattern");
        this.setLayout((Layout)new PatternLayout(PatternConverter.monolog2log4j(pattern)));
        return null;
    }

    public void addFilter(Filter newFilter) {
        if (this.appender != null) {
            this.appender.addFilter(newFilter);
        } else {
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            this.filters.add(newFilter);
        }
    }

    public void clearFilters() {
        if (this.appender != null) {
            this.appender.clearFilters();
        } else if (this.filters != null) {
            this.filters.clear();
        }
    }

    public void close() {
        if (this.appender != null) {
            this.appender.close();
        }
    }

    public void doAppend(LoggingEvent event) {
        if (this.appender != null) {
            this.appender.doAppend(event);
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (this.appender != null) {
            this.appender.setErrorHandler(errorHandler);
        }
    }

    public void setLayout(Layout layout) {
        if (this.appender != null) {
            this.appender.setLayout(layout);
        } else {
            this.layout = layout;
        }
    }

    public Filter getFilter() {
        if (this.appender != null) {
            return this.appender.getFilter();
        }
        if (this.filters != null && this.filters.size() > 0) {
            return (Filter)this.filters.get(0);
        }
        return null;
    }

    public ErrorHandler getErrorHandler() {
        return this.appender != null ? this.appender.getErrorHandler() : null;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public boolean requiresLayout() {
        return this.appender != null ? this.appender.requiresLayout() : true;
    }
}

