/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.vm;

import java.util.Iterator;
import org.mule.MuleManager;
import org.mule.config.QueueProfile;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleMessage;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.providers.AbstractConnector;
import org.mule.providers.vm.VMMessageReceiver;
import org.mule.routing.filters.WildcardFilter;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.MessagingException;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.MessageTypeNotSupportedException;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.ClassUtils;
import org.mule.util.queue.QueueManager;
import org.mule.util.queue.QueueSession;

public class VMConnector
extends AbstractConnector {
    private boolean queueEvents = false;
    private QueueProfile queueProfile;
    private Class adapterClass = null;
    private int queueTimeout = 1000;

    protected void doInitialise() throws InitialisationException {
        if (this.queueEvents && this.queueProfile == null) {
            this.queueProfile = MuleManager.getConfiguration().getQueueProfile();
        }
        try {
            this.adapterClass = ClassUtils.loadClass(this.serviceDescriptor.getMessageAdapter(), this.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new InitialisationException(CoreMessages.failedToLoad("Message Adapter: " + this.serviceDescriptor.getMessageAdapter()), (Object)e);
        }
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws UMOException {
    }

    protected void doStop() throws UMOException {
    }

    public UMOMessageReceiver createReceiver(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        if (this.queueEvents) {
            this.queueProfile.configureQueue(endpoint.getEndpointURI().getAddress());
        }
        return this.serviceDescriptor.createMessageReceiver(this, component, endpoint);
    }

    public UMOMessageAdapter getMessageAdapter(Object message) throws MessagingException {
        if (message == null) {
            throw new MessageTypeNotSupportedException((Object)null, this.adapterClass);
        }
        if (message instanceof MuleMessage) {
            return ((MuleMessage)message).getAdapter();
        }
        if (message instanceof UMOMessageAdapter) {
            return (UMOMessageAdapter)message;
        }
        throw new MessageTypeNotSupportedException(message, this.adapterClass);
    }

    public String getProtocol() {
        return "VM";
    }

    public boolean isQueueEvents() {
        return this.queueEvents;
    }

    public void setQueueEvents(boolean queueEvents) {
        this.queueEvents = queueEvents;
    }

    public QueueProfile getQueueProfile() {
        return this.queueProfile;
    }

    public void setQueueProfile(QueueProfile queueProfile) {
        this.queueProfile = queueProfile;
    }

    VMMessageReceiver getReceiver(UMOEndpointURI endpointUri) throws EndpointException {
        return (VMMessageReceiver)this.getReceiverByEndpoint(endpointUri);
    }

    QueueSession getQueueSession() throws InitialisationException {
        QueueManager qm = MuleManager.getInstance().getQueueManager();
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx != null && tx.hasResource(qm)) {
            QueueSession queueSession = (QueueSession)tx.getResource(qm);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Retrieved VM queue session " + queueSession + " from current transaction " + tx);
            }
            return queueSession;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Retrieving new VM queue session from queue manager");
        }
        QueueSession session = qm.getQueueSession();
        if (tx != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Binding VM queue session " + session + " to current transaction " + tx);
            }
            try {
                tx.bindResource(qm, session);
            }
            catch (TransactionException e) {
                throw new RuntimeException("Could not bind queue session to current transaction", e);
            }
        }
        return session;
    }

    protected UMOMessageReceiver getReceiverByEndpoint(UMOEndpointURI endpointUri) throws EndpointException {
        UMOMessageReceiver receiver;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Looking up vm receiver for address: " + endpointUri.toString());
        }
        if ((receiver = (UMOMessageReceiver)this.receivers.get(endpointUri.getAddress())) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found exact receiver match on endpointUri: " + endpointUri);
            }
            return receiver;
        }
        Iterator iterator = this.receivers.values().iterator();
        while (iterator.hasNext()) {
            receiver = (UMOMessageReceiver)iterator.next();
            String filterAddress = receiver.getEndpointURI().getAddress();
            WildcardFilter filter = new WildcardFilter(filterAddress);
            if (!filter.accept(endpointUri.getAddress())) continue;
            receiver.getEndpoint().setEndpointURI(new MuleEndpointURI(endpointUri, filterAddress));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found receiver match on endpointUri: " + receiver.getEndpointURI() + " against " + endpointUri);
            }
            return receiver;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("No receiver found for endpointUri: " + endpointUri);
        }
        return null;
    }

    public boolean isRemoteSyncEnabled() {
        return true;
    }

    public int getQueueTimeout() {
        return this.queueTimeout;
    }

    public void setQueueTimeout(int queueTimeout) {
        this.queueTimeout = queueTimeout;
    }
}

