/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.df.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleNumberResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collectors.JCollector;
import org.ow2.jasmine.probe.collectors.df.internal.DfCollector;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class DiskFree
extends Thread {
    private Log logger = LogFactory.getLog(JCollector.class);
    private boolean started = false;
    private long collectorTimeout = 1000L;
    private static final long DEFAULT_TIMEOUT = 1000L;
    private Collection<DfCollector> collectors = new ArrayList<DfCollector>();
    private HashMap<String, Integer> freespace = null;

    public synchronized void remove() {
        this.started = false;
    }

    public synchronized void addCollector(DfCollector col) {
        this.collectors.add(col);
        if (!this.started) {
            this.started = true;
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.started) {
            ArrayList<DfCollector> collupdate = new ArrayList<DfCollector>();
            DiskFree diskFree = this;
            synchronized (diskFree) {
                for (Object coll : this.collectors) {
                    if (!coll.needResult()) continue;
                    collupdate.add((DfCollector)((Object)coll));
                }
            }
            if (!collupdate.isEmpty()) {
                long time = System.currentTimeMillis();
                try {
                    Object coll;
                    this.getDiskUsage();
                    coll = this;
                    synchronized (coll) {
                        for (DfCollector coll2 : collupdate) {
                            JasmineSingleResult jsr;
                            Integer val;
                            String name = coll2.getIndicator().getName();
                            JasmineIndicatorValue jiv = new JasmineIndicatorValue();
                            jiv.setName(name);
                            if (coll2.getDiskList() == null) {
                                for (String disk : this.freespace.keySet()) {
                                    val = this.freespace.get(disk);
                                    if (val == null) {
                                        this.logger.error((Object)("No value for " + disk), new Object[0]);
                                    }
                                    jsr = this.getJsr(disk, time, val);
                                    jiv.addValue(jsr);
                                }
                            } else {
                                for (String disk : coll2.getDiskList()) {
                                    val = this.freespace.get(disk);
                                    if (val == null) {
                                        this.logger.error((Object)("No value for " + disk), new Object[0]);
                                    }
                                    jsr = this.getJsr(disk, time, val);
                                    jiv.addValue(jsr);
                                }
                            }
                            coll2.addResult(jiv);
                        }
                    }
                    this.collectorTimeout = 1000L;
                }
                catch (IOException e) {
                    this.logger.error((Object)("Cannot run df: " + e), new Object[0]);
                    this.collectorTimeout *= 2L;
                }
                catch (InterruptedException e) {
                    this.logger.error((Object)("Cannot run df: " + e), new Object[0]);
                    this.collectorTimeout *= 2L;
                }
            }
            diskFree = this;
            synchronized (diskFree) {
                try {
                    this.wait(this.collectorTimeout);
                }
                catch (InterruptedException e) {
                    this.logger.warn((Object)(this.getName() + ": collector interrupted"), new Object[]{e});
                }
                catch (Exception e) {
                    this.logger.warn((Object)(this.getName() + ": collector exception"), new Object[]{e});
                }
            }
        }
    }

    private void getDiskUsage() throws IOException, InterruptedException {
        String line;
        this.freespace = new HashMap();
        String cmd = "df -l";
        Runtime run = Runtime.getRuntime();
        Process pr = run.exec(cmd);
        pr.waitFor();
        BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        while ((line = buf.readLine()) != null) {
            if (!line.startsWith("/dev/")) continue;
            StringTokenizer stk = new StringTokenizer(line);
            String name = stk.nextToken().substring(5);
            Integer free = 0;
            while (stk.hasMoreTokens()) {
                String tok = stk.nextToken();
                int len = tok.length();
                if (!tok.endsWith("%") || len <= 1) continue;
                free = new Integer(tok.substring(0, len - 1));
            }
            this.freespace.put(name, free);
        }
    }

    private JasmineSingleResult getJsr(String disk, long time, int value) {
        JasmineSingleNumberResult jsr = new JasmineSingleNumberResult();
        jsr.setName(disk);
        jsr.setTimestamp(time);
        jsr.setValue((Object)value);
        return jsr;
    }
}

