/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.make.coverage;

import aQute.bnd.make.coverage.Coverage;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.WriteResource;
import aQute.lib.tag.Tag;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageResource
extends WriteResource {
    Collection<Clazz> testsuite;
    Collection<Clazz> service;

    public CoverageResource(Collection<Clazz> testsuite, Collection<Clazz> service) {
        this.testsuite = testsuite;
        this.service = service;
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream out) throws IOException {
        try {
            Map<Clazz.MethodDef, List<Clazz.MethodDef>> table = Coverage.getCrossRef(this.testsuite, this.service);
            Tag coverage = CoverageResource.toTag(table);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
            try {
                coverage.print(0, pw);
            }
            finally {
                pw.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Tag toTag(Map<Clazz.MethodDef, List<Clazz.MethodDef>> catalog) {
        Tag coverage = new Tag("coverage");
        String currentClass = null;
        Tag classTag = null;
        for (Map.Entry<Clazz.MethodDef, List<Clazz.MethodDef>> m : catalog.entrySet()) {
            String className = m.getKey().clazz;
            if (!className.equals(currentClass)) {
                classTag = new Tag("class");
                classTag.addAttribute("name", className);
                classTag.addAttribute("package", Clazz.getPackage(className));
                classTag.addAttribute("short", Clazz.getShortName(className));
                coverage.addContent(classTag);
                currentClass = className;
            }
            Tag method = CoverageResource.doMethod(new Tag("method"), m.getKey());
            classTag.addContent(method);
            for (Clazz.MethodDef r : m.getValue()) {
                Tag ref = CoverageResource.doMethod(new Tag("ref"), r);
                method.addContent(ref);
            }
        }
        return coverage;
    }

    private static Tag doMethod(Tag tag, Clazz.MethodDef method) {
        tag.addAttribute("pretty", method.getPretty());
        if (Modifier.isPublic(method.access)) {
            tag.addAttribute("public", true);
        }
        if (Modifier.isStatic(method.access)) {
            tag.addAttribute("static", true);
        }
        if (Modifier.isProtected(method.access)) {
            tag.addAttribute("protected", true);
        }
        if (Modifier.isInterface(method.access)) {
            tag.addAttribute("interface", true);
        }
        tag.addAttribute("constructor", method.isConstructor());
        if (!method.isConstructor()) {
            tag.addAttribute("name", method.name);
        }
        tag.addAttribute("descriptor", method.descriptor);
        return tag;
    }
}

