/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.merge.internal;

import java.util.Collection;
import java.util.HashMap;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleNumberResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;

public class JMergeCollector
extends JCollector {
    private int ope;
    private String operation;
    public static final int OP_MIN = 1;
    public static final int OP_MAX = 2;
    public static final int OP_SUM = 3;
    public static final int OP_AVERAGE = 4;
    private JasmineCollector source = null;

    public JMergeCollector(String name, JasmineIndicator def, int period, String operation, JasmineCollector source, String merged) {
        super(name, def, period);
        this.operation = operation;
        this.ope = 0;
        if (operation.equalsIgnoreCase("min")) {
            this.ope = 1;
        } else if (operation.equalsIgnoreCase("max")) {
            this.ope = 2;
        } else if (operation.equalsIgnoreCase("sum")) {
            this.ope = 3;
        } else if (operation.equalsIgnoreCase("average")) {
            this.ope = 4;
        }
        this.source = source;
    }

    public JasmineIndicatorValue getLastResult() throws JasmineCollectorException {
        this.logger.debug((Object)"", new Object[0]);
        JasmineIndicatorValue current = this.source.getLastResult();
        if (current == null) {
            return null;
        }
        JasmineIndicatorValue jiv = new JasmineIndicatorValue();
        jiv.setName(this.indicator.getName());
        jiv.addMetadata("op", this.operation);
        for (String key : current.getMetadata().keySet()) {
            if (key.equals("op")) continue;
            jiv.addMetadata(key, (String)current.getMetadata().get(key));
        }
        jiv.setTarget(current.getTarget());
        Collection jsrs = current.getValues();
        long timestamp = System.currentTimeMillis();
        HashMap jsrProps = this.jsrProps(jsrs);
        JasmineSingleNumberResult jsrm = new JasmineSingleNumberResult();
        Number resval = null;
        switch (this.ope) {
            case 2: {
                resval = this.maxJsr(jsrs);
                break;
            }
            case 1: {
                resval = this.minJsr(jsrs);
                break;
            }
            case 3: {
                resval = this.addJsr(jsrs);
                break;
            }
            case 4: {
                resval = this.averageJsr(jsrs);
                break;
            }
            default: {
                throw new JasmineCollectorException("Unimplemented merge operation " + this.ope);
            }
        }
        jsrm.setName(this.indicator.getName());
        jsrm.setTimestamp(timestamp);
        jsrm.setValue((Object)resval);
        jsrm.setProperties(jsrProps);
        jiv.addValue((JasmineSingleResult)jsrm);
        return jiv;
    }

    public void stopPolling() {
        this.logger.debug((Object)"", new Object[0]);
    }

    public void startPolling() {
        this.logger.debug((Object)"", new Object[0]);
    }
}

