/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.probescheduler.internal;

import org.ow2.jasmine.probe.probescheduler.SchedulerService;
import org.ow2.jasmine.probe.probescheduler.TaskReference;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class TaskReferenceImpl
implements TaskReference {
    private Log logger = LogFactory.getLog(SchedulerService.class);
    private Runnable listener = null;
    private long remaining;
    private long startvalue;
    private long createtime;
    private boolean permanent = false;
    private boolean stopped = false;

    public TaskReferenceImpl(Runnable l, long timeout, boolean p) {
        this.listener = l;
        this.remaining = timeout;
        this.startvalue = timeout;
        this.createtime = System.currentTimeMillis();
        this.permanent = p;
    }

    public long restart() {
        this.logger.debug((Object)"", new Object[0]);
        this.stopped = false;
        this.createtime = System.currentTimeMillis() + this.remaining;
        this.remaining += this.startvalue;
        return this.remaining;
    }

    public void process() {
        if (this.listener != null) {
            this.logger.debug((Object)("remaining = " + this.remaining), new Object[0]);
            this.listener.run();
        }
    }

    public long update() {
        this.remaining = this.startvalue + this.createtime - System.currentTimeMillis();
        return this.remaining;
    }

    public boolean valid() {
        return this.listener != null;
    }

    public boolean ispermanent() {
        return this.permanent;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void cancel(boolean interrupt) {
        this.logger.debug((Object)"", new Object[0]);
        this.remaining = 100L;
        this.listener = null;
        this.permanent = false;
        this.stopped = false;
    }
}

