/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.probemanager.ProbeManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JCollector
implements JasmineCollector {
    protected Log logger = LogFactory.getLog(JCollector.class);
    protected JasmineIndicator indicator;
    protected int period;
    protected String name;
    protected ProbeManager probeManager = null;
    protected String hostName = null;

    public JCollector(String name, JasmineIndicator def, int period) {
        this.name = name;
        this.indicator = def;
        this.period = period;
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.logger.warn((Object)"Cannot get host name for indicator {0} ({1})", new Object[]{def.getName(), e.toString()});
        }
    }

    public JasmineIndicator getIndicator() {
        return this.indicator;
    }

    public void setProbeManager(ProbeManager probeManager) {
        this.probeManager = probeManager;
    }

    protected String getDomainName() {
        return this.probeManager.getDomainName();
    }

    protected String getServerName() {
        return this.probeManager.getServerName();
    }

    public String getName() {
        return this.name;
    }

    public abstract JasmineIndicatorValue getLastResult() throws JasmineCollectorException;

    public abstract void stopPolling();

    public abstract void startPolling();

    private Number max(Collection<Number> coll) throws JasmineCollectorException {
        Number ret = null;
        for (Number val : coll) {
            if (ret == null) {
                ret = val;
                continue;
            }
            if (this.diffValues(val, ret) <= 0L) continue;
            ret = val;
        }
        return ret;
    }

    protected Number maxJsr(Collection<JasmineSingleResult> jsrs) throws JasmineCollectorException {
        try {
            Collection<Number> numList = this.getNumList(jsrs);
            return this.max(numList);
        }
        catch (ClassCastException ce) {
            throw new JasmineCollectorException("Aggregation of incompatible types (max operation expects only Number values)");
        }
    }

    private Number min(Collection<Number> coll) throws JasmineCollectorException {
        Number ret = null;
        for (Number val : coll) {
            if (ret == null) {
                ret = val;
                continue;
            }
            if (this.diffValues(val, ret) >= 0L) continue;
            ret = val;
        }
        return ret;
    }

    protected Number minJsr(Collection<JasmineSingleResult> jsrs) throws JasmineCollectorException {
        try {
            Collection<Number> numList = this.getNumList(jsrs);
            return this.min(numList);
        }
        catch (ClassCastException ce) {
            throw new JasmineCollectorException("Aggregation of incompatible types (min operation expects only Number values)");
        }
    }

    private Number average(Collection<Number> coll) throws JasmineCollectorException {
        long ret = this.addValues(coll);
        int nbval = coll.size();
        return ret / (long)nbval;
    }

    protected Number averageJsr(Collection<JasmineSingleResult> jsrs) throws JasmineCollectorException {
        try {
            Collection<Number> numList = this.getNumList(jsrs);
            return this.average(numList);
        }
        catch (ClassCastException ce) {
            throw new JasmineCollectorException("Aggregation of incompatible types (min operation expects only Number values)");
        }
    }

    protected long diffValues(Number v1, Number v2) throws JasmineCollectorException {
        return this.longValue(v1) - this.longValue(v2);
    }

    protected long diffJsr(Collection<JasmineSingleResult> jsrs) throws JasmineCollectorException {
        if (jsrs.size() != 2) {
            throw new JasmineCollectorException("Diff correlation with more that 2 values not supported");
        }
        JasmineSingleResult jsr1 = null;
        JasmineSingleResult jsr2 = null;
        for (JasmineSingleResult jsr : jsrs) {
            if (jsr1 == null) {
                jsr1 = jsr;
                continue;
            }
            jsr2 = jsr;
        }
        try {
            Number num1 = (Number)jsr1.getValue();
            Number num2 = (Number)jsr2.getValue();
            return this.diffValues(num1, num2);
        }
        catch (ClassCastException ce) {
            throw new JasmineCollectorException("Correlation of incompatible types (diff operation expects only Number values)");
        }
    }

    protected float divideValues(Number v1, Number v2) throws JasmineCollectorException {
        if (this.longValue(v2) == 0L) {
            return 1.0f;
        }
        return this.longValue(v1) / this.longValue(v2);
    }

    protected float divideJsr(Collection<JasmineSingleResult> jsrs) throws JasmineCollectorException {
        if (jsrs.size() != 2) {
            throw new JasmineCollectorException("Diff correlation with more that 2 values not supported");
        }
        JasmineSingleResult jsr1 = null;
        JasmineSingleResult jsr2 = null;
        for (JasmineSingleResult jsr : jsrs) {
            if (jsr1 == null) {
                jsr1 = jsr;
                continue;
            }
            jsr2 = jsr;
        }
        try {
            Number num1 = (Number)jsr1.getValue();
            Number num2 = (Number)jsr2.getValue();
            return this.divideValues(num1, num2);
        }
        catch (ClassCastException ce) {
            throw new JasmineCollectorException("Correlation of incompatible types (diff operation expects only Number values)");
        }
    }

    protected long addValues(Collection<Number> values) throws JasmineCollectorException {
        long ret = 0L;
        for (Number o : values) {
            ret += this.longValue(o);
        }
        return ret;
    }

    protected long addJsr(Collection<JasmineSingleResult> jsrs) throws JasmineCollectorException {
        try {
            Collection<Number> numList = this.getNumList(jsrs);
            return this.addValues(numList);
        }
        catch (ClassCastException ce) {
            throw new JasmineCollectorException("Correlation of incompatible types (add operation expects only Number values)");
        }
    }

    protected long multiplyValues(Collection<Number> values) throws JasmineCollectorException {
        long ret = 0L;
        for (Number o : values) {
            ret *= this.longValue(o);
        }
        return ret;
    }

    protected long multiplyJsr(Collection<JasmineSingleResult> jsrs) throws JasmineCollectorException {
        try {
            Collection<Number> numList = this.getNumList(jsrs);
            return this.multiplyValues(numList);
        }
        catch (ClassCastException ce) {
            throw new JasmineCollectorException("Correlation of incompatible types (multiply operation expects only Number values)");
        }
    }

    private Collection<Number> getNumList(Collection<JasmineSingleResult> jsrs) throws ClassCastException {
        ArrayList<Number> numList = new ArrayList<Number>();
        for (JasmineSingleResult jsr : jsrs) {
            Number value = (Number)jsr.getValue();
            numList.add(value);
        }
        return numList;
    }

    protected long longValue(Number nb) throws JasmineCollectorException {
        long val;
        if (nb instanceof Integer) {
            val = ((Integer)nb).longValue();
        } else if (nb instanceof Long) {
            val = (Long)nb;
        } else if (nb instanceof Short) {
            val = ((Short)nb).longValue();
        } else if (nb instanceof Float) {
            this.logger.debug((Object)("Float value cast to a long: " + nb), new Object[0]);
            val = ((Float)nb).longValue();
        } else {
            throw new JasmineCollectorException("This Number cannot be converted to a long: " + nb);
        }
        return val;
    }

    protected HashMap<String, String> jsrProps(Collection<JasmineSingleResult> jsrs) {
        HashMap<String, String> jsrProps = new HashMap<String, String>();
        for (JasmineSingleResult jsr : jsrs) {
            jsrProps.putAll(jsr.getProperties());
        }
        return jsrProps;
    }
}

