/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.tcp.TcpConnector;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.transformer.TransformerException;

public class TcpMessageDispatcher
extends AbstractMessageDispatcher {
    private final TcpConnector connector;

    public TcpMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (TcpConnector)endpoint.getConnector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doDispatch(UMOEvent event) throws Exception {
        Socket socket = this.connector.getSocket(event.getEndpoint());
        try {
            this.dispatchToSocket(socket, event);
        }
        finally {
            this.connector.releaseSocket(socket, event.getEndpoint());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized UMOMessage doSend(UMOEvent event) throws Exception {
        Socket socket = this.connector.getSocket(event.getEndpoint());
        try {
            this.dispatchToSocket(socket, event);
            if (this.useRemoteSync(event)) {
                try {
                    Object result = this.receiveFromSocket(socket, event.getTimeout());
                    if (result == null) {
                        UMOMessage uMOMessage = null;
                        return uMOMessage;
                    }
                    MuleMessage muleMessage = new MuleMessage(this.connector.getMessageAdapter(result));
                    return muleMessage;
                }
                catch (SocketTimeoutException e) {
                    this.logger.info("Socket timed out normally while doing a synchronous receive on endpointUri: " + event.getEndpoint().getEndpointURI());
                    UMOMessage uMOMessage = null;
                    return uMOMessage;
                }
            }
            UMOMessage uMOMessage = event.getMessage();
            return uMOMessage;
        }
        finally {
            this.connector.releaseSocket(socket, event.getEndpoint());
        }
    }

    private void dispatchToSocket(Socket socket, UMOEvent event) throws Exception {
        Object payload = event.getTransformedMessage();
        this.write(socket, payload);
    }

    private void write(Socket socket, Object data) throws IOException, TransformerException {
        BufferedOutputStream bos = new BufferedOutputStream(socket.getOutputStream());
        this.connector.getTcpProtocol().write(bos, data);
        bos.flush();
    }

    private Object receiveFromSocket(Socket socket, int timeout) throws IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        if (timeout >= 0) {
            socket.setSoTimeout(timeout);
        }
        return this.connector.getTcpProtocol().read(dis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UMOMessage doReceive(long timeout) throws Exception {
        Socket socket = this.connector.getSocket(this.endpoint);
        try {
            Object result = this.receiveFromSocket(socket, (int)timeout);
            if (result == null) {
                UMOMessage uMOMessage = null;
                return uMOMessage;
            }
            MuleMessage muleMessage = new MuleMessage(this.connector.getMessageAdapter(result));
            return muleMessage;
        }
        catch (SocketTimeoutException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Socket timed out normally while doing a synchronous receive on endpointUri: " + this.endpoint.getEndpointURI());
            }
            UMOMessage uMOMessage = null;
            return uMOMessage;
        }
        finally {
            this.connector.releaseSocket(socket, this.endpoint);
        }
    }

    protected synchronized void doDispose() {
        try {
            this.doDisconnect();
        }
        catch (Exception e) {
            this.logger.error("Failed to shutdown the dispatcher.", e);
        }
    }

    protected void doConnect() throws Exception {
        if (this.connector.isValidateConnections()) {
            Socket socket = this.connector.getSocket(this.endpoint);
            this.connector.releaseSocket(socket, this.endpoint);
        }
    }

    protected void doDisconnect() throws Exception {
    }
}

