/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import org.mule.routing.inbound.EventGroup;
import org.mule.routing.response.AbstractResponseAggregator;
import org.mule.umo.UMOEvent;

public abstract class ResponseCorrelationAggregator
extends AbstractResponseAggregator {
    protected boolean shouldAggregateEvents(EventGroup events) {
        int expected = events.expectedSize();
        int current = events.size();
        if (expected == -1) {
            this.logger.warn("Correlation Group Size not set, but CorrelationAggregator is being used.  Message is being forwarded");
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Correlation size is " + expected + ", current event group size is " + current + " for correlation group " + events.getGroupId());
        }
        return expected == current;
    }

    protected EventGroup createEventGroup(UMOEvent event, Object id) {
        return new EventGroup(id, event.getMessage().getCorrelationGroupSize());
    }
}

