#!/bin/sh
# ---------------------------------------------------------------------------
# JASMINe
# Copyright (C) 2011 Bull S.A.S.
# Contact: jasmine@ow2.org
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA
#
# ---------------------------------------------------------------------------
# $Id: jasmine-probe.sh 7684 2011-02-04 08:50:51Z jlegrand $
# ---------------------------------------------------------------------------

export JONAS_ROOT=${JASMINE_PROBE_PATH}

# Check if $JONAS_ROOT is set.
if [ -z "$JONAS_ROOT" ]; then
    echo Please set the JASMINE_PROBE_PATH variable.
    exit
fi

export JONAS_BASE=$JONAS_ROOT
export PATH=$JONAS_ROOT/bin:$PATH

#export OPTS=-Dhttp.proxyHost=
#export OPTS=$OPTS -Dhttp.proxyPort=8080
#export OPTS=$OPTS -Dhttp.nonProxyHosts="localhost|127.0.0.1"

# ---------------------------------------------
# Get arguments
# ---------------------------------------------
ARGS=

case "$1" in
  start)
    jonas start -tui -n jasmine-probe -clean -fg -Djava.net.preferIPv4Stack=true $OPTS
    ;;
  stop)
    jonas stop -n jasmine-probe
    ;;
  *)
    echo "usage : jasmine-probe start | stop"
esac
