/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.correlate.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleNumberResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;

public class CorrelateCollector
extends JCollector {
    private int ope;
    private Collection<JasmineCollector> sources;

    public CorrelateCollector(String key, JasmineIndicator indic, int period, int ope, Collection<JasmineCollector> sources) {
        super(key, indic, period);
        this.ope = ope;
        this.sources = sources;
    }

    public JasmineIndicatorValue getLastResult() throws JasmineCollectorException {
        this.logger.debug((Object)"", new Object[0]);
        JasmineIndicatorValue jiv = new JasmineIndicatorValue();
        jiv.setName(this.indicator.getName());
        HashMap jsrProps = new HashMap();
        ArrayList<JasmineSingleResult> jsrList = new ArrayList<JasmineSingleResult>();
        String domain = null;
        String server = null;
        String target = null;
        String mbean = null;
        long timestamp = 0L;
        for (JasmineCollector elem : this.sources) {
            String t;
            String s;
            String d;
            JasmineIndicatorValue jivs = elem.getLastResult();
            this.logger.debug((Object)"Get value of source indicator {0} for correlate indicator {1} ", new Object[]{elem.getIndicatorName(), this.indicator.getName()});
            if (jivs == null) {
                this.logger.warn((Object)"Cannot obtain result for indicator {0} because no available value for source indicator {1} (null)", new Object[]{this.getIndicatorName(), elem.getIndicatorName()});
                return null;
            }
            if (timestamp == 0L) {
                timestamp = jivs.getTimestamp();
            } else if (jivs.getTimestamp() > timestamp) {
                timestamp = jivs.getTimestamp();
            }
            if (jivs.getValues().isEmpty()) {
                this.logger.warn((Object)"Cannot obtain result for indicator {0} because no available value for source indicator {1} (values is empty)", new Object[]{this.getIndicatorName(), elem.getIndicatorName()});
                return null;
            }
            if (jivs.getValues().size() > 1) {
                this.logger.warn((Object)"Correlation on multivalued indicator not supported", new Object[0]);
                throw new JasmineCollectorException("Correlation on multivalued indicator not supported");
            }
            Iterator i$ = jivs.getValues().iterator();
            if (i$.hasNext()) {
                JasmineSingleResult jsr1 = (JasmineSingleResult)i$.next();
                jsrList.add(jsr1);
                HashMap jsr1Props = jsr1.getProperties();
                for (String key : jsr1Props.keySet()) {
                    if (key.equals("mbean")) {
                        String mbeanValue = (String)jsr1Props.get(key);
                        if (mbean == null) {
                            mbean = mbeanValue;
                            continue;
                        }
                        if (mbean.equals(mbeanValue)) continue;
                        mbean = "misc:type=correlate";
                        continue;
                    }
                    jsrProps.put(key, jsr1Props.get(key));
                }
            }
            if ((d = (String)jivs.getMetadata().get("domain")) != null) {
                if (domain == null) {
                    domain = d;
                } else if (!d.equals(domain)) {
                    domain = "misc";
                }
            }
            if ((s = (String)jivs.getMetadata().get("server")) != null) {
                if (server == null) {
                    server = s;
                } else if (!s.equals(server)) {
                    server = "misc";
                }
            }
            if ((t = jivs.getTarget()) == null) continue;
            if (target == null) {
                target = t;
                continue;
            }
            if (t.equals(target)) continue;
            target = "misc";
        }
        jiv.addMetadata("domain", domain);
        jiv.addMetadata("server", server);
        jiv.setTarget(target);
        if (jsrList.isEmpty()) {
            this.logger.warn((Object)"No result available for correlate indicator {0}", new Object[]{this.indicator.getName()});
            return null;
        }
        Number result = 0;
        switch (this.ope) {
            case 1: {
                result = this.addJsr(jsrList);
                break;
            }
            case 2: {
                result = this.diffJsr(jsrList);
                break;
            }
            case 3: {
                result = this.multiplyJsr(jsrList);
                break;
            }
            case 4: {
                result = this.divideJsr(jsrList);
                break;
            }
            case 5: {
                Number div = this.divideJsr(jsrList);
                result = 100.0 * div.doubleValue();
                break;
            }
            default: {
                throw new JasmineCollectorException("Bad correlate operation");
            }
        }
        if (this.indicator.getScale() != 1) {
            result = this.divideValues(result, this.indicator.getScale());
        }
        JasmineSingleNumberResult jsr = new JasmineSingleNumberResult();
        jsr.setTimestamp(timestamp);
        jsr.setValue((Object)result);
        jsr.setName("");
        jsrProps.put("mbean", mbean);
        jsr.setProperties(jsrProps);
        jiv.addValue((JasmineSingleResult)jsr);
        jiv.setMultiValue(false);
        return jiv;
    }

    public void stopPolling() {
        this.logger.debug((Object)("Stop " + this.indicator.getName() + " in probe " + this.probeId), new Object[0]);
        for (JasmineCollector source : this.sources) {
            source.stopPolling();
        }
    }

    public void startPolling() {
        this.logger.debug((Object)("Start " + this.indicator.getName() + " in probe " + this.probeId), new Object[0]);
        for (JasmineCollector source : this.sources) {
            source.startPolling();
        }
    }
}

